/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.jetty;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.jetty.http.HttpScheme;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.bootstrap.jetty.ConnectorConfiguration;
import org.sonatype.nexus.bootstrap.jetty.ConnectorRegistrar;
import org.sonatype.nexus.bootstrap.jetty.JettyServerConfiguration;
import org.sonatype.nexus.bootstrap.jetty.UnsupportedHttpSchemeException;

@Singleton
@Named
public class ConnectorRegistrarImpl
extends ComponentSupport
implements ConnectorRegistrar {
    private final JettyServerConfiguration serverConfiguration;
    private final IdentityHashMap<ConnectorConfiguration, ServiceRegistration<ConnectorConfiguration>> managedConfigurations;

    @Inject
    public ConnectorRegistrarImpl(JettyServerConfiguration serverConfiguration) {
        this.serverConfiguration = (JettyServerConfiguration)Preconditions.checkNotNull((Object)serverConfiguration);
        this.managedConfigurations = Maps.newIdentityHashMap();
    }

    public List<HttpScheme> availableSchemes() {
        ArrayList<HttpScheme> result = new ArrayList<HttpScheme>();
        for (ConnectorConfiguration defaultConnector : this.serverConfiguration.defaultConnectors()) {
            result.add(defaultConnector.getScheme());
        }
        return result;
    }

    public List<Integer> unavailablePorts() {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (ConnectorConfiguration defaultConnector : this.serverConfiguration.defaultConnectors()) {
            result.add(defaultConnector.getPort());
        }
        for (ConnectorConfiguration defaultConnector : this.managedConfigurations.keySet()) {
            result.add(defaultConnector.getPort());
        }
        return result;
    }

    public void addConnector(ConnectorConfiguration connectorConfiguration) {
        Preconditions.checkNotNull((Object)connectorConfiguration);
        this.validate(connectorConfiguration);
        Bundle bundle = FrameworkUtil.getBundle(connectorConfiguration.getClass());
        if (bundle == null) {
            this.log.warn("No bundle found for {}, not registering connector", (Object)connectorConfiguration);
            return;
        }
        BundleContext bundleContext = bundle.getBundleContext();
        if (bundleContext == null) {
            this.log.warn("No context found for bundle {}, not registering connector", (Object)bundle);
            return;
        }
        this.log.info("Adding connector configuration {}", (Object)connectorConfiguration);
        ServiceRegistration serviceRegistration = bundleContext.registerService(ConnectorConfiguration.class, (Object)connectorConfiguration, null);
        this.managedConfigurations.put(connectorConfiguration, (ServiceRegistration<ConnectorConfiguration>)serviceRegistration);
    }

    public void removeConnector(ConnectorConfiguration connectorConfiguration) {
        Preconditions.checkNotNull((Object)connectorConfiguration);
        ServiceRegistration<ConnectorConfiguration> serviceRegistration = this.managedConfigurations.remove(connectorConfiguration);
        if (serviceRegistration != null) {
            this.log.info("Removing connector configuration {}", (Object)connectorConfiguration);
            try {
                serviceRegistration.unregister();
            }
            catch (IllegalStateException e) {
                this.log.debug("Could not unregister connector", (Throwable)e);
            }
        }
    }

    private void validate(ConnectorConfiguration connectorConfiguration) {
        Preconditions.checkArgument((!this.managedConfigurations.containsKey(connectorConfiguration) ? 1 : 0) != 0);
        HttpScheme httpScheme = connectorConfiguration.getScheme();
        Preconditions.checkNotNull((Object)httpScheme);
        if (!this.availableSchemes().contains(httpScheme)) {
            throw new UnsupportedHttpSchemeException(httpScheme);
        }
        int port = connectorConfiguration.getPort();
        Preconditions.checkArgument((port > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((port < 65536 ? 1 : 0) != 0);
        Preconditions.checkArgument((!this.unavailablePorts().contains(port) ? 1 : 0) != 0);
    }
}

