/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.log;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.audit.AuditData;
import org.sonatype.nexus.audit.AuditorSupport;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.log.LoggerLevel;
import org.sonatype.nexus.common.log.LoggerLevelChangedEvent;
import org.sonatype.nexus.common.log.LoggersResetEvent;

@Named
@Singleton
public class LoggingAuditor
extends AuditorSupport
implements EventAware {
    public static final String DOMAIN = "logging";

    @Subscribe
    @AllowConcurrentEvents
    public void on(LoggersResetEvent event) {
        if (this.isRecording()) {
            AuditData data = new AuditData();
            data.setDomain(DOMAIN);
            data.setType("reset");
            data.setContext("system");
            this.record(data);
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(LoggerLevelChangedEvent event) {
        if (this.isRecording()) {
            String logger = event.getLogger();
            LoggerLevel level = event.getLevel();
            AuditData data = new AuditData();
            data.setDomain(DOMAIN);
            data.setType("changed");
            data.setContext(logger);
            Map attributes = data.getAttributes();
            attributes.put("logger", logger);
            attributes.put("level", LoggingAuditor.string((Object)level));
            this.record(data);
        }
    }
}

