/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.scheduling;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.SimpleEmail;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.email.EmailManager;
import org.sonatype.nexus.scheduling.TaskInfo;
import org.sonatype.nexus.scheduling.events.TaskEventStoppedFailed;

@Singleton
@Named
public class NexusTaskFailureAlertEmailSender
extends ComponentSupport
implements EventAware,
EventAware.Asynchronous {
    private final Provider<EmailManager> emailManager;

    @Inject
    public NexusTaskFailureAlertEmailSender(Provider<EmailManager> emailManager) {
        this.emailManager = (Provider)Preconditions.checkNotNull(emailManager);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(TaskEventStoppedFailed event) {
        TaskInfo taskInfo = event.getTaskInfo();
        if (taskInfo == null || taskInfo.getConfiguration().getAlertEmail() == null) {
            return;
        }
        try {
            this.sendEmail(taskInfo.getConfiguration().getAlertEmail(), taskInfo.getId(), taskInfo.getName(), event.getFailureCause());
        }
        catch (Exception e) {
            this.log.warn("Failed to send email", (Throwable)e);
        }
    }

    private void sendEmail(String address, String taskId, String taskName, Throwable cause) throws Exception {
        SimpleEmail mail = new SimpleEmail();
        mail.setSubject("Task execution failure");
        mail.addTo(address);
        StringWriter buff = new StringWriter();
        PrintWriter out = new PrintWriter(buff);
        if (taskId != null) {
            out.format("Task ID: %s%n", taskId);
        }
        if (taskName != null) {
            out.format("Task Name: %s%n", taskName);
        }
        if (cause != null) {
            out.println("Stack-trace:");
            cause.printStackTrace(out);
        }
        mail.setMsg(buff.toString());
        ((EmailManager)this.emailManager.get()).send((Email)mail);
    }
}

