/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.script;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import org.sonatype.goodies.common.ComponentSupport;

@Named
@Singleton
public class ScriptEngineManagerProvider
extends ComponentSupport
implements Provider<ScriptEngineManager> {
    public static final String DEFAULT_LANGUAGE = "groovy";
    private final List<ScriptEngineFactory> factories;

    @Inject
    public ScriptEngineManagerProvider(List<ScriptEngineFactory> factories) {
        this.factories = (List)Preconditions.checkNotNull(factories);
    }

    public ScriptEngineManager get() {
        ScriptEngineManager engineManager = new ScriptEngineManager(ClassLoader.getSystemClassLoader());
        ArrayList<ScriptEngineFactory> available = new ArrayList<ScriptEngineFactory>();
        available.addAll(engineManager.getEngineFactories());
        for (ScriptEngineFactory factory : this.factories) {
            this.log.debug("Registering engine-factory: {}", (Object)factory);
            for (String name : factory.getNames()) {
                engineManager.registerEngineName(name, factory);
            }
            for (String mimeType : factory.getMimeTypes()) {
                engineManager.registerEngineMimeType(mimeType, factory);
            }
            for (String ext : factory.getExtensions()) {
                engineManager.registerEngineExtension(ext, factory);
            }
            available.add(factory);
        }
        this.log.info("Detected {} engine-factories", (Object)available.size());
        for (ScriptEngineFactory factory : available) {
            this.log.info("Engine-factory: {} v{}; language={}, version={}, names={}, mime-types={}, extensions={}", new Object[]{factory.getEngineName(), factory.getEngineVersion(), factory.getLanguageName(), factory.getLanguageVersion(), factory.getNames(), factory.getMimeTypes(), factory.getExtensions()});
        }
        this.log.info("Default language: {}", (Object)DEFAULT_LANGUAGE);
        return engineManager;
    }
}

