/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.script;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.i18n.I18N;
import org.sonatype.goodies.i18n.MessageBundle;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.formfields.FormField;
import org.sonatype.nexus.formfields.StringTextFormField;
import org.sonatype.nexus.formfields.TextAreaFormField;
import org.sonatype.nexus.internal.script.ScriptTask;
import org.sonatype.nexus.scheduling.TaskDescriptorSupport;

@Named
@Singleton
public class ScriptTaskDescriptor
extends TaskDescriptorSupport {
    public static final String TYPE_ID = "script";
    public static final String LANGUAGE = "language";
    public static final String SOURCE = "source";
    private static final Messages messages = (Messages)I18N.create(Messages.class);

    @Inject
    public ScriptTaskDescriptor(NodeAccess nodeAccess) {
        super(TYPE_ID, ScriptTask.class, messages.name(), true, true, new FormField[]{new StringTextFormField(LANGUAGE, messages.languageLabel(), messages.languageHelpText(), true).withInitialValue("groovy"), new TextAreaFormField(SOURCE, messages.sourceLabel(), messages.sourceHelpText(), true), nodeAccess.isClustered() ? ScriptTaskDescriptor.newMultinodeFormField() : null});
    }

    private static interface Messages
    extends MessageBundle {
        @MessageBundle.DefaultMessage(value="Admin - Execute script")
        public String name();

        @MessageBundle.DefaultMessage(value="Language")
        public String languageLabel();

        @MessageBundle.DefaultMessage(value="Script language")
        public String languageHelpText();

        @MessageBundle.DefaultMessage(value="Source")
        public String sourceLabel();

        @MessageBundle.DefaultMessage(value="Script source")
        public String sourceHelpText();
    }
}

