/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.security.apikey;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.ORecordDuplicatedException;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.internal.security.apikey.ApiKey;
import org.sonatype.nexus.internal.security.apikey.ApiKeyEntityAdapter;
import org.sonatype.nexus.internal.security.apikey.DefaultApiKeyFactory;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.transaction.OrientTransactional;
import org.sonatype.nexus.scheduling.CancelableHelper;
import org.sonatype.nexus.security.UserPrincipalsExpired;
import org.sonatype.nexus.security.UserPrincipalsHelper;
import org.sonatype.nexus.security.authc.apikey.ApiKeyFactory;
import org.sonatype.nexus.security.authc.apikey.ApiKeyStore;
import org.sonatype.nexus.security.user.UserNotFoundException;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SCHEMAS)
@Singleton
public class ApiKeyStoreImpl
extends StateGuardLifecycleSupport
implements ApiKeyStore,
EventAware {
    private final Provider<DatabaseInstance> databaseInstance;
    private final ApiKeyEntityAdapter entityAdapter;
    private final UserPrincipalsHelper principalsHelper;
    private final Map<String, ApiKeyFactory> apiKeyFactories;
    private final DefaultApiKeyFactory defaultApiKeyFactory;

    @Inject
    public ApiKeyStoreImpl(@Named(value="security") Provider<DatabaseInstance> databaseInstance, ApiKeyEntityAdapter entityAdapter, UserPrincipalsHelper principalsHelper, Map<String, ApiKeyFactory> apiKeyFactories, DefaultApiKeyFactory defaultApiKeyFactory) {
        this.databaseInstance = (Provider)Preconditions.checkNotNull(databaseInstance);
        this.entityAdapter = (ApiKeyEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)entityAdapter)));
        this.principalsHelper = (UserPrincipalsHelper)Preconditions.checkNotNull((Object)principalsHelper);
        this.apiKeyFactories = (Map)Preconditions.checkNotNull(apiKeyFactories);
        this.defaultApiKeyFactory = (DefaultApiKeyFactory)((Object)Preconditions.checkNotNull((Object)((Object)defaultApiKeyFactory)));
    }

    protected void doStart() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.databaseInstance.get()).connect();){
            this.entityAdapter.register(db);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Guarded(by={"STARTED"})
    public char[] createApiKey(String domain, PrincipalCollection principals) {
        Preconditions.checkNotNull((Object)domain);
        Preconditions.checkNotNull((Object)principals);
        try {
            char[] apiKeyCharArray = this.makeApiKey(domain, principals);
            this.persistApiKey(domain, principals, apiKeyCharArray);
            return apiKeyCharArray;
        }
        catch (ORecordDuplicatedException oRecordDuplicatedException) {
            return this.getApiKey(domain, principals);
        }
    }

    @Guarded(by={"STARTED"})
    public void persistApiKey(String domain, PrincipalCollection principals, char[] apiKey) {
        Preconditions.checkNotNull((Object)domain);
        Preconditions.checkNotNull((Object)principals);
        Preconditions.checkNotNull((Object)apiKey);
        ApiKey entity = new ApiKey();
        entity.setDomain(domain);
        entity.setApiKey(apiKey);
        entity.setPrincipals(principals);
        OrientTransactional.inTxRetry(this.databaseInstance).run(db -> {
            ODocument oDocument = this.entityAdapter.addEntity(db, (Entity)entity);
        });
    }

    @Nullable
    @Guarded(by={"STARTED"})
    public char[] getApiKey(String domain, PrincipalCollection principals) {
        return (char[])OrientTransactional.inTx(this.databaseInstance).call(db -> {
            for (ApiKey entity : this.findByPrimaryPrincipal(db, principals)) {
                if (!entity.getDomain().equals(domain)) continue;
                return entity.getApiKey();
            }
            return null;
        });
    }

    @Nullable
    @Guarded(by={"STARTED"})
    public PrincipalCollection getPrincipals(String domain, char[] apiKey) {
        return (PrincipalCollection)OrientTransactional.inTx(this.databaseInstance).call(db -> {
            ApiKey entity = this.entityAdapter.findByApiKey(db, domain, (char[])Preconditions.checkNotNull((Object)apiKey));
            return entity == null ? null : entity.getPrincipals();
        });
    }

    @Guarded(by={"STARTED"})
    public void deleteApiKey(String domain, PrincipalCollection principals) {
        OrientTransactional.inTxRetry(this.databaseInstance).run(db -> {
            for (ApiKey entity : this.findByPrimaryPrincipal(db, principals)) {
                if (!entity.getDomain().equals(domain)) continue;
                this.entityAdapter.deleteEntity(db, (Entity)entity);
            }
        });
    }

    @Guarded(by={"STARTED"})
    public void deleteApiKeys(PrincipalCollection principals) {
        OrientTransactional.inTxRetry(this.databaseInstance).run(db -> {
            for (ApiKey entity : this.findByPrimaryPrincipal(db, principals)) {
                this.entityAdapter.deleteEntity(db, (Entity)entity);
            }
        });
    }

    @Guarded(by={"STARTED"})
    public void deleteApiKeys() {
        OrientTransactional.inTxRetry(this.databaseInstance).run(this.entityAdapter::deleteAll);
    }

    @Guarded(by={"STARTED"})
    public void purgeApiKeys() {
        CancelableHelper.checkCancellation();
        OrientTransactional.inTxRetry(this.databaseInstance).run(db -> {
            ArrayList<ApiKey> delete = new ArrayList<ApiKey>();
            for (ApiKey entity : this.entityAdapter.browse(db)) {
                CancelableHelper.checkCancellation();
                UnitOfWork work = UnitOfWork.pause();
                try {
                    try {
                        this.principalsHelper.getUserStatus(entity.getPrincipals());
                    }
                    catch (UserNotFoundException e) {
                        this.log.debug("Stale user found", (Throwable)e);
                        delete.add(entity);
                        UnitOfWork.resume((UnitOfWork)work);
                        db.activateOnCurrentThread();
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    UnitOfWork.resume((UnitOfWork)work);
                    db.activateOnCurrentThread();
                    throw throwable;
                }
                UnitOfWork.resume((UnitOfWork)work);
                db.activateOnCurrentThread();
            }
            for (ApiKey entity : delete) {
                CancelableHelper.checkCancellation();
                this.entityAdapter.deleteEntity(db, (Entity)entity);
            }
        });
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(UserPrincipalsExpired event) {
        String userId = event.getUserId();
        if (userId != null) {
            this.deleteApiKeys((PrincipalCollection)new SimplePrincipalCollection((Object)userId, event.getSource()));
        } else {
            this.purgeApiKeys();
        }
    }

    private Iterable<ApiKey> findByPrimaryPrincipal(ODatabaseDocumentTx db, PrincipalCollection principals) {
        String primaryPrincipal = ((PrincipalCollection)Preconditions.checkNotNull((Object)principals)).getPrimaryPrincipal().toString();
        return this.entityAdapter.browseByPrimaryPrincipal(db, primaryPrincipal);
    }

    private char[] makeApiKey(String domain, PrincipalCollection principals) {
        ApiKeyFactory factory = this.apiKeyFactories.get(domain);
        if (factory != null) {
            return (char[])Preconditions.checkNotNull((Object)factory.makeApiKey(principals));
        }
        return this.defaultApiKeyFactory.makeApiKey(principals);
    }
}

