/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.security.apikey;

import com.google.common.base.Preconditions;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.shiro.subject.PrincipalCollection;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.crypto.RandomBytesGenerator;
import org.sonatype.nexus.security.authc.apikey.ApiKeyFactory;

@Named(value="default")
@Singleton
public class DefaultApiKeyFactory
extends ComponentSupport
implements ApiKeyFactory {
    private final RandomBytesGenerator randomBytesGenerator;

    @Inject
    public DefaultApiKeyFactory(RandomBytesGenerator randomBytesGenerator) {
        this.randomBytesGenerator = (RandomBytesGenerator)Preconditions.checkNotNull((Object)randomBytesGenerator);
    }

    public char[] makeApiKey(PrincipalCollection principals) {
        String salt = new BigInteger(this.randomBytesGenerator.generate(4)).toString(32);
        byte[] code = ("~nexus~default~" + principals + salt).getBytes(StandardCharsets.UTF_8);
        String apiKey = UUID.nameUUIDFromBytes(code).toString();
        return apiKey.toCharArray();
    }
}

