/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.selector;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.internal.selector.SelectorConfigurationEntityAdapter;
import org.sonatype.nexus.internal.selector.SelectorConfigurationStore;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.transaction.OrientTransactional;
import org.sonatype.nexus.selector.SelectorConfiguration;

@Named
@Singleton
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SCHEMAS)
public class SelectorConfigurationStoreImpl
extends StateGuardLifecycleSupport
implements SelectorConfigurationStore {
    private final Provider<DatabaseInstance> databaseInstance;
    private final SelectorConfigurationEntityAdapter entityAdapter;

    @Inject
    public SelectorConfigurationStoreImpl(@Named(value="config") Provider<DatabaseInstance> databaseInstance, SelectorConfigurationEntityAdapter entityAdapter) {
        this.databaseInstance = databaseInstance;
        this.entityAdapter = entityAdapter;
    }

    protected void doStart() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.databaseInstance.get()).connect();){
            this.entityAdapter.register(db);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @Guarded(by={"STARTED"})
    public List<SelectorConfiguration> browse() {
        return (List)OrientTransactional.inTx(this.databaseInstance).call(db -> ImmutableList.copyOf((Iterable)this.entityAdapter.browse(db)));
    }

    @Override
    @Guarded(by={"STARTED"})
    public SelectorConfiguration read(EntityId entityId) {
        Preconditions.checkNotNull((Object)entityId);
        return (SelectorConfiguration)OrientTransactional.inTx(this.databaseInstance).call(db -> (SelectorConfiguration)this.entityAdapter.read(db, entityId));
    }

    @Override
    @Guarded(by={"STARTED"})
    public SelectorConfiguration getByName(String name) {
        Preconditions.checkNotNull((Object)name);
        return (SelectorConfiguration)OrientTransactional.inTx(this.databaseInstance).call(db -> this.entityAdapter.getByName(db, name));
    }

    @Override
    @Guarded(by={"STARTED"})
    public void create(SelectorConfiguration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        OrientTransactional.inTxRetry(this.databaseInstance).run(db -> {
            ODocument oDocument = this.entityAdapter.addEntity(db, (Entity)configuration);
        });
    }

    @Override
    @Guarded(by={"STARTED"})
    public void update(SelectorConfiguration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        OrientTransactional.inTxRetry(this.databaseInstance).run(db -> {
            ODocument oDocument = this.entityAdapter.editEntity(db, (Entity)configuration);
        });
    }

    @Override
    @Guarded(by={"STARTED"})
    public void delete(SelectorConfiguration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        OrientTransactional.inTxRetry(this.databaseInstance).run(db -> this.entityAdapter.deleteEntity(db, (Entity)configuration));
    }
}

