/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.selector;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.internal.selector.SelectorConfigurationEvent;
import org.sonatype.nexus.internal.selector.SelectorConfigurationStore;
import org.sonatype.nexus.repository.security.RepositorySelector;
import org.sonatype.nexus.security.SecuritySystem;
import org.sonatype.nexus.security.authz.AuthorizationManager;
import org.sonatype.nexus.security.authz.NoSuchAuthorizationManagerException;
import org.sonatype.nexus.security.privilege.NoSuchPrivilegeException;
import org.sonatype.nexus.security.privilege.Privilege;
import org.sonatype.nexus.security.role.NoSuchRoleException;
import org.sonatype.nexus.security.role.Role;
import org.sonatype.nexus.security.role.RoleIdentifier;
import org.sonatype.nexus.security.user.User;
import org.sonatype.nexus.security.user.UserNotFoundException;
import org.sonatype.nexus.selector.CselSelector;
import org.sonatype.nexus.selector.JexlSelector;
import org.sonatype.nexus.selector.Selector;
import org.sonatype.nexus.selector.SelectorConfiguration;
import org.sonatype.nexus.selector.SelectorEvaluationException;
import org.sonatype.nexus.selector.SelectorManager;
import org.sonatype.nexus.selector.VariableSource;

@Named
@Singleton
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SERVICES)
public class SelectorManagerImpl
extends StateGuardLifecycleSupport
implements SelectorManager,
EventAware {
    private static final SoftReference<List<SelectorConfiguration>> EMPTY_CACHE = new SoftReference<Object>(null);
    private final SelectorConfigurationStore store;
    private final SecuritySystem securitySystem;
    private volatile SoftReference<List<SelectorConfiguration>> cachedBrowseResult = EMPTY_CACHE;
    private LoadingCache<SelectorConfiguration, Selector> selectorCache;

    @Inject
    public SelectorManagerImpl(SelectorConfigurationStore store, SecuritySystem securitySystem) {
        this.store = (SelectorConfigurationStore)Preconditions.checkNotNull((Object)store);
        this.securitySystem = (SecuritySystem)Preconditions.checkNotNull((Object)securitySystem);
        this.selectorCache = CacheBuilder.newBuilder().softValues().build((CacheLoader)new SelectorCacheLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Guarded(by={"STARTED"})
    public List<SelectorConfiguration> browse() {
        ImmutableList result = this.cachedBrowseResult.get();
        if (result == null) {
            SelectorManagerImpl selectorManagerImpl = this;
            synchronized (selectorManagerImpl) {
                result = this.cachedBrowseResult.get();
                if (result == null) {
                    result = ImmutableList.copyOf(this.store.browse());
                    this.cachedBrowseResult = new SoftReference<ImmutableList>(result);
                }
            }
        }
        return result;
    }

    @Guarded(by={"STARTED"})
    public List<SelectorConfiguration> browseJexl() {
        return this.browse().stream().filter(config -> Objects.equals("jexl", config.getType())).collect(Collectors.toList());
    }

    @Guarded(by={"STARTED"})
    public SelectorConfiguration read(EntityId entityId) {
        return this.store.read(entityId);
    }

    @Guarded(by={"STARTED"})
    public void create(SelectorConfiguration configuration) {
        this.store.create(configuration);
    }

    @Guarded(by={"STARTED"})
    public void update(SelectorConfiguration configuration) {
        this.store.update(configuration);
    }

    @Guarded(by={"STARTED"})
    public void delete(SelectorConfiguration configuration) {
        this.store.delete(configuration);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(SelectorConfigurationEvent event) {
        this.cachedBrowseResult = EMPTY_CACHE;
        this.selectorCache.invalidateAll();
    }

    @Guarded(by={"STARTED"})
    public boolean evaluate(SelectorConfiguration selectorConfiguration, VariableSource variableSource) throws SelectorEvaluationException {
        Selector selector = this.createSelector(selectorConfiguration);
        try {
            return selector.evaluate(variableSource);
        }
        catch (Exception e) {
            throw new SelectorEvaluationException("Selector '" + selectorConfiguration.getName() + "' evaluation in error", e);
        }
    }

    @Guarded(by={"STARTED"})
    public List<SelectorConfiguration> browseActive(List<String> repositoryNames, List<String> formats) {
        User currentUser;
        AuthorizationManager authorizationManager;
        try {
            authorizationManager = this.securitySystem.getAuthorizationManager("default");
            currentUser = this.securitySystem.currentUser();
        }
        catch (NoSuchAuthorizationManagerException | UserNotFoundException e) {
            this.log.warn("Unable to load active content selectors", e);
            return Collections.emptyList();
        }
        if (currentUser == null) {
            return Collections.emptyList();
        }
        List<String> roleIds = currentUser.getRoles().stream().map(RoleIdentifier::getRoleId).collect(Collectors.toList());
        List<Role> roles = this.getRoles(roleIds, authorizationManager, new ArrayList<Role>());
        List contentSelectorNames = roles.stream().map(Role::getPrivileges).flatMap(Collection::stream).map(id -> {
            try {
                return authorizationManager.getPrivilege(id);
            }
            catch (NoSuchPrivilegeException e) {
                this.log.warn("Unable to find privilege for id={}, continuing to check privileges", id, (Object)e);
                return null;
            }
        }).filter(Objects::nonNull).filter(this.repositoryFormatOrNameMatcher(repositoryNames, formats)).map(this::getContentSelector).collect(Collectors.toList());
        return this.browse().stream().filter(selector -> contentSelectorNames.contains(selector.getName())).collect(Collectors.toList());
    }

    private boolean matchesFormatOrRepository(List<String> repositoryNames, List<String> formats, Privilege privilege) {
        boolean isMatchingRepository;
        String type = privilege.getType();
        String selector = (String)privilege.getProperties().get("repository");
        if (selector == null) {
            return false;
        }
        RepositorySelector repositorySelector = RepositorySelector.fromSelector((String)selector);
        boolean isRepositoryContentSelector = "repository-content-selector".equals(type);
        boolean matchesFormat = formats.contains(repositorySelector.getFormat()) || repositorySelector.isAllFormats();
        boolean matchesRepositoryName = repositoryNames.contains(repositorySelector.getName());
        boolean isMatchingFormat = isRepositoryContentSelector && matchesFormat && repositorySelector.isAllRepositories();
        boolean bl = isMatchingRepository = isRepositoryContentSelector && matchesRepositoryName;
        return isMatchingFormat || isMatchingRepository;
    }

    private List<Role> getRoles(List<String> roleIds, AuthorizationManager authorizationManager, List<Role> roles) {
        roleIds.forEach(roleId -> this.getRoles((String)roleId, authorizationManager, roles));
        return roles;
    }

    private void getRoles(String roleId, AuthorizationManager authorizationManager, List<Role> roles) {
        try {
            Role role = authorizationManager.getRole(roleId);
            roles.add(role);
            role.getRoles().forEach(nestedRoleId -> this.getRoles((String)nestedRoleId, authorizationManager, roles));
        }
        catch (NoSuchRoleException e) {
            this.log.warn("Unable to find role for roleId={}, continue searching for roles", (Object)roleId, (Object)e);
        }
    }

    private Selector createSelector(SelectorConfiguration config) throws SelectorEvaluationException {
        try {
            return (Selector)this.selectorCache.get((Object)config);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof SelectorEvaluationException) {
                throw (SelectorEvaluationException)e.getCause();
            }
            throw new SelectorEvaluationException("An unknown error occurred creating the selector", (Exception)e);
        }
    }

    private Predicate<Privilege> repositoryFormatOrNameMatcher(List<String> repositoryNames, List<String> formats) {
        return p -> this.matchesFormatOrRepository(repositoryNames, formats, (Privilege)p);
    }

    private String getContentSelector(Privilege privilege) {
        return privilege.getPrivilegeProperty("contentSelector");
    }

    private static class SelectorCacheLoader
    extends CacheLoader<SelectorConfiguration, Selector> {
        private SelectorCacheLoader() {
        }

        public Selector load(SelectorConfiguration config) throws Exception {
            switch (config.getType()) {
                case "jexl": {
                    return new JexlSelector((String)config.getAttributes().get("expression"));
                }
                case "csel": {
                    return new CselSelector((String)config.getAttributes().get("expression"));
                }
            }
            throw new SelectorEvaluationException("Invalid selector type encountered: " + config.getType());
        }
    }
}

