/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.status;

import com.orientechnologies.orient.core.collate.OCaseInsensitiveCollate;
import com.orientechnologies.orient.core.collate.OCollate;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.Date;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.entity.AbstractEntity;
import org.sonatype.nexus.orient.OClassNameBuilder;
import org.sonatype.nexus.orient.OIndexNameBuilder;
import org.sonatype.nexus.orient.entity.EntityAdapter;
import org.sonatype.nexus.orient.entity.IterableEntityAdapter;
import org.sonatype.nexus.orient.entity.action.ReadEntityByPropertyAction;

@Named
@Singleton
public class StatusHealthCheckEntityAdapter
extends IterableEntityAdapter<NodeHealthCheck> {
    private static final String P_NODE_ID = "node_id";
    private static final String P_LAST_HEALTHCHECK = "last_health_check";
    private static final String DB_CLASS = new OClassNameBuilder().type("statushealthcheck").build();
    private static final String I_NODE_ID = new OIndexNameBuilder().type(DB_CLASS).property("node_id").build();
    private final ReadEntityByPropertyAction<NodeHealthCheck> readByNodeId = new ReadEntityByPropertyAction((EntityAdapter)this, new String[]{"node_id"});

    StatusHealthCheckEntityAdapter() {
        super(DB_CLASS);
    }

    protected void defineType(OClass type) {
        type.createProperty(P_NODE_ID, OType.STRING).setCollate((OCollate)new OCaseInsensitiveCollate()).setMandatory(true).setNotNull(true);
        type.createProperty(P_LAST_HEALTHCHECK, OType.DATETIME).setMandatory(true).setNotNull(true);
        type.createIndex(I_NODE_ID, OClass.INDEX_TYPE.UNIQUE, new String[]{P_NODE_ID});
    }

    protected NodeHealthCheck newEntity() {
        return new NodeHealthCheck();
    }

    protected void readFields(ODocument document, NodeHealthCheck entity) {
        entity.nodeId = (String)document.field(P_NODE_ID, OType.STRING);
        entity.lastHealthCheck = (Date)document.field(P_LAST_HEALTHCHECK, OType.DATETIME);
    }

    protected void writeFields(ODocument document, NodeHealthCheck entity) {
        document.field(P_NODE_ID, (Object)entity.nodeId, new OType[]{OType.STRING});
        document.field(P_LAST_HEALTHCHECK, (Object)entity.lastHealthCheck, new OType[]{OType.DATETIME});
    }

    @Nullable
    public NodeHealthCheck read(ODatabaseDocumentTx db, String nodeId) {
        return (NodeHealthCheck)this.readByNodeId.execute(db, new Object[]{nodeId});
    }

    static class NodeHealthCheck
    extends AbstractEntity {
        String nodeId;
        Date lastHealthCheck;

        NodeHealthCheck() {
        }
    }
}

