/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.status;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import java.util.Date;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.common.status.StatusHealthCheckException;
import org.sonatype.nexus.common.status.StatusHealthCheckStore;
import org.sonatype.nexus.internal.status.StatusHealthCheckEntityAdapter;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.freeze.DatabaseFreezeService;
import org.sonatype.nexus.orient.transaction.OrientTransactional;

@Named
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SCHEMAS)
@Singleton
public class StatusHealthCheckStoreImpl
extends StateGuardLifecycleSupport
implements StatusHealthCheckStore {
    private final Provider<DatabaseInstance> databaseInstance;
    private final StatusHealthCheckEntityAdapter entityAdapter;
    private final DatabaseFreezeService databaseFreezeService;
    private final NodeAccess nodeAccess;

    @Inject
    public StatusHealthCheckStoreImpl(@Named(value="component") Provider<DatabaseInstance> databaseInstance, StatusHealthCheckEntityAdapter entityAdapter, DatabaseFreezeService databaseFreezeService, NodeAccess nodeAccess) {
        this.databaseInstance = (Provider)Preconditions.checkNotNull(databaseInstance);
        this.entityAdapter = (StatusHealthCheckEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)entityAdapter)));
        this.databaseFreezeService = (DatabaseFreezeService)Preconditions.checkNotNull((Object)databaseFreezeService);
        this.nodeAccess = (NodeAccess)Preconditions.checkNotNull((Object)nodeAccess);
    }

    protected void doStart() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.databaseInstance.get()).connect();){
            this.entityAdapter.register(db);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Guarded(by={"STARTED"})
    public void markHealthCheckTime() throws StatusHealthCheckException {
        if (!this.databaseFreezeService.isFrozen()) {
            String nodeId = this.nodeAccess.getId();
            try {
                OrientTransactional.inTxRetry(this.databaseInstance).run(db -> {
                    StatusHealthCheckEntityAdapter.NodeHealthCheck nhc = this.entityAdapter.read(db, nodeId);
                    if (nhc == null) {
                        nhc = this.entityAdapter.newEntity();
                        nhc.nodeId = nodeId;
                        nhc.lastHealthCheck = new Date();
                        this.entityAdapter.addEntity(db, (Entity)nhc);
                    } else {
                        nhc.lastHealthCheck = new Date();
                        this.entityAdapter.editEntity(db, (Entity)nhc);
                    }
                });
            }
            catch (Exception e) {
                throw new StatusHealthCheckException("Unable to update health check time for node: " + nodeId, (Throwable)e);
            }
        }
    }
}

