/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.status;

import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.status.StatusHealthCheckStore;
import org.sonatype.nexus.internal.status.StatusResourceDoc;
import org.sonatype.nexus.rest.Resource;

@Named
@Singleton
@Path(value="/v1/status")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class StatusResource
extends ComponentSupport
implements Resource,
StatusResourceDoc {
    public static final String RESOURCE_URI = "/v1/status";
    private final StatusHealthCheckStore statusHealthCheckStore;

    @Inject
    public StatusResource(StatusHealthCheckStore statusHealthCheckStore) {
        this.statusHealthCheckStore = (StatusHealthCheckStore)Preconditions.checkNotNull((Object)statusHealthCheckStore);
    }

    @Override
    @GET
    @Timed
    public Response isAvailable() {
        try {
            this.statusHealthCheckStore.markHealthCheckTime();
            return Response.ok().build();
        }
        catch (Exception e) {
            this.log.error("Status health check failed, responding server is unavailable", (Throwable)e);
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
        }
    }
}

