/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.system;

import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.common.system.FileDescriptorProvider;
import org.sonatype.nexus.common.system.FileDescriptorService;
import org.sonatype.nexus.internal.system.ProcessProbeFileDescriptorProvider;

@Named
@ManagedLifecycle(phase=ManagedLifecycle.Phase.KERNEL)
public class FileDescriptorServiceImpl
extends StateGuardLifecycleSupport
implements FileDescriptorService {
    static final long MINIMUM_FILE_DESCRIPTOR_COUNT = 65536L;
    static final String WARNING_HEADER = "WARNING: ****************************************************************************";
    static final String WARNING_VIOLATION = "WARNING: The open file descriptor limit is {} which is below the minimum recommended value of {}.";
    static final String WARNING_URL = "WARNING: Please see: http://links.sonatype.com/products/nexus/system-reqs#filehandles";
    static final long NOT_SUPPORTED = -1L;
    private final long fileDescriptorCount;

    @Inject
    public FileDescriptorServiceImpl(@Nullable FileDescriptorProvider fileDescriptorProvider) {
        this.fileDescriptorCount = Optional.ofNullable(fileDescriptorProvider).orElse(new ProcessProbeFileDescriptorProvider()).getFileDescriptorCount();
    }

    public void doStart() {
        if (!this.isFileDescriptorLimitOk()) {
            this.log.warn(WARNING_HEADER);
            this.log.warn(WARNING_VIOLATION, (Object)this.fileDescriptorCount, (Object)65536L);
            this.log.warn(WARNING_URL);
            this.log.warn(WARNING_HEADER);
        }
    }

    public boolean isFileDescriptorLimitOk() {
        return this.fileDescriptorCount >= 65536L || this.fileDescriptorCount == -1L;
    }

    public long getFileDescriptorCount() {
        return this.fileDescriptorCount;
    }

    public long getFileDescriptorRecommended() {
        return 65536L;
    }
}

