/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.webhooks;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.google.common.io.BaseEncoding;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import java.lang.ref.SoftReference;
import java.util.List;
import javax.annotation.Nullable;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.goodies.common.InternalAccessible;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.webhooks.Webhook;
import org.sonatype.nexus.webhooks.WebhookRequest;
import org.sonatype.nexus.webhooks.WebhookRequestSendEvent;
import org.sonatype.nexus.webhooks.WebhookService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Named
@Singleton
public class WebhookServiceImpl
extends ComponentSupport
implements WebhookService,
EventAware,
EventAware.Asynchronous,
GroovyObject {
    private static final String WEBHOOK_ID_HEADER = "X-Nexus-Webhook-ID";
    private static final String WEBHOOK_DELIVERY_HEADER = "X-Nexus-Webhook-Delivery";
    private static final String WEBHOOK_SIGNATURE_HEADER = "X-Nexus-Webhook-Signature";
    @Inject
    private EventManager eventManager;
    @Inject
    private Provider<CloseableHttpClient> httpClientProvider;
    @Inject
    private List<Webhook> webhooks;
    private final ObjectMapper objectMapper;
    private static final String HMAC_SHA1 = "HmacSHA1";
    private static final BaseEncoding HEX;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    public WebhookServiceImpl() {
        MetaClass metaClass;
        CallSite[] callSiteArray = WebhookServiceImpl.$getCallSiteArray();
        Object object = callSiteArray[0].call(callSiteArray[1].call(callSiteArray[2].callConstructor(ObjectMapper.class), callSiteArray[3].callGetProperty(SerializationFeature.class)), callSiteArray[4].callGetProperty(JsonInclude.Include.class));
        this.objectMapper = (ObjectMapper)ScriptBytecodeAdapter.castToType((Object)object, ObjectMapper.class);
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public List<Webhook> getWebhooks() {
        CallSite[] callSiteArray = WebhookServiceImpl.$getCallSiteArray();
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[5].call(ImmutableList.class, this.webhooks), List.class);
    }

    public void queue(WebhookRequest request) {
        CallSite[] callSiteArray = WebhookServiceImpl.$getCallSiteArray();
        callSiteArray[6].callStatic(Preconditions.class, (Object)request);
        callSiteArray[7].call((Object)this.eventManager, callSiteArray[8].callConstructor(WebhookRequestSendEvent.class, (Object)request));
    }

    @Subscribe
    @AllowConcurrentEvents
    @InternalAccessible
    public void on(WebhookRequestSendEvent event) {
        CallSite[] callSiteArray = WebhookServiceImpl.$getCallSiteArray();
        try {
            callSiteArray[9].callCurrent((GroovyObject)this, callSiteArray[10].callGetProperty((Object)event));
        }
        catch (Exception e) {
            callSiteArray[11].call(callSiteArray[12].callGroovyObjectGetProperty((Object)this), (Object)new GStringImpl(new Object[]{callSiteArray[13].callGetProperty((Object)event)}, new String[]{"Failed to send webhook request: ", ""}), (Object)e);
        }
    }

    public void send(WebhookRequest request) {
        Reference request2 = new Reference((Object)request);
        CallSite[] callSiteArray = WebhookServiceImpl.$getCallSiteArray();
        callSiteArray[14].callStatic(Preconditions.class, (Object)((WebhookRequest)request2.get()));
        callSiteArray[15].call(callSiteArray[16].callGroovyObjectGetProperty((Object)this), (Object)"Sending webhook request: {}", (Object)((WebhookRequest)request2.get()));
        Reference webhook = new Reference(callSiteArray[17].callGetProperty((Object)((WebhookRequest)request2.get())));
        Reference json = new Reference(callSiteArray[18].call((Object)this.objectMapper, callSiteArray[19].callGetProperty((Object)((WebhookRequest)request2.get()))));
        callSiteArray[20].call(callSiteArray[21].call(this.httpClientProvider), (Object)new GeneratedClosure((Object)this, (Object)this, request2, webhook, json){
            private /* synthetic */ Reference request;
            private /* synthetic */ Reference webhook;
            private /* synthetic */ Reference json;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                Reference reference2;
                Reference reference3;
                CallSite[] callSiteArray = _send_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.request = reference3 = request;
                this.webhook = reference2 = webhook;
                this.json = reference = json;
            }

            public Object doCall(CloseableHttpClient client) {
                CallSite[] callSiteArray = _send_closure1.$getCallSiteArray();
                HttpPost httpPost = (HttpPost)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].callConstructor(HttpPost.class, callSiteArray[1].callGetProperty(this.request.get())), HttpPost.class);
                callSiteArray[2].call((Object)httpPost, callSiteArray[3].callGetProperty(WebhookServiceImpl.class), callSiteArray[4].callGetProperty(this.webhook.get()));
                callSiteArray[5].call((Object)httpPost, callSiteArray[6].callGetProperty(WebhookServiceImpl.class), callSiteArray[7].callGetProperty(this.request.get()));
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[8].callGetProperty(this.request.get()))) {
                    callSiteArray[9].call((Object)httpPost, callSiteArray[10].callGetProperty(WebhookServiceImpl.class), callSiteArray[11].callCurrent((GroovyObject)this, this.json.get(), callSiteArray[12].callGetProperty(this.request.get())));
                }
                Object object = callSiteArray[13].callConstructor(StringEntity.class, this.json.get(), callSiteArray[14].callGetProperty(ContentType.class));
                ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)httpPost, (String)"entity");
                callSiteArray[15].call(callSiteArray[16].callGroovyObjectGetProperty((Object)this), (Object)"Sending POST request: {}", (Object)httpPost);
                return callSiteArray[17].call(callSiteArray[18].call((Object)client, (Object)httpPost), (Object)new GeneratedClosure((Object)this, this.getThisObject()){
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;
                    {
                        CallSite[] callSiteArray = _closure2.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(CloseableHttpResponse response) {
                        CallSite[] callSiteArray = _closure2.$getCallSiteArray();
                        Object status = callSiteArray[0].callGetProperty((Object)response);
                        callSiteArray[1].call(callSiteArray[2].callGroovyObjectGetProperty((Object)this), (Object)"Response status: {}", status);
                        int code = DefaultTypeTransformation.intUnbox((Object)callSiteArray[3].callGetProperty(status));
                        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                            if (code >= 300) {
                                String message = ShortTypeHandling.castToString((Object)callSiteArray[4].callCurrent((GroovyObject)this, (Object)response));
                                if (ScriptBytecodeAdapter.compareEqual((Object)message, null)) {
                                    Object object = callSiteArray[5].callGetProperty(status);
                                    message = ShortTypeHandling.castToString((Object)object);
                                }
                                throw (Throwable)callSiteArray[6].callConstructor(HttpResponseException.class, (Object)code, (Object)message);
                            }
                            return null;
                        }
                        if (code >= 300) {
                            String message = ShortTypeHandling.castToString((Object)callSiteArray[7].callCurrent((GroovyObject)this, (Object)response));
                            if (ScriptBytecodeAdapter.compareEqual((Object)message, null)) {
                                Object object = callSiteArray[8].callGetProperty(status);
                                message = ShortTypeHandling.castToString((Object)object);
                            }
                            throw (Throwable)callSiteArray[9].callConstructor(HttpResponseException.class, (Object)code, (Object)message);
                        }
                        return null;
                    }

                    public Object call(CloseableHttpResponse response) {
                        CallSite[] callSiteArray = _closure2.$getCallSiteArray();
                        return callSiteArray[10].callCurrent((GroovyObject)this, (Object)response);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure2.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "statusLine";
                        stringArray[1] = "debug";
                        stringArray[2] = "log";
                        stringArray[3] = "statusCode";
                        stringArray[4] = "extractResponseBody";
                        stringArray[5] = "reasonPhrase";
                        stringArray[6] = "<$constructor$>";
                        stringArray[7] = "extractResponseBody";
                        stringArray[8] = "reasonPhrase";
                        stringArray[9] = "<$constructor$>";
                        stringArray[10] = "doCall";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[11];
                        _closure2.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_closure2.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure2.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                });
            }

            public Object call(CloseableHttpClient client) {
                CallSite[] callSiteArray = _send_closure1.$getCallSiteArray();
                return callSiteArray[19].callCurrent((GroovyObject)this, (Object)client);
            }

            public WebhookRequest getRequest() {
                CallSite[] callSiteArray = _send_closure1.$getCallSiteArray();
                return (WebhookRequest)ScriptBytecodeAdapter.castToType((Object)this.request.get(), WebhookRequest.class);
            }

            public Object getWebhook() {
                CallSite[] callSiteArray = _send_closure1.$getCallSiteArray();
                return this.webhook.get();
            }

            public Object getJson() {
                CallSite[] callSiteArray = _send_closure1.$getCallSiteArray();
                return this.json.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _send_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "<$constructor$>";
                stringArray[1] = "url";
                stringArray[2] = "setHeader";
                stringArray[3] = "WEBHOOK_ID_HEADER";
                stringArray[4] = "id";
                stringArray[5] = "setHeader";
                stringArray[6] = "WEBHOOK_DELIVERY_HEADER";
                stringArray[7] = "id";
                stringArray[8] = "secret";
                stringArray[9] = "setHeader";
                stringArray[10] = "WEBHOOK_SIGNATURE_HEADER";
                stringArray[11] = "sign";
                stringArray[12] = "secret";
                stringArray[13] = "<$constructor$>";
                stringArray[14] = "APPLICATION_JSON";
                stringArray[15] = "debug";
                stringArray[16] = "log";
                stringArray[17] = "withCloseable";
                stringArray[18] = "execute";
                stringArray[19] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[20];
                _send_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_send_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _send_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        });
    }

    @Nullable
    private static String extractResponseBody(HttpResponse response) {
        CallSite[] callSiteArray = WebhookServiceImpl.$getCallSiteArray();
        HttpEntity entity = (HttpEntity)ScriptBytecodeAdapter.castToType((Object)callSiteArray[22].callGetProperty((Object)response), HttpEntity.class);
        if (ScriptBytecodeAdapter.compareNotEqual((Object)entity, null)) {
            block4: {
                String string;
                try {
                    String body = ShortTypeHandling.castToString((Object)callSiteArray[23].call(EntityUtils.class, (Object)entity));
                    if (!(ScriptBytecodeAdapter.compareNotEqual((Object)body, null) && ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[24].call((Object)body), (Object)0) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[25].call((Object)body, (Object)"<html")))) break block4;
                    string = body;
                }
                catch (Throwable throwable) {
                    callSiteArray[28].call(EntityUtils.class, (Object)entity);
                    throw throwable;
                }
                callSiteArray[26].call(EntityUtils.class, (Object)entity);
                return string;
            }
            callSiteArray[27].call(EntityUtils.class, (Object)entity);
        }
        return ShortTypeHandling.castToString(null);
    }

    private static String sign(String body, String secret) {
        CallSite[] callSiteArray = WebhookServiceImpl.$getCallSiteArray();
        Object key = callSiteArray[29].callConstructor(SecretKeySpec.class, callSiteArray[30].callGetProperty((Object)secret), (Object)HMAC_SHA1);
        Object mac = callSiteArray[31].call(Mac.class, (Object)HMAC_SHA1);
        callSiteArray[32].call(mac, key);
        Object bytes = callSiteArray[33].call(mac, callSiteArray[34].callGetProperty((Object)body));
        return ShortTypeHandling.castToString((Object)callSiteArray[35].call((Object)HEX, bytes));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != WebhookServiceImpl.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Object object = WebhookServiceImpl.$getCallSiteArray()[36].call(WebhookServiceImpl.$getCallSiteArray()[37].call(BaseEncoding.class));
        HEX = (BaseEncoding)ScriptBytecodeAdapter.castToType((Object)object, BaseEncoding.class);
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    public Provider<CloseableHttpClient> getHttpClientProvider() {
        return this.httpClientProvider;
    }

    public void setHttpClientProvider(Provider<CloseableHttpClient> provider) {
        this.httpClientProvider = provider;
    }

    public void setWebhooks(List<Webhook> list) {
        this.webhooks = list;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "setSerializationInclusion";
        stringArray[1] = "disable";
        stringArray[2] = "<$constructor$>";
        stringArray[3] = "WRITE_DATES_AS_TIMESTAMPS";
        stringArray[4] = "NON_NULL";
        stringArray[5] = "copyOf";
        stringArray[6] = "checkNotNull";
        stringArray[7] = "post";
        stringArray[8] = "<$constructor$>";
        stringArray[9] = "send";
        stringArray[10] = "request";
        stringArray[11] = "error";
        stringArray[12] = "log";
        stringArray[13] = "request";
        stringArray[14] = "checkNotNull";
        stringArray[15] = "debug";
        stringArray[16] = "log";
        stringArray[17] = "webhook";
        stringArray[18] = "writeValueAsString";
        stringArray[19] = "payload";
        stringArray[20] = "withCloseable";
        stringArray[21] = "get";
        stringArray[22] = "entity";
        stringArray[23] = "toString";
        stringArray[24] = "length";
        stringArray[25] = "contains";
        stringArray[26] = "consume";
        stringArray[27] = "consume";
        stringArray[28] = "consume";
        stringArray[29] = "<$constructor$>";
        stringArray[30] = "bytes";
        stringArray[31] = "getInstance";
        stringArray[32] = "init";
        stringArray[33] = "doFinal";
        stringArray[34] = "bytes";
        stringArray[35] = "encode";
        stringArray[36] = "lowerCase";
        stringArray[37] = "base16";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[38];
        WebhookServiceImpl.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(WebhookServiceImpl.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = WebhookServiceImpl.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

