/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.quartz.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.eventbus.Subscribe;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.JobListener;
import org.quartz.JobPersistenceException;
import org.quartz.Matcher;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerMetaData;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.UnableToInterruptJobException;
import org.quartz.core.QuartzScheduler;
import org.quartz.impl.DefaultThreadExecutor;
import org.quartz.impl.DirectSchedulerFactory;
import org.quartz.impl.SchedulerRepository;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.impl.matchers.KeyMatcher;
import org.quartz.spi.JobFactory;
import org.quartz.spi.JobStore;
import org.quartz.spi.ThreadExecutor;
import org.quartz.spi.ThreadPool;
import org.quartz.utils.Key;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.event.EventHelper;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.common.log.LastShutdownTimeService;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.common.thread.TcclBlock;
import org.sonatype.nexus.quartz.internal.QuartzScheduleFactory;
import org.sonatype.nexus.quartz.internal.QuartzThreadPool;
import org.sonatype.nexus.quartz.internal.QuartzTriggerConverter;
import org.sonatype.nexus.quartz.internal.orient.JobCreatedEvent;
import org.sonatype.nexus.quartz.internal.orient.JobDeletedEvent;
import org.sonatype.nexus.quartz.internal.orient.JobUpdatedEvent;
import org.sonatype.nexus.quartz.internal.orient.TriggerCreatedEvent;
import org.sonatype.nexus.quartz.internal.orient.TriggerDeletedEvent;
import org.sonatype.nexus.quartz.internal.orient.TriggerUpdatedEvent;
import org.sonatype.nexus.quartz.internal.task.QuartzTaskFuture;
import org.sonatype.nexus.quartz.internal.task.QuartzTaskInfo;
import org.sonatype.nexus.quartz.internal.task.QuartzTaskJob;
import org.sonatype.nexus.quartz.internal.task.QuartzTaskJobListener;
import org.sonatype.nexus.quartz.internal.task.QuartzTaskState;
import org.sonatype.nexus.scheduling.TaskConfiguration;
import org.sonatype.nexus.scheduling.TaskInfo;
import org.sonatype.nexus.scheduling.TaskRemovedException;
import org.sonatype.nexus.scheduling.schedule.Now;
import org.sonatype.nexus.scheduling.schedule.Schedule;
import org.sonatype.nexus.scheduling.schedule.ScheduleFactory;
import org.sonatype.nexus.scheduling.spi.SchedulerSPI;

@Named
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SERVICES)
@Singleton
public class QuartzSchedulerSPI
extends StateGuardLifecycleSupport
implements SchedulerSPI,
EventAware {
    private static final String SCHEDULER_NAME = "nexus";
    private static final String GROUP_NAME = "nexus";
    private static final Set<String> INHERITED_CONFIG_KEYS = ImmutableSet.of((Object)"limitnode");
    private final EventManager eventManager;
    private final NodeAccess nodeAccess;
    private final Provider<JobStore> jobStoreProvider;
    private final JobFactory jobFactory;
    private final int threadPoolSize;
    private final ScheduleFactory scheduleFactory;
    private final QuartzTriggerConverter triggerConverter;
    private final LastShutdownTimeService lastShutdownTimeService;
    private final boolean recoverInterruptedJobs;
    private Scheduler scheduler;
    private QuartzScheduler quartzScheduler;
    private boolean active;

    @Inject
    public QuartzSchedulerSPI(EventManager eventManager, NodeAccess nodeAccess, Provider<JobStore> jobStoreProvider, JobFactory jobFactory, LastShutdownTimeService lastShutdownTimeService, @Named(value="${nexus.quartz.poolSize:-20}") int threadPoolSize, @Named(value="${nexus.quartz.recoverInterruptedJobs:-true}") boolean recoverInterruptedJobs) throws Exception {
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
        this.nodeAccess = (NodeAccess)Preconditions.checkNotNull((Object)nodeAccess);
        this.jobStoreProvider = (Provider)Preconditions.checkNotNull(jobStoreProvider);
        this.jobFactory = (JobFactory)Preconditions.checkNotNull((Object)jobFactory);
        this.lastShutdownTimeService = (LastShutdownTimeService)Preconditions.checkNotNull((Object)lastShutdownTimeService);
        this.recoverInterruptedJobs = recoverInterruptedJobs;
        Preconditions.checkArgument((threadPoolSize > 0 ? 1 : 0) != 0, (String)"Invalid thread-pool size: %s", (int)threadPoolSize);
        this.threadPoolSize = threadPoolSize;
        this.log.info("Thread-pool size: {}", (Object)threadPoolSize);
        this.scheduleFactory = new QuartzScheduleFactory();
        this.triggerConverter = new QuartzTriggerConverter(this.scheduleFactory);
        this.active = true;
    }

    public QuartzTriggerConverter triggerConverter() {
        return this.triggerConverter;
    }

    @VisibleForTesting
    Scheduler getScheduler() {
        return this.scheduler;
    }

    protected void doStart() throws Exception {
        this.scheduler = this.createScheduler();
        try {
            Field schedField = this.scheduler.getClass().getDeclaredField("sched");
            schedField.setAccessible(true);
            this.quartzScheduler = (QuartzScheduler)schedField.get(this.scheduler);
        }
        catch (Exception | LinkageError e) {
            this.log.error("Cannot find QuartzScheduler", e);
            throw e;
        }
        this.reattachJobListeners();
        this.updateLastRunStateInfo(this.lastShutdownTimeService.estimateLastShutdownTime());
        this.recoverInterruptedJobs();
    }

    private void recoverInterruptedJobs() throws SchedulerException {
        if (!this.recoverInterruptedJobs) {
            return;
        }
        Set jobKeys = this.scheduler.getJobKeys(GroupMatcher.jobGroupEquals((String)"nexus"));
        for (JobKey jobKey : jobKeys) {
            JobDetail jobDetail = this.scheduler.getJobDetail(jobKey);
            if (!jobDetail.requestsRecovery() || !"INTERRUPTED".equals(jobDetail.getJobDataMap().getString("lastRunState.endState"))) continue;
            TriggerKey triggerKey = TriggerKey.triggerKey((String)jobKey.getName(), (String)jobKey.getGroup());
            Trigger oldTrigger = this.scheduler.getTrigger(triggerKey);
            Trigger newTrigger = TriggerBuilder.newTrigger().usingJobData(oldTrigger.getJobDataMap()).withDescription("Retry " + oldTrigger.getDescription()).forJob(jobDetail).startNow().build();
            this.scheduler.scheduleJob(newTrigger);
        }
    }

    private void updateLastRunStateInfo(Optional<Date> nexusLastRunTime) throws SchedulerException {
        for (Map.Entry<JobKey, QuartzTaskInfo> task : this.allTasks().entrySet()) {
            TaskConfiguration taskConfig = task.getValue().getConfiguration();
            JobKey jobKey = task.getKey();
            Optional<Date> latestFireWrapper = this.scheduler.getTriggersOfJob(jobKey).stream().filter(Objects::nonNull).map(Trigger::getPreviousFireTime).filter(Objects::nonNull).max(Date::compareTo);
            if (!latestFireWrapper.isPresent()) continue;
            Date latestFire = latestFireWrapper.get();
            JobDetail jobDetail = this.scheduler.getJobDetail(jobKey);
            if (QuartzTaskState.hasLastRunState(taskConfig) && !QuartzTaskState.getLastRunState(taskConfig).getRunStarted().before(latestFire)) continue;
            long estimatedDuration = Math.max(nexusLastRunTime.orElse(latestFire).getTime() - latestFire.getTime(), 0L);
            QuartzTaskState.setLastRunState(taskConfig, TaskInfo.EndState.INTERRUPTED, latestFire, estimatedDuration);
            this.log.warn("Updating lastRunState to interrupted for {} taskConfig: {}", (Object)jobDetail.getKey(), (Object)taskConfig);
            try {
                QuartzTaskJob.updateJobData(jobDetail, taskConfig);
                this.scheduler.addJob(jobDetail, true, true);
            }
            catch (RuntimeException e) {
                this.log.warn("Problem updating lastRunState to interrupted for {}", (Object)jobDetail.getKey(), (Object)e);
            }
        }
    }

    private Scheduler createScheduler() throws SchedulerException {
        DefaultThreadExecutor threadExecutor = new DefaultThreadExecutor(){

            public void execute(Thread thread) {
                thread.setContextClassLoader(QuartzSchedulerSPI.class.getClassLoader());
                super.execute(thread);
            }
        };
        DirectSchedulerFactory.getInstance().createScheduler("nexus", this.nodeAccess.getId(), (ThreadPool)new QuartzThreadPool(this.threadPoolSize), (ThreadExecutor)threadExecutor, (JobStore)this.jobStoreProvider.get(), null, null, 0, -1L, -1L, true, null, 1, 0L);
        Scheduler scheduler = DirectSchedulerFactory.getInstance().getScheduler("nexus");
        scheduler.setJobFactory(this.jobFactory);
        this.log.info("Quartz Scheduler v{}", (Object)scheduler.getMetaData().getVersion());
        scheduler.standby();
        return scheduler;
    }

    protected void doStop() throws Exception {
        this.scheduler.shutdown();
        SchedulerRepository.getInstance().remove("nexus");
        this.scheduler = null;
    }

    public void pause() {
        try {
            this.setActive(false);
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    public void resume() {
        try {
            this.setActive(true);
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    private void setActive(boolean started) throws SchedulerException {
        this.active = started;
        if (this.isStarted()) {
            this.applyActive();
        }
    }

    private void applyActive() throws SchedulerException {
        if (!this.active && !this.scheduler.isInStandbyMode()) {
            this.scheduler.standby();
            this.log.info("Scheduler put into stand-by mode");
        } else if (this.active && this.scheduler.isInStandbyMode()) {
            this.scheduler.start();
            this.log.info("Scheduler put into ready mode");
        }
    }

    @VisibleForTesting
    void reattachJobListeners() throws SchedulerException {
        this.log.debug("Re-attaching listeners to jobs");
        Set jobKeys = this.scheduler.getJobKeys(GroupMatcher.jobGroupEquals((String)"nexus"));
        for (JobKey jobKey : jobKeys) {
            JobDetail jobDetail = this.scheduler.getJobDetail(jobKey);
            if (jobDetail == null) {
                this.log.error("Missing job-detail for key: {}", (Object)jobKey);
                continue;
            }
            Trigger trigger = this.scheduler.getTrigger(TriggerKey.triggerKey((String)jobKey.getName(), (String)jobKey.getGroup()));
            if (trigger == null) {
                this.log.error("Missing trigger for key: {}", (Object)jobKey);
                continue;
            }
            this.attachJobListener(jobDetail, trigger);
            if (!QuartzSchedulerSPI.isRunNow(trigger)) continue;
            this.scheduler.rescheduleJob(trigger.getKey(), trigger);
            this.scheduler.resumeJob(jobKey);
        }
    }

    private QuartzTaskJobListener attachJobListener(JobDetail jobDetail, Trigger trigger) throws SchedulerException {
        this.log.debug("Initializing task-state: jobDetail={}, trigger={}", (Object)jobDetail, (Object)trigger);
        Date now = new Date();
        TaskConfiguration taskConfiguration = QuartzTaskJob.configurationOf(jobDetail);
        Schedule schedule = this.triggerConverter.convert(trigger);
        QuartzTaskState taskState = new QuartzTaskState(taskConfiguration, schedule, trigger.getFireTimeAfter(now));
        QuartzTaskFuture future = null;
        if (schedule instanceof Now) {
            future = new QuartzTaskFuture(this, jobDetail.getKey(), taskConfiguration.getTaskLogName(), now, schedule, null);
        }
        QuartzTaskJobListener listener = new QuartzTaskJobListener(QuartzTaskJobListener.listenerName(jobDetail.getKey()), this.eventManager, this, new QuartzTaskInfo(this.eventManager, this, jobDetail.getKey(), taskState, future));
        this.scheduler.getListenerManager().addJobListener((JobListener)listener, (Matcher)KeyMatcher.keyEquals((Key)jobDetail.getKey()));
        return listener;
    }

    @Nullable
    private QuartzTaskJobListener findJobListener(JobKey jobKey) throws SchedulerException {
        String name = QuartzTaskJobListener.listenerName(jobKey);
        return (QuartzTaskJobListener)this.scheduler.getListenerManager().getJobListener(name);
    }

    private void updateJobListener(JobDetail jobDetail) throws SchedulerException {
        QuartzTaskJobListener toBeUpdated = this.findJobListener(jobDetail.getKey());
        if (toBeUpdated != null) {
            QuartzTaskInfo taskInfo = toBeUpdated.getTaskInfo();
            taskInfo.setNexusTaskStateIfInState(TaskInfo.State.WAITING, new QuartzTaskState(taskInfo.getConfiguration().apply(QuartzTaskJob.configurationOf(jobDetail)), taskInfo.getSchedule(), taskInfo.getCurrentState().getNextRun()), taskInfo.getTaskFuture());
        }
    }

    private void updateJobListener(Trigger trigger) throws SchedulerException {
        QuartzTaskJobListener toBeUpdated = this.findJobListener(trigger.getJobKey());
        if (toBeUpdated != null) {
            QuartzTaskInfo taskInfo = toBeUpdated.getTaskInfo();
            taskInfo.setNexusTaskStateIfInState(TaskInfo.State.WAITING, new QuartzTaskState(taskInfo.getConfiguration(), this.triggerConverter.convert(trigger), trigger.getFireTimeAfter(new Date())), taskInfo.getTaskFuture());
        }
    }

    private void removeJobListener(JobKey jobKey) throws SchedulerException {
        String name = QuartzTaskJobListener.listenerName(jobKey);
        QuartzTaskJobListener toBeRemoved = (QuartzTaskJobListener)this.scheduler.getListenerManager().getJobListener(name);
        if (toBeRemoved != null) {
            QuartzTaskFuture future = toBeRemoved.getTaskInfo().getTaskFuture();
            if (future != null && !future.isDone()) {
                future.doCancel();
            }
            this.scheduler.getListenerManager().removeJobListener(name);
        }
    }

    @Guarded(by={"STARTED"})
    public ScheduleFactory scheduleFactory() {
        return this.scheduleFactory;
    }

    @Guarded(by={"STARTED"})
    public String renderStatusMessage() {
        SchedulerMetaData metaData;
        StringBuilder buff = new StringBuilder();
        try {
            metaData = this.scheduler.getMetaData();
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
        if (metaData.isShutdown()) {
            buff.append("Shutdown");
        } else {
            if (metaData.getRunningSince() != null) {
                buff.append("Started");
            } else {
                buff.append("Stopped");
            }
            if (metaData.isInStandbyMode()) {
                buff.append("; Stand-by");
            }
        }
        return buff.toString();
    }

    @Guarded(by={"STARTED"})
    public String renderDetailMessage() {
        try {
            return this.scheduler.getMetaData().getSummary();
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    @Guarded(by={"STARTED"})
    public TaskInfo getTaskById(String id) {
        try {
            QuartzTaskInfo task = this.findTaskById(id);
            if (task != null && !task.isRemovedOrDone()) {
                return task;
            }
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    @Guarded(by={"STARTED"})
    public List<TaskInfo> listsTasks() {
        try {
            return this.allTasks().values().stream().filter(task -> !task.isRemovedOrDone()).collect(Collectors.toList());
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Guarded(by={"STARTED"})
    public TaskInfo scheduleTask(TaskConfiguration config, Schedule schedule) {
        Preconditions.checkState((!EventHelper.isReplicating() ? 1 : 0) != 0, (Object)"Replication in progress");
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                QuartzTaskInfo old;
                TcclBlock tccl = TcclBlock.begin((Object)((Object)this));
                try {
                    old = this.findTaskById(config.getId());
                    if (old != null) {
                        Preconditions.checkState((!(old.getSchedule() instanceof Now) ? 1 : 0) != 0, (Object)"Run 'now' task cannot be rescheduled");
                        Preconditions.checkState((!old.isRemovedOrDone() ? 1 : 0) != 0, (Object)"Done task cannot be rescheduled");
                        QuartzTaskFuture future = old.getTaskFuture();
                        if (future != null) {
                            Preconditions.checkState((!(schedule instanceof Now) ? 1 : 0) != 0, (Object)"Running task cannot be rescheduled with 'now'");
                        }
                        this.log.debug("Task {} : {} rescheduled {} -> {} ", new Object[]{old.getJobKey().getName(), old.getConfiguration().getTaskLogName(), old.getSchedule(), schedule});
                        JobDetail jobDetail = this.buildJob(config, old.getJobKey());
                        Trigger trigger = this.buildTrigger(schedule, jobDetail);
                        this.scheduler.addJob(jobDetail, true, true);
                        this.scheduler.rescheduleJob(trigger.getKey(), trigger);
                        old.setNexusTaskStateIfInState(TaskInfo.State.WAITING, new QuartzTaskState(config, schedule, trigger.getFireTimeAfter(new Date())), future);
                        if (!config.isEnabled()) {
                            this.scheduler.pauseJob(old.getJobKey());
                            return old;
                        }
                        this.scheduler.resumeJob(old.getJobKey());
                        return old;
                    }
                    JobKey jobKey = JobKey.jobKey((String)UUID.randomUUID().toString(), (String)"nexus");
                    JobDetail jobDetail = this.buildJob(config, jobKey);
                    Trigger trigger = this.buildTrigger(schedule, jobDetail);
                    this.log.debug("Task {} : {} scheduled with key: {} and schedule: {}", new Object[]{config.getId(), config.getTaskLogName(), jobKey.getName(), schedule});
                    QuartzTaskJobListener listener = this.attachJobListener(jobDetail, trigger);
                    this.scheduler.scheduleJob(jobDetail, trigger);
                    if (!config.isEnabled()) {
                        this.scheduler.pauseJob(jobKey);
                    }
                    return listener.getTaskInfo();
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    if (tccl == null) return old;
                    tccl.close();
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    private JobDetail buildJob(TaskConfiguration config, JobKey jobKey) {
        return JobBuilder.newJob(QuartzTaskJob.class).withIdentity(jobKey).withDescription(config.getName()).requestRecovery(config.isRecoverable()).usingJobData(new JobDataMap(config.asMap())).build();
    }

    private Trigger buildTrigger(Schedule schedule, JobDetail jobDetail) {
        return this.ensureStartsInTheFuture(this.triggerConverter.convert(schedule).withIdentity(jobDetail.getKey().getName(), jobDetail.getKey().getGroup()).withDescription(jobDetail.getDescription()).usingJobData(new JobDataMap(Maps.filterKeys((Map)jobDetail.getJobDataMap(), INHERITED_CONFIG_KEYS::contains))).build());
    }

    @Guarded(by={"STARTED"})
    public int getRunningTaskCount() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (TcclBlock tccl = TcclBlock.begin((Object)((Object)this));){
                return this.scheduler.getCurrentlyExecutingJobs().size();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    @Guarded(by={"STARTED"})
    public int getExecutedTaskCount() {
        return this.quartzScheduler.numJobsExecuted();
    }

    private Trigger ensureStartsInTheFuture(Trigger trigger) {
        Date fireTimeAfter;
        Date now = new Date();
        if (trigger.getStartTime().before(now) && (fireTimeAfter = trigger.getFireTimeAfter(now)) != null) {
            return trigger.getTriggerBuilder().startAt(fireTimeAfter).build();
        }
        return trigger;
    }

    private Map<JobKey, QuartzTaskInfo> allTasks() throws SchedulerException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (TcclBlock tccl = TcclBlock.begin((Object)((Object)this));){
            HashMap<JobKey, QuartzTaskInfo> result = new HashMap<JobKey, QuartzTaskInfo>();
            Set jobKeys = this.scheduler.getJobKeys(GroupMatcher.jobGroupEquals((String)"nexus"));
            for (JobKey jobKey : jobKeys) {
                QuartzTaskJobListener listener = this.findJobListener(jobKey);
                if (listener != null) {
                    result.put(jobKey, listener.getTaskInfo());
                    continue;
                }
                this.log.warn("Job missing listener; omitting from results: {}", (Object)jobKey);
            }
            return result;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Nullable
    private QuartzTaskInfo findTaskById(String id) throws SchedulerException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (TcclBlock tccl = TcclBlock.begin((Object)((Object)this));){
            return this.allTasks().values().stream().filter(task -> task.getId().equals(id)).findFirst().orElse(null);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Guarded(by={"STARTED"})
    public boolean cancelJob(JobKey jobKey) {
        Preconditions.checkNotNull((Object)jobKey);
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (TcclBlock tccl = TcclBlock.begin((Object)((Object)this));){
                return this.scheduler.interrupt(jobKey);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (UnableToInterruptJobException e) {
            this.log.debug("Unable to interrupt job with key: {}", (Object)jobKey, (Object)e);
            return false;
        }
    }

    @Guarded(by={"STARTED"})
    public void runNow(String triggerSource, JobKey jobKey, QuartzTaskInfo taskInfo, QuartzTaskState taskState) throws TaskRemovedException, SchedulerException {
        Preconditions.checkState((boolean)this.active, (Object)"Cannot run tasks while scheduler is paused");
        TaskConfiguration config = taskState.getConfiguration();
        if (!this.isLimitedToAnotherNode(config)) {
            taskInfo.setNexusTaskState(TaskInfo.State.RUNNING, taskState, new QuartzTaskFuture(this, jobKey, config.getTaskLogName(), new Date(), (Schedule)this.scheduleFactory().now(), triggerSource));
        }
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (TcclBlock tccl = TcclBlock.begin((Object)((Object)this));){
                JobDataMap triggerDetail = this.triggerConverter.convert((Schedule)this.scheduleFactory().now()).build().getJobDataMap();
                triggerDetail.putAll(Maps.filterKeys((Map)config.asMap(), INHERITED_CONFIG_KEYS::contains));
                this.scheduler.triggerJob(jobKey, triggerDetail);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (JobPersistenceException e) {
            throw new TaskRemovedException(jobKey.getName(), (Throwable)e);
        }
    }

    @Guarded(by={"STARTED"})
    public boolean removeTask(JobKey jobKey) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (TcclBlock tccl = TcclBlock.begin((Object)((Object)this));){
                boolean result = false;
                List triggers = this.scheduler.getTriggersOfJob(jobKey);
                for (Trigger trigger : triggers) {
                    boolean bl = result = this.scheduler.unscheduleJob(trigger.getKey()) || result;
                }
                this.removeJobListener(jobKey);
                return result;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    @Subscribe
    public void on(JobCreatedEvent event) {
        if (!event.isLocal() && this.isStarted()) {
            JobDetail jobDetail = (JobDetail)event.getJob().getValue();
            this.quartzScheduler.getSchedulerSignaler().signalSchedulingChange(0L);
            this.quartzScheduler.notifySchedulerListenersJobAdded(jobDetail);
        }
    }

    @Subscribe
    public void on(JobUpdatedEvent event) throws SchedulerException {
        if (!event.isLocal() && this.isStarted()) {
            JobDetail jobDetail = (JobDetail)event.getJob().getValue();
            this.updateJobListener(jobDetail);
            this.quartzScheduler.getSchedulerSignaler().signalSchedulingChange(0L);
            this.quartzScheduler.notifySchedulerListenersJobAdded(jobDetail);
        }
    }

    @Subscribe
    public void on(JobDeletedEvent event) throws SchedulerException {
        if (!event.isLocal() && this.isStarted()) {
            JobDetail jobDetail = (JobDetail)event.getJob().getValue();
            this.quartzScheduler.getSchedulerSignaler().signalSchedulingChange(0L);
            this.quartzScheduler.notifySchedulerListenersJobDeleted(jobDetail.getKey());
            this.removeJobListener(jobDetail.getKey());
        }
    }

    @Subscribe
    public void on(TriggerCreatedEvent event) throws SchedulerException {
        if (!event.isLocal() && this.isStarted()) {
            Trigger trigger = (Trigger)event.getTrigger().getValue();
            if (!QuartzSchedulerSPI.isRunNow(trigger)) {
                this.attachJobListener(((JobStore)this.jobStoreProvider.get()).retrieveJob(trigger.getJobKey()), trigger);
                this.quartzScheduler.getSchedulerSignaler().signalSchedulingChange(QuartzSchedulerSPI.getNextFireMillis(trigger));
                this.quartzScheduler.notifySchedulerListenersSchduled(trigger);
            } else if (this.isLimitedToThisNode(trigger)) {
                this.quartzScheduler.getSchedulerSignaler().signalSchedulingChange(0L);
                this.quartzScheduler.notifySchedulerListenersSchduled(trigger);
            }
        }
    }

    @Subscribe
    public void on(TriggerUpdatedEvent event) throws SchedulerException {
        Trigger trigger;
        if (!event.isLocal() && this.isStarted() && !QuartzSchedulerSPI.isRunNow(trigger = (Trigger)event.getTrigger().getValue())) {
            this.updateJobListener(trigger);
            this.quartzScheduler.getSchedulerSignaler().signalSchedulingChange(QuartzSchedulerSPI.getNextFireMillis(trigger));
            this.quartzScheduler.notifySchedulerListenersUnscheduled(trigger.getKey());
            this.quartzScheduler.notifySchedulerListenersSchduled(trigger);
        }
    }

    @Subscribe
    public void on(TriggerDeletedEvent event) throws SchedulerException {
        Trigger trigger;
        if (!event.isLocal() && this.isStarted() && !QuartzSchedulerSPI.isRunNow(trigger = (Trigger)event.getTrigger().getValue())) {
            this.quartzScheduler.getSchedulerSignaler().signalSchedulingChange(0L);
            this.quartzScheduler.notifySchedulerListenersUnscheduled(trigger.getKey());
            this.removeJobListener(trigger.getJobKey());
        }
    }

    public boolean isLimitedToAnotherNode(TaskConfiguration config) {
        if (this.nodeAccess.isClustered() && config.containsKey("limitnode")) {
            String limitedNodeId = config.getString("limitnode");
            Preconditions.checkState((!Strings2.isBlank((String)limitedNodeId) ? 1 : 0) != 0, (String)"Task '%s' is not configured for HA", (Object)config.getName());
            Preconditions.checkState((boolean)this.nodeAccess.getMemberIds().contains(limitedNodeId), (String)"Task '%s' uses node %s which is not a member of this cluster", (Object)config.getName(), (Object)limitedNodeId);
            return !this.nodeAccess.getId().equals(limitedNodeId);
        }
        return false;
    }

    private boolean isLimitedToThisNode(Trigger trigger) {
        return this.nodeAccess.getId().equals(trigger.getJobDataMap().getString("limitnode"));
    }

    private static boolean isRunNow(Trigger trigger) {
        return "now".equals(trigger.getJobDataMap().getString("schedule.type"));
    }

    private static long getNextFireMillis(Trigger trigger) {
        Date nextFireTime = trigger.getNextFireTime();
        return nextFireTime != null ? nextFireTime.getTime() : 0L;
    }
}

