/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.quartz.internal.orient;

import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.quartz.Calendar;
import org.quartz.CronExpression;
import org.sonatype.nexus.orient.OClassNameBuilder;
import org.sonatype.nexus.orient.OIndexNameBuilder;
import org.sonatype.nexus.orient.entity.EntityAdapter;
import org.sonatype.nexus.orient.entity.action.BrowsePropertyAction;
import org.sonatype.nexus.orient.entity.action.DeleteEntitiesAction;
import org.sonatype.nexus.orient.entity.action.DeleteEntityByPropertyAction;
import org.sonatype.nexus.orient.entity.action.ReadEntityByPropertyAction;
import org.sonatype.nexus.quartz.internal.orient.CalendarEntity;
import org.sonatype.nexus.quartz.internal.orient.CronExpressionMixin;
import org.sonatype.nexus.quartz.internal.orient.FieldObjectMapper;
import org.sonatype.nexus.quartz.internal.orient.JacksonMarshaller;
import org.sonatype.nexus.quartz.internal.orient.MarshalledEntityAdapter;
import org.sonatype.nexus.quartz.internal.orient.Marshaller;

@Named
@Singleton
public class CalendarEntityAdapter
extends MarshalledEntityAdapter<CalendarEntity> {
    private static final String DB_CLASS = new OClassNameBuilder().prefix("quartz").type("calendar").build();
    private static final String P_NAME = "name";
    private static final String I_NAME = new OIndexNameBuilder().type(DB_CLASS).property("name").build();
    private final BrowsePropertyAction<String> browseNames = new BrowsePropertyAction((EntityAdapter)this, "name");
    private final ReadEntityByPropertyAction<CalendarEntity> readByName = new ReadEntityByPropertyAction((EntityAdapter)this, new String[]{"name"});
    private final DeleteEntityByPropertyAction deleteByName = new DeleteEntityByPropertyAction((EntityAdapter)this, new String[]{"name"});
    private final DeleteEntitiesAction deleteAll = new DeleteEntitiesAction((EntityAdapter)this);

    @Inject
    public CalendarEntityAdapter() {
        super(DB_CLASS, CalendarEntityAdapter.createMarshaller(), Calendar.class.getClassLoader());
    }

    private static Marshaller createMarshaller() {
        return new JacksonMarshaller(new FieldObjectMapper().addMixIn(CronExpression.class, CronExpressionMixin.class));
    }

    @Override
    protected void defineType(OClass type) {
        super.defineType(type);
        type.createProperty(P_NAME, OType.STRING).setMandatory(true).setNotNull(true);
        type.createIndex(I_NAME, OClass.INDEX_TYPE.UNIQUE, new String[]{P_NAME});
    }

    protected CalendarEntity newEntity() {
        return new CalendarEntity();
    }

    protected void readFields(ODocument document, CalendarEntity entity) throws Exception {
        super.readFields(document, entity);
        entity.setName((String)document.field(P_NAME));
    }

    protected void writeFields(ODocument document, CalendarEntity entity) throws Exception {
        super.writeFields(document, entity);
        document.field(P_NAME, (Object)entity.getName());
    }

    public List<String> browseNames(ODatabaseDocumentTx db) {
        return this.browseNames.execute(db);
    }

    @Nullable
    public CalendarEntity readByName(ODatabaseDocumentTx db, String name) {
        return (CalendarEntity)this.readByName.execute(db, new Object[]{name});
    }

    public boolean deleteByName(ODatabaseDocumentTx db, String name) {
        return this.deleteByName.execute(db, new Object[]{name});
    }

    public void deleteAll(ODatabaseDocumentTx db) {
        this.deleteAll.execute(db);
    }
}

