/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.quartz.internal.orient;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import org.quartz.utils.Key;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.orient.entity.EntityAdapter;

public class DeleteEntityByKeyAction
extends ComponentSupport {
    private final String query;

    public DeleteEntityByKeyAction(EntityAdapter<?> adapter, String nameProperty, String groupProperty) {
        Preconditions.checkNotNull(adapter);
        Preconditions.checkNotNull((Object)nameProperty);
        Preconditions.checkNotNull((Object)groupProperty);
        this.query = String.format("DELETE FROM %s WHERE %s = ? AND %s = ?", adapter.getTypeName(), nameProperty, groupProperty);
    }

    public boolean execute(ODatabaseDocumentTx db, Key key) {
        Preconditions.checkNotNull((Object)db);
        Preconditions.checkNotNull((Object)key);
        int records = (Integer)db.command((OCommandRequest)new OCommandSQL(this.query)).execute(new Object[]{key.getName(), key.getGroup()});
        return records == 1;
    }

    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "{" + "query='" + this.query + '\'' + '}';
    }
}

