/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.quartz.internal.orient;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.util.List;
import org.quartz.utils.Key;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.orient.entity.EntityAdapter;

public class ExistsByKeyAction
extends ComponentSupport {
    private final String query;

    public ExistsByKeyAction(EntityAdapter<?> adapter, String nameProperty, String groupProperty) {
        Preconditions.checkNotNull(adapter);
        Preconditions.checkNotNull((Object)nameProperty);
        Preconditions.checkNotNull((Object)groupProperty);
        this.query = String.format("SELECT count(*) FROM %s WHERE %s = ? AND %s = ?", adapter.getTypeName(), nameProperty, groupProperty);
    }

    public boolean execute(ODatabaseDocumentTx db, Key key) {
        Preconditions.checkNotNull((Object)db);
        Preconditions.checkNotNull((Object)key);
        List results = (List)db.command((OCommandRequest)new OSQLSynchQuery(this.query)).execute(new Object[]{key.getName(), key.getGroup()});
        return (Long)((ODocument)results.get(0)).field("count") == 1L;
    }

    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "{" + "query='" + this.query + '\'' + '}';
    }
}

