/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.quartz.internal.orient;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.sonatype.nexus.quartz.internal.orient.MarshalledEntity;

public class JobDetailEntity
extends MarshalledEntity<JobDetail> {
    private String name;
    @Nullable
    private String group;
    private String jobType;

    public JobDetailEntity() {
    }

    public JobDetailEntity(JobDetail value) {
        this.setValue(value);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Nullable
    public String getGroup() {
        return this.group;
    }

    public void setGroup(@Nullable String group) {
        this.group = group;
    }

    public String getJobType() {
        return this.jobType;
    }

    public void setJobType(String jobType) {
        this.jobType = jobType;
    }

    @Override
    public void setValue(JobDetail value) {
        super.setValue(value);
        JobKey key = value.getKey();
        Preconditions.checkState((key != null ? 1 : 0) != 0, (Object)"Missing key");
        this.setName(key.getName());
        this.setGroup(key.getGroup());
        Class clazz = value.getJobClass();
        Preconditions.checkState((clazz != null ? 1 : 0) != 0, (Object)"Missing job-class");
        this.setJobType(clazz.getCanonicalName());
    }

    @Override
    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "{" + "name='" + this.name + '\'' + ", group='" + this.group + '\'' + ", jobType='" + this.jobType + '\'' + ", value=" + this.getValue() + '}';
    }
}

