/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.quartz.internal.orient;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.orientechnologies.common.concur.ONeedRetryException;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.quartz.Calendar;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.JobPersistenceException;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.SchedulerConfigException;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.spi.ClassLoadHelper;
import org.quartz.spi.JobStore;
import org.quartz.spi.OperableTrigger;
import org.quartz.spi.SchedulerSignaler;
import org.quartz.spi.TriggerFiredBundle;
import org.quartz.spi.TriggerFiredResult;
import org.quartz.utils.Key;
import org.slf4j.Logger;
import org.sonatype.goodies.common.Time;
import org.sonatype.goodies.lifecycle.LifecycleSupport;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.log.ExceptionSummarizer;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.transaction.OrientOperations;
import org.sonatype.nexus.orient.transaction.OrientTransactional;
import org.sonatype.nexus.quartz.internal.orient.CalendarEntity;
import org.sonatype.nexus.quartz.internal.orient.CalendarEntityAdapter;
import org.sonatype.nexus.quartz.internal.orient.JobDetailEntity;
import org.sonatype.nexus.quartz.internal.orient.JobDetailEntityAdapter;
import org.sonatype.nexus.quartz.internal.orient.TriggerEntity;
import org.sonatype.nexus.quartz.internal.orient.TriggerEntityAdapter;

@Named(value="orient")
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SCHEMAS)
@Singleton
public class JobStoreImpl
extends LifecycleSupport
implements JobStore {
    private static final Set<TriggerEntity.State> ACQUIRABLE_ORPHAN_STATES = Sets.immutableEnumSet((Enum)TriggerEntity.State.ACQUIRED, (Enum[])new TriggerEntity.State[]{TriggerEntity.State.BLOCKED, TriggerEntity.State.WAITING});
    private static final Set<TriggerEntity.State> ACQUIRABLE_LOCAL_STATES = Sets.immutableEnumSet((Enum)TriggerEntity.State.WAITING, (Enum[])new TriggerEntity.State[0]);
    private static final Set<TriggerEntity.State> ALL_ACQUIRABLE_STATES = Sets.union(ACQUIRABLE_LOCAL_STATES, ACQUIRABLE_ORPHAN_STATES).immutableCopy();
    private static final String NODE_ID = "node.identity";
    private final Provider<DatabaseInstance> databaseInstance;
    private final JobDetailEntityAdapter jobDetailEntityAdapter;
    private final TriggerEntityAdapter triggerEntityAdapter;
    private final CalendarEntityAdapter calendarEntityAdapter;
    private final NodeAccess nodeAccess;
    private final ExceptionSummarizer acquireNextTriggersSummarizer;
    private final Time acquireRetryDelay;
    private SchedulerSignaler signaler;
    private String instanceName;
    private String instanceId;
    private final Object monitor;
    private static final Comparator<TriggerEntity> TRIGGER_COMPARATOR = new Comparator<TriggerEntity>(){

        @Override
        public int compare(TriggerEntity o1, TriggerEntity o2) {
            int res = ((OperableTrigger)o1.getValue()).getNextFireTime().compareTo(((OperableTrigger)o2.getValue()).getNextFireTime());
            if (res != 0) {
                return res;
            }
            return ((OperableTrigger)o2.getValue()).getPriority() - ((OperableTrigger)o1.getValue()).getPriority();
        }
    };
    private final long misfireThreshold;

    @Inject
    public JobStoreImpl(@Named(value="config") Provider<DatabaseInstance> databaseInstance, JobDetailEntityAdapter jobDetailEntityAdapter, TriggerEntityAdapter triggerEntityAdapter, CalendarEntityAdapter calendarEntityAdapter, NodeAccess nodeAccess, @Named(value="${nexus.quartz.jobStore.acquireRetryDelay:-15s}") Time acquireRetryDelay) {
        this.acquireNextTriggersSummarizer = ExceptionSummarizer.summarize((BiPredicate)ExceptionSummarizer.sameType(), (BiConsumer)ExceptionSummarizer.warn((Logger)this.log));
        this.monitor = new Object();
        this.misfireThreshold = Time.minutes((long)1L).toMillis();
        this.databaseInstance = (Provider)Preconditions.checkNotNull(databaseInstance);
        this.jobDetailEntityAdapter = (JobDetailEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)jobDetailEntityAdapter)));
        this.triggerEntityAdapter = (TriggerEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)triggerEntityAdapter)));
        this.calendarEntityAdapter = (CalendarEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)calendarEntityAdapter)));
        this.nodeAccess = (NodeAccess)Preconditions.checkNotNull((Object)nodeAccess);
        this.acquireRetryDelay = acquireRetryDelay;
    }

    public boolean supportsPersistence() {
        return true;
    }

    public boolean isClustered() {
        return this.nodeAccess.isClustered();
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public void setThreadPoolSize(int poolSize) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T execute(Operation<T> operation) throws JobPersistenceException {
        try {
            Object object = this.monitor;
            synchronized (object) {
                return (T)((OrientOperations)OrientTransactional.inTx(this.databaseInstance).retryOn(new Class[]{ONeedRetryException.class, ORecordNotFoundException.class})).throwing(JobPersistenceException.class).call(operation::execute);
            }
        }
        catch (Exception e) {
            this.log.warn("Execution failed", (Throwable)e);
            Throwables.propagateIfPossible((Throwable)e, JobPersistenceException.class);
            throw new JobPersistenceException(e.toString(), (Throwable)e);
        }
    }

    private <T> T executeAndPropagate(Operation<T> operation) {
        try {
            return this.execute(operation);
        }
        catch (JobPersistenceException e) {
            throw new RuntimeException(e);
        }
    }

    protected void doStart() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.databaseInstance.get()).connect();){
            this.jobDetailEntityAdapter.register(db);
            this.triggerEntityAdapter.register(db);
            this.calendarEntityAdapter.register(db);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void initialize(ClassLoadHelper loadHelper, SchedulerSignaler signaler) throws SchedulerConfigException {
        this.log.info("Instance name: {}; ID: {}", (Object)this.instanceName, (Object)this.instanceId);
        this.signaler = (SchedulerSignaler)Preconditions.checkNotNull((Object)signaler);
        this.log.info("Initialized");
    }

    public void schedulerStarted() throws SchedulerException {
        this.execute(db -> {
            for (TriggerEntity triggerEntity : this.local(this.triggerEntityAdapter.browse(db))) {
                switch (triggerEntity.getState()) {
                    case ACQUIRED: 
                    case BLOCKED: {
                        triggerEntity.setState(TriggerEntity.State.WAITING);
                        break;
                    }
                    case PAUSED_BLOCKED: {
                        triggerEntity.setState(TriggerEntity.State.PAUSED);
                    }
                }
                if (TriggerEntity.State.COMPLETE == triggerEntity.getState()) {
                    this.triggerEntityAdapter.deleteEntity(db, (Entity)triggerEntity);
                    continue;
                }
                this.applyMisfire(db, triggerEntity);
                this.triggerEntityAdapter.editEntity(db, (Entity)triggerEntity);
            }
            return null;
        });
    }

    public void schedulerPaused() {
    }

    public void schedulerResumed() {
    }

    public void shutdown() {
    }

    public long getEstimatedTimeToReleaseAndAcquireTrigger() {
        return 70L;
    }

    public void clearAllSchedulingData() throws JobPersistenceException {
        this.execute(db -> {
            this.jobDetailEntityAdapter.deleteAll(db);
            this.triggerEntityAdapter.deleteAll(db);
            this.calendarEntityAdapter.deleteAll(db);
            return null;
        });
    }

    public void storeJob(JobDetail jobDetail, boolean replaceExisting) throws JobPersistenceException {
        this.execute(db -> {
            this.storeJob(db, jobDetail, replaceExisting);
            return null;
        });
    }

    private void storeJob(ODatabaseDocumentTx db, JobDetail jobDetail, boolean replaceExisting) throws JobPersistenceException {
        this.log.debug("Store job: jobDetail={}, replaceExisting={}", (Object)jobDetail, (Object)replaceExisting);
        JobDetailEntity entity = this.jobDetailEntityAdapter.readByKey(db, jobDetail.getKey());
        if (entity == null) {
            entity = new JobDetailEntity(jobDetail);
            this.jobDetailEntityAdapter.addEntity(db, (Entity)entity);
        } else if (replaceExisting) {
            entity.setValue(jobDetail);
            this.jobDetailEntityAdapter.editEntity(db, (Entity)entity);
        } else {
            throw new ObjectAlreadyExistsException(jobDetail);
        }
    }

    public boolean removeJob(JobKey jobKey) throws JobPersistenceException {
        this.log.debug("Remove job: {}", (Object)jobKey);
        return this.execute(db -> this.removeJob(db, jobKey));
    }

    private boolean removeJob(ODatabaseDocumentTx db, JobKey jobKey) throws JobPersistenceException {
        boolean deleted = this.jobDetailEntityAdapter.deleteByKey(db, jobKey);
        this.triggerEntityAdapter.deleteByJobKey(db, jobKey);
        return deleted;
    }

    public boolean removeJobs(List<JobKey> jobKeys) throws JobPersistenceException {
        this.log.debug("Remove jobs: {}", jobKeys);
        return this.execute(db -> {
            boolean allDeleted = true;
            for (JobKey key : jobKeys) {
                boolean bl = allDeleted = this.removeJob(db, key) && allDeleted;
            }
            return allDeleted;
        });
    }

    @Nullable
    public JobDetail retrieveJob(JobKey jobKey) throws JobPersistenceException {
        return this.execute(db -> {
            JobDetailEntity entity = this.jobDetailEntityAdapter.readByKey(db, jobKey);
            return entity != null ? (JobDetail)entity.getValue() : null;
        });
    }

    public boolean checkExists(JobKey jobKey) throws JobPersistenceException {
        return this.execute(db -> this.jobDetailEntityAdapter.existsByKey(db, jobKey));
    }

    public int getNumberOfJobs() throws JobPersistenceException {
        return this.execute(db -> this.jobDetailEntityAdapter.countI(db));
    }

    public List<String> getJobGroupNames() throws JobPersistenceException {
        return this.execute(db -> {
            ArrayList<String> result = new ArrayList<String>();
            for (JobDetailEntity entity : this.jobDetailEntityAdapter.browse(db)) {
                result.add(entity.getGroup());
            }
            return result.stream().distinct().collect(Collectors.toList());
        });
    }

    public Set<JobKey> getJobKeys(GroupMatcher<JobKey> matcher) throws JobPersistenceException {
        return this.execute(db -> this.getJobKeys(db, matcher));
    }

    private Set<JobKey> getJobKeys(ODatabaseDocumentTx db, GroupMatcher<JobKey> matcher) throws JobPersistenceException {
        Iterable<JobDetailEntity> matches = this.jobDetailEntityAdapter.browseWithPredicate(db, input -> matcher.isMatch((Key)((JobDetail)input.getValue()).getKey()));
        HashSet<JobKey> result = new HashSet<JobKey>();
        for (JobDetailEntity entity : matches) {
            result.add(((JobDetail)entity.getValue()).getKey());
        }
        return result;
    }

    public void pauseJob(JobKey jobKey) throws JobPersistenceException {
        this.execute(db -> {
            this.pauseJob(db, jobKey);
            return null;
        });
    }

    private void pauseJob(ODatabaseDocumentTx db, JobKey jobKey) throws JobPersistenceException {
        this.log.debug("Pause job: {}", (Object)jobKey);
        for (OperableTrigger trigger : this.getTriggersForJob(db, jobKey)) {
            this.pauseTrigger(db, trigger.getKey());
        }
    }

    public Collection<String> pauseJobs(GroupMatcher<JobKey> matcher) throws JobPersistenceException {
        this.log.debug("Pause jobs: {}", matcher);
        return this.execute(db -> {
            HashSet<String> groups = new HashSet<String>();
            for (JobKey jobKey : this.getJobKeys(db, matcher)) {
                groups.add(jobKey.getGroup());
            }
            for (String group : groups) {
                for (JobKey jobKey : this.getJobKeys(db, (GroupMatcher<JobKey>)GroupMatcher.jobGroupEquals((String)group))) {
                    this.pauseJob(db, jobKey);
                }
            }
            return groups;
        });
    }

    public void resumeJob(JobKey jobKey) throws JobPersistenceException {
        this.execute(db -> {
            this.resumeJob(db, jobKey);
            return null;
        });
    }

    private void resumeJob(ODatabaseDocumentTx db, JobKey jobKey) throws JobPersistenceException {
        this.log.debug("Resume job: {}", (Object)jobKey);
        for (OperableTrigger trigger : this.getTriggersForJob(db, jobKey)) {
            this.resumeTrigger(db, trigger.getKey());
        }
    }

    public Collection<String> resumeJobs(GroupMatcher<JobKey> matcher) throws JobPersistenceException {
        this.log.debug("Resume jobs: {}", matcher);
        return this.execute(db -> {
            HashSet<String> groups = new HashSet<String>();
            for (JobKey jobKey : this.getJobKeys(db, matcher)) {
                groups.add(jobKey.getGroup());
            }
            for (String group : groups) {
                for (JobKey jobKey : this.getJobKeys(db, (GroupMatcher<JobKey>)GroupMatcher.jobGroupEquals((String)group))) {
                    this.resumeJob(db, jobKey);
                }
            }
            return groups;
        });
    }

    public void storeJobAndTrigger(JobDetail jobDetail, OperableTrigger trigger) throws JobPersistenceException {
        this.execute(db -> {
            this.storeJob(db, jobDetail, false);
            this.storeTrigger(db, trigger, false);
            return null;
        });
    }

    public void storeJobsAndTriggers(Map<JobDetail, Set<? extends Trigger>> jobsAndTriggers, boolean replace) throws JobPersistenceException {
        this.execute(db -> {
            for (Map.Entry entry : jobsAndTriggers.entrySet()) {
                JobDetail jobDetail = (JobDetail)entry.getKey();
                this.storeJob(db, jobDetail, replace);
                Set triggers = (Set)entry.getValue();
                for (Trigger trigger : triggers) {
                    this.storeTrigger(db, (OperableTrigger)trigger, replace);
                }
            }
            return null;
        });
    }

    public void storeTrigger(OperableTrigger trigger, boolean replaceExisting) throws JobPersistenceException {
        this.execute(db -> {
            this.storeTrigger(db, trigger, replaceExisting);
            return null;
        });
    }

    private void storeTrigger(ODatabaseDocumentTx db, OperableTrigger trigger, boolean replaceExisting) throws JobPersistenceException {
        TriggerEntity entity;
        this.log.debug("Store trigger: trigger={}, replaceExisting={}", (Object)trigger, (Object)replaceExisting);
        if (this.isClustered()) {
            trigger.getJobDataMap().put(NODE_ID, this.nodeAccess.getId());
        }
        if ((entity = this.triggerEntityAdapter.readByKey(db, trigger.getKey())) == null) {
            entity = new TriggerEntity(trigger, TriggerEntity.State.WAITING);
            this.triggerEntityAdapter.addEntity(db, (Entity)entity);
        } else if (replaceExisting) {
            entity.setValue(trigger);
            this.triggerEntityAdapter.editEntity(db, (Entity)entity);
        } else {
            throw new ObjectAlreadyExistsException((Trigger)trigger);
        }
    }

    public boolean removeTrigger(TriggerKey triggerKey) throws JobPersistenceException {
        this.log.debug("Remove trigger: {}", (Object)triggerKey);
        return this.execute(db -> this.removeTrigger(db, triggerKey));
    }

    private boolean removeTrigger(ODatabaseDocumentTx db, TriggerKey triggerKey) throws JobPersistenceException {
        JobDetailEntity jobDetailEntity;
        Iterable<TriggerEntity> jobTriggers;
        TriggerEntity entity = this.triggerEntityAdapter.readByKey(db, triggerKey);
        if (entity == null) {
            this.log.debug("No matching Trigger to remove for key: {}", (Object)triggerKey);
            return false;
        }
        JobKey jobKey = ((OperableTrigger)entity.getValue()).getJobKey();
        boolean deleted = this.triggerEntityAdapter.deleteByKey(db, triggerKey);
        this.log.debug("Trigger deleted: {} for key: {}", (Object)deleted, (Object)triggerKey);
        if (deleted && !(jobTriggers = this.triggerEntityAdapter.browseByJobKey(db, jobKey)).iterator().hasNext() && (jobDetailEntity = this.jobDetailEntityAdapter.readByKey(db, jobKey)) != null && !((JobDetail)jobDetailEntity.getValue()).isDurable()) {
            boolean jobDeleted = this.jobDetailEntityAdapter.deleteByKey(db, jobKey);
            this.log.debug("Job deleted: {} for jobKey: {}", (Object)deleted, (Object)jobKey);
            if (jobDeleted) {
                this.signaler.notifySchedulerListenersJobDeleted(jobKey);
            }
        }
        return deleted;
    }

    public boolean removeTriggers(List<TriggerKey> triggerKeys) throws JobPersistenceException {
        this.log.debug("Remove triggers: {}", triggerKeys);
        return this.execute(db -> {
            boolean allDeleted = true;
            for (TriggerKey key : triggerKeys) {
                boolean bl = allDeleted = this.removeTrigger(db, key) && allDeleted;
            }
            return allDeleted;
        });
    }

    public boolean replaceTrigger(TriggerKey triggerKey, OperableTrigger trigger) throws JobPersistenceException {
        this.log.debug("Replace trigger: triggerKey={}, trigger={}", (Object)triggerKey, (Object)trigger);
        if (this.isClustered()) {
            trigger.getJobDataMap().put(NODE_ID, this.nodeAccess.getId());
        }
        return this.execute(db -> {
            TriggerEntity entity = this.triggerEntityAdapter.readByKey(db, triggerKey);
            if (entity != null) {
                if (!((OperableTrigger)entity.getValue()).getJobKey().equals((Object)trigger.getJobKey())) {
                    throw new JobPersistenceException("New trigger is not related to the same job as the old trigger");
                }
                entity.setValue(trigger);
                this.triggerEntityAdapter.editEntity(db, (Entity)entity);
                return true;
            }
            entity = new TriggerEntity(trigger, TriggerEntity.State.WAITING);
            this.triggerEntityAdapter.addEntity(db, (Entity)entity);
            return false;
        });
    }

    @Nullable
    public OperableTrigger retrieveTrigger(TriggerKey triggerKey) throws JobPersistenceException {
        return this.execute(db -> {
            TriggerEntity entity = this.triggerEntityAdapter.readByKey(db, triggerKey);
            return entity != null ? (OperableTrigger)entity.getValue() : null;
        });
    }

    public boolean checkExists(TriggerKey triggerKey) throws JobPersistenceException {
        return this.execute(db -> this.triggerEntityAdapter.existsByKey(db, triggerKey));
    }

    public int getNumberOfTriggers() throws JobPersistenceException {
        return this.execute(db -> this.triggerEntityAdapter.countI(db));
    }

    public Set<TriggerKey> getTriggerKeys(GroupMatcher<TriggerKey> matcher) throws JobPersistenceException {
        return this.execute(db -> this.getTriggerKeys(db, matcher));
    }

    private Set<TriggerKey> getTriggerKeys(ODatabaseDocumentTx db, GroupMatcher<TriggerKey> matcher) throws JobPersistenceException {
        Iterable<TriggerEntity> matches = this.triggerEntityAdapter.browseWithPredicate(db, input -> matcher.isMatch((Key)((OperableTrigger)input.getValue()).getKey()));
        HashSet<TriggerKey> result = new HashSet<TriggerKey>();
        for (TriggerEntity entity : matches) {
            result.add(((OperableTrigger)entity.getValue()).getKey());
        }
        return result;
    }

    private Set<String> getTriggerGroups(ODatabaseDocumentTx db, GroupMatcher<TriggerKey> matcher) throws JobPersistenceException {
        HashSet<String> groups = new HashSet<String>();
        for (TriggerKey triggerKey : this.getTriggerKeys(db, matcher)) {
            groups.add(triggerKey.getGroup());
        }
        return groups;
    }

    public List<String> getTriggerGroupNames() throws JobPersistenceException {
        return (List)this.execute(db -> ImmutableList.copyOf(this.getTriggerGroups(db, (GroupMatcher<TriggerKey>)GroupMatcher.anyGroup())));
    }

    public List<OperableTrigger> getTriggersForJob(JobKey jobKey) throws JobPersistenceException {
        return this.execute(db -> this.getTriggersForJob(db, jobKey));
    }

    private List<OperableTrigger> getTriggersForJob(ODatabaseDocumentTx db, JobKey jobKey) {
        ArrayList<OperableTrigger> result = new ArrayList<OperableTrigger>();
        for (TriggerEntity entity : this.triggerEntityAdapter.browseByJobKey(db, jobKey)) {
            result.add((OperableTrigger)entity.getValue());
        }
        return result;
    }

    public Trigger.TriggerState getTriggerState(TriggerKey triggerKey) throws JobPersistenceException {
        return this.execute(db -> {
            TriggerEntity entity = this.triggerEntityAdapter.readByKey(db, triggerKey);
            if (entity == null) {
                return Trigger.TriggerState.NONE;
            }
            switch (entity.getState()) {
                case COMPLETE: {
                    return Trigger.TriggerState.COMPLETE;
                }
                case PAUSED: 
                case PAUSED_BLOCKED: {
                    return Trigger.TriggerState.PAUSED;
                }
                case BLOCKED: {
                    return Trigger.TriggerState.BLOCKED;
                }
                case ERROR: {
                    return Trigger.TriggerState.ERROR;
                }
            }
            return Trigger.TriggerState.NORMAL;
        });
    }

    public void pauseTrigger(TriggerKey triggerKey) throws JobPersistenceException {
        this.execute(db -> {
            this.pauseTrigger(db, triggerKey);
            return null;
        });
    }

    private void pauseTrigger(ODatabaseDocumentTx db, TriggerKey triggerKey) throws JobPersistenceException {
        this.log.debug("Pause trigger: {}", (Object)triggerKey);
        TriggerEntity entity = this.triggerEntityAdapter.readByKey(db, triggerKey);
        if (entity == null) {
            return;
        }
        switch (entity.getState()) {
            case COMPLETE: {
                return;
            }
            case BLOCKED: {
                entity.setState(TriggerEntity.State.PAUSED_BLOCKED);
                break;
            }
            default: {
                entity.setState(TriggerEntity.State.PAUSED);
            }
        }
        this.triggerEntityAdapter.editEntity(db, (Entity)entity);
    }

    public Collection<String> pauseTriggers(GroupMatcher<TriggerKey> matcher) throws JobPersistenceException {
        this.log.debug("Pause triggers: {}", matcher);
        return this.execute(db -> {
            HashSet<String> groups = new HashSet<String>();
            for (TriggerKey triggerKey : this.getTriggerKeys(db, matcher)) {
                groups.add(triggerKey.getGroup());
            }
            for (String group : groups) {
                for (TriggerKey triggerKey : this.getTriggerKeys(db, (GroupMatcher<TriggerKey>)GroupMatcher.triggerGroupEquals((String)group))) {
                    this.pauseTrigger(db, triggerKey);
                }
            }
            return groups;
        });
    }

    public void pauseAll() throws JobPersistenceException {
        this.log.debug("Pause all");
        this.execute(db -> {
            for (TriggerKey triggerKey : this.getTriggerKeys(db, (GroupMatcher<TriggerKey>)GroupMatcher.anyGroup())) {
                this.pauseTrigger(db, triggerKey);
            }
            return null;
        });
    }

    public void resumeTrigger(TriggerKey triggerKey) throws JobPersistenceException {
        this.execute(db -> {
            this.resumeTrigger(db, triggerKey);
            return null;
        });
    }

    private void resumeTrigger(ODatabaseDocumentTx db, TriggerKey triggerKey) throws JobPersistenceException {
        this.log.debug("Resume trigger: {}", (Object)triggerKey);
        TriggerEntity entity = this.triggerEntityAdapter.readByKey(db, triggerKey);
        if (entity == null) {
            return;
        }
        if (entity.getState() == TriggerEntity.State.PAUSED_BLOCKED) {
            entity.setState(TriggerEntity.State.BLOCKED);
        } else {
            entity.setState(TriggerEntity.State.WAITING);
        }
        this.applyMisfire(db, entity);
        this.triggerEntityAdapter.editEntity(db, (Entity)entity);
    }

    public Collection<String> resumeTriggers(GroupMatcher<TriggerKey> matcher) throws JobPersistenceException {
        this.log.debug("Resume triggers: {}", matcher);
        return this.execute(db -> {
            Set<String> groups = this.getTriggerGroups(db, matcher);
            for (String group : groups) {
                for (TriggerKey triggerKey : this.getTriggerKeys(db, (GroupMatcher<TriggerKey>)GroupMatcher.triggerGroupEquals((String)group))) {
                    this.resumeTrigger(db, triggerKey);
                }
            }
            return groups;
        });
    }

    public void resumeAll() throws JobPersistenceException {
        this.log.debug("Resume all");
        this.execute(db -> {
            for (TriggerKey triggerKey : this.getTriggerKeys(db, (GroupMatcher<TriggerKey>)GroupMatcher.anyGroup())) {
                this.resumeTrigger(db, triggerKey);
            }
            return null;
        });
    }

    public Set<String> getPausedTriggerGroups() throws JobPersistenceException {
        return this.execute(db -> {
            HashSet<String> pausedGroups = new HashSet<String>();
            Set<String> groups = this.getTriggerGroups(db, (GroupMatcher<TriggerKey>)GroupMatcher.anyGroup());
            for (String group : groups) {
                boolean allPaused;
                boolean bl = allPaused = !ImmutableList.copyOf(this.triggerEntityAdapter.browseByGroup(db, group)).stream().anyMatch(e -> TriggerEntity.State.PAUSED != e.getState() && TriggerEntity.State.PAUSED_BLOCKED != e.getState());
                if (!allPaused) continue;
                pausedGroups.add(group);
            }
            return pausedGroups;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OperableTrigger> acquireNextTriggers(long noLaterThan, int maxCount, long timeWindow) throws JobPersistenceException {
        try {
            Object object = this.monitor;
            synchronized (object) {
                return (List)((OrientOperations)OrientTransactional.inTx(this.databaseInstance).retryOn(new Class[]{ONeedRetryException.class, ORecordNotFoundException.class})).call(db -> this.doAcquireNextTriggers(db, noLaterThan, maxCount, timeWindow));
            }
        }
        catch (RuntimeException e) {
            this.acquireNextTriggersSummarizer.log("Problem acquiring next triggers", (Exception)e);
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
            throw new JobPersistenceException(e.toString(), (Throwable)e);
        }
    }

    public void resetTriggerFromErrorState(TriggerKey triggerKey) throws JobPersistenceException {
        this.execute(db -> {
            TriggerEntity.State newState = TriggerEntity.State.WAITING;
            if (this.isTriggerGroupPaused(db, triggerKey.getGroup())) {
                newState = TriggerEntity.State.PAUSED;
            }
            this.updateTriggerStatesForJobFromOtherState(db, triggerKey, newState, TriggerEntity.State.ERROR);
            return null;
        });
    }

    private boolean isTriggerGroupPaused(ODatabaseDocumentTx db, String groupName) {
        Iterable<TriggerEntity> matches = this.triggerEntityAdapter.browseWithPredicate(db, input -> groupName.equals(input.getGroup()) && TriggerEntity.State.PAUSED.equals((Object)input.getState()));
        return !Iterables.isEmpty(matches);
    }

    private void updateTriggerStatesForJobFromOtherState(ODatabaseDocumentTx db, TriggerKey triggerKey, TriggerEntity.State state, TriggerEntity.State oldState) {
        Iterable<TriggerEntity> matches = this.triggerEntityAdapter.browseWithPredicate(db, input -> triggerKey.getName().equals(input.getName()) && triggerKey.getGroup().equals(input.getGroup()) && oldState.equals((Object)input.getState()));
        matches.forEach(entity -> {
            entity.setState(state);
            this.triggerEntityAdapter.editEntity(db, (Entity)entity);
        });
    }

    public long getAcquireRetryDelay(int failureCount) {
        return this.acquireRetryDelay.toMillis();
    }

    private List<TriggerEntity> getAcquirableEntities(ODatabaseDocumentTx db, long noLaterThan, long timeWindow) {
        long noEarlierThan = this.getMisfireTime();
        ArrayList possibleEntities = new ArrayList();
        ArrayList<TriggerEntity> acquirableEntities = new ArrayList<TriggerEntity>();
        this.triggerEntityAdapter.browseByStates(db, ALL_ACQUIRABLE_STATES).forEach(possibleEntities::add);
        possibleEntities.stream().filter(this::isLocalOrOrphaned).filter(entity -> this.canBeAcquired((TriggerEntity)((Object)entity), db, noEarlierThan, noLaterThan + timeWindow)).forEach(acquirableEntities::add);
        return acquirableEntities;
    }

    private boolean isLocalOrOrphaned(TriggerEntity entity) {
        return this.isOrphaned(entity) && ACQUIRABLE_ORPHAN_STATES.contains((Object)entity.getState()) || this.isLocal(entity) && ACQUIRABLE_LOCAL_STATES.contains((Object)entity.getState());
    }

    private List<OperableTrigger> doAcquireNextTriggers(ODatabaseDocumentTx db, long noLaterThan, int maxCount, long timeWindow) {
        this.log.debug("Acquire next triggers: noLaterThan={}, maxCount={}, timeWindow={}", new Object[]{noLaterThan, maxCount, timeWindow});
        List<TriggerEntity> acquirableEntities = this.getAcquirableEntities(db, noLaterThan, timeWindow);
        if (acquirableEntities.isEmpty()) {
            return Collections.emptyList();
        }
        Collections.sort(acquirableEntities, TRIGGER_COMPARATOR);
        HashSet<JobKey> jobsAcquired = new HashSet<JobKey>();
        Iterator<TriggerEntity> triggerEntityIterator = acquirableEntities.iterator();
        while (triggerEntityIterator.hasNext()) {
            TriggerEntity triggerEntity = triggerEntityIterator.next();
            OperableTrigger trigger = (OperableTrigger)triggerEntity.getValue();
            JobKey jobKey = trigger.getJobKey();
            JobDetailEntity jobDetailEntity = this.jobDetailEntityAdapter.readByKey(db, jobKey);
            if (jobDetailEntity == null || !((JobDetail)jobDetailEntity.getValue()).isConcurrentExectionDisallowed()) continue;
            if (jobsAcquired.contains(jobKey)) {
                triggerEntityIterator.remove();
                continue;
            }
            jobsAcquired.add(jobKey);
        }
        if (!acquirableEntities.isEmpty() && maxCount < acquirableEntities.size()) {
            acquirableEntities = acquirableEntities.subList(0, maxCount);
        }
        ArrayList<OperableTrigger> result = new ArrayList<OperableTrigger>();
        for (TriggerEntity entity : acquirableEntities) {
            OperableTrigger trigger = (OperableTrigger)entity.getValue();
            trigger.setFireInstanceId(UUID.randomUUID().toString());
            if (this.isClustered()) {
                trigger.getJobDataMap().put(NODE_ID, this.nodeAccess.getId());
            }
            result.add(trigger);
            entity.setState(TriggerEntity.State.ACQUIRED);
            this.triggerEntityAdapter.editEntity(db, (Entity)entity);
        }
        this.log.trace("Acquired triggers: {}", result);
        return result;
    }

    public void releaseAcquiredTrigger(OperableTrigger trigger) {
        this.log.debug("Release acquired trigger: {}", (Object)trigger);
        this.executeAndPropagate(db -> {
            TriggerEntity entity = this.triggerEntityAdapter.readByKey(db, trigger.getKey());
            if (entity != null && entity.getState() == TriggerEntity.State.ACQUIRED) {
                entity.setState(TriggerEntity.State.WAITING);
                this.triggerEntityAdapter.editEntity(db, (Entity)entity);
            }
            return null;
        });
    }

    public List<TriggerFiredResult> triggersFired(List<OperableTrigger> triggers) throws JobPersistenceException {
        this.log.debug("Triggers fired: {}", triggers);
        return this.execute(db -> {
            ArrayList<TriggerFiredResult> results = new ArrayList<TriggerFiredResult>();
            for (OperableTrigger trigger : triggers) {
                TriggerFiredResult result;
                try {
                    TriggerFiredBundle bundle = this.triggerFired(db, trigger);
                    result = new TriggerFiredResult(bundle);
                }
                catch (Exception e) {
                    this.log.warn("Trigger fired failure", (Throwable)e);
                    result = new TriggerFiredResult(e);
                }
                results.add(result);
            }
            this.log.trace("Triggers fired results: {}", results);
            return results;
        });
    }

    @Nullable
    private TriggerFiredBundle triggerFired(ODatabaseDocumentTx db, OperableTrigger firedTrigger) {
        this.log.debug("Trigger fired: {}", (Object)firedTrigger);
        TriggerKey triggerKey = firedTrigger.getKey();
        TriggerEntity entity = this.triggerEntityAdapter.readByKey(db, triggerKey);
        if (entity == null) {
            this.log.trace("Trigger deleted; skipping");
            return null;
        }
        if (entity.getState() != TriggerEntity.State.ACQUIRED) {
            this.log.trace("Trigger state != ACQUIRED; skipping");
            return null;
        }
        OperableTrigger trigger = (OperableTrigger)entity.getValue();
        Calendar calendar = null;
        if (trigger.getCalendarName() != null && (calendar = this.findCalendar(db, trigger.getCalendarName())) == null) {
            this.log.trace("Calender was deleted; skipping");
            return null;
        }
        Date prevFireTime = trigger.getPreviousFireTime();
        firedTrigger.triggered(calendar);
        trigger.triggered(calendar);
        entity.setState(TriggerEntity.State.WAITING);
        this.triggerEntityAdapter.editEntity(db, (Entity)entity);
        trigger = (OperableTrigger)entity.getValue();
        JobDetailEntity jobDetailEntity = this.jobDetailEntityAdapter.readByKey(db, trigger.getJobKey());
        Preconditions.checkState((jobDetailEntity != null ? 1 : 0) != 0, (String)"Missing job-detail for trigger-key: %s", (Object)triggerKey);
        JobDetail jobDetail = (JobDetail)jobDetailEntity.getValue();
        if (jobDetail.isConcurrentExectionDisallowed()) {
            this.blockTriggers(db, triggerKey, jobDetail);
        }
        jobDetail.getJobDataMap().clearDirtyFlag();
        return new TriggerFiredBundle(jobDetail, trigger, calendar, false, new Date(), trigger.getPreviousFireTime(), prevFireTime, trigger.getNextFireTime());
    }

    private void blockTriggers(ODatabaseDocumentTx db, TriggerKey firedTriggerKey, JobDetail jobDetail) {
        JobKey jobKey = jobDetail.getKey();
        this.log.trace("Blocking other triggers: firedTriggerKey={}, jobKey={}", (Object)firedTriggerKey, (Object)jobKey);
        Iterable<TriggerEntity> matches = this.triggerEntityAdapter.browseWithPredicate(db, input -> {
            switch (input.getState()) {
                case WAITING: 
                case PAUSED: {
                    return jobKey.equals((Object)((OperableTrigger)input.getValue()).getJobKey());
                }
            }
            return false;
        });
        if (this.isMultiNodeTask(jobDetail)) {
            matches = this.local(matches);
        }
        for (TriggerEntity entity : matches) {
            if (entity.getState() == TriggerEntity.State.PAUSED) {
                entity.setState(TriggerEntity.State.PAUSED_BLOCKED);
            } else {
                entity.setState(TriggerEntity.State.BLOCKED);
            }
            this.triggerEntityAdapter.editEntity(db, (Entity)entity);
        }
    }

    public void triggeredJobComplete(OperableTrigger trigger, JobDetail jobDetail, Trigger.CompletedExecutionInstruction instruction) {
        this.log.debug("Triggered job complete: trigger={}, jobDetail={}, instruction={}", new Object[]{trigger, jobDetail, instruction});
        this.executeAndPropagate(db -> {
            TriggerEntity triggerEntity;
            JobDetailEntity jobDetailEntity;
            if (jobDetail.getJobDataMap().isDirty() && jobDetail.isPersistJobDataAfterExecution() && (jobDetailEntity = this.jobDetailEntityAdapter.readByKey(db, jobDetail.getKey())) != null) {
                jobDetailEntity.setValue(jobDetail);
                this.jobDetailEntityAdapter.editEntity(db, (Entity)jobDetailEntity);
            }
            if (jobDetail.isConcurrentExectionDisallowed()) {
                this.unblockTriggers(db, jobDetail);
                this.signaler.signalSchedulingChange(0L);
            }
            if ((triggerEntity = this.triggerEntityAdapter.readByKey(db, trigger.getKey())) != null) {
                switch (instruction) {
                    case DELETE_TRIGGER: {
                        if (trigger.getNextFireTime() == null) {
                            if (((OperableTrigger)triggerEntity.getValue()).getNextFireTime() != null) break;
                            this.triggerEntityAdapter.deleteEntity(db, (Entity)triggerEntity);
                            break;
                        }
                        this.triggerEntityAdapter.deleteEntity(db, (Entity)triggerEntity);
                        this.signaler.signalSchedulingChange(0L);
                        break;
                    }
                    case SET_TRIGGER_COMPLETE: {
                        triggerEntity.setState(TriggerEntity.State.COMPLETE);
                        this.triggerEntityAdapter.editEntity(db, (Entity)triggerEntity);
                        this.signaler.signalSchedulingChange(0L);
                        break;
                    }
                    case SET_TRIGGER_ERROR: {
                        triggerEntity.setState(TriggerEntity.State.ERROR);
                        this.triggerEntityAdapter.editEntity(db, (Entity)triggerEntity);
                        this.signaler.signalSchedulingChange(0L);
                        break;
                    }
                    case SET_ALL_JOB_TRIGGERS_COMPLETE: {
                        this.updateTriggerState(db, jobDetail.getKey(), TriggerEntity.State.COMPLETE);
                        this.signaler.signalSchedulingChange(0L);
                        break;
                    }
                    case SET_ALL_JOB_TRIGGERS_ERROR: {
                        this.updateTriggerState(db, jobDetail.getKey(), TriggerEntity.State.ERROR);
                        this.signaler.signalSchedulingChange(0L);
                    }
                }
            }
            return null;
        });
    }

    private void unblockTriggers(ODatabaseDocumentTx db, JobDetail jobDetail) {
        JobKey jobKey = jobDetail.getKey();
        this.log.trace("Unblock triggers: jobKey={}", (Object)jobKey);
        Iterable<TriggerEntity> matches = this.triggerEntityAdapter.browseWithPredicate(db, input -> {
            switch (input.getState()) {
                case BLOCKED: 
                case PAUSED_BLOCKED: {
                    return jobKey.equals((Object)((OperableTrigger)input.getValue()).getJobKey());
                }
            }
            return false;
        });
        if (this.isMultiNodeTask(jobDetail)) {
            matches = this.local(matches);
        }
        for (TriggerEntity entity : matches) {
            if (entity.getState() == TriggerEntity.State.PAUSED_BLOCKED) {
                entity.setState(TriggerEntity.State.PAUSED);
            } else {
                entity.setState(TriggerEntity.State.WAITING);
            }
            this.triggerEntityAdapter.editEntity(db, (Entity)entity);
        }
    }

    private void updateTriggerState(ODatabaseDocumentTx db, JobKey jobKey, TriggerEntity.State state) {
        this.log.trace("Updating job trigger states: jobKey={}, state={}", (Object)jobKey, (Object)state);
        Iterable<TriggerEntity> matches = this.triggerEntityAdapter.browseByJobKey(db, jobKey);
        for (TriggerEntity entity : matches) {
            entity.setState(state);
            this.triggerEntityAdapter.editEntity(db, (Entity)entity);
        }
    }

    private long getMisfireTime() {
        long misfireTime = System.currentTimeMillis();
        if (this.misfireThreshold > 0L) {
            misfireTime -= this.misfireThreshold;
        }
        return misfireTime > 0L ? misfireTime : 0L;
    }

    private boolean applyMisfire(ODatabaseDocumentTx db, TriggerEntity triggerEntity) {
        this.log.trace("Checking for misfire: {}", (Object)triggerEntity);
        OperableTrigger trigger = (OperableTrigger)triggerEntity.getValue();
        long misfireTime = this.getMisfireTime();
        Date nextFireTime = trigger.getNextFireTime();
        if (nextFireTime == null || nextFireTime.getTime() > misfireTime || trigger.getMisfireInstruction() == -1) {
            return false;
        }
        Calendar calendar = null;
        if (trigger.getCalendarName() != null) {
            calendar = this.findCalendar(db, trigger.getCalendarName());
        }
        this.signaler.notifyTriggerListenersMisfired((Trigger)trigger);
        trigger.updateAfterMisfire(calendar);
        if (trigger.getNextFireTime() == null) {
            triggerEntity.setState(TriggerEntity.State.COMPLETE);
            this.triggerEntityAdapter.editEntity(db, (Entity)triggerEntity);
            this.signaler.notifySchedulerListenersFinalized((Trigger)trigger);
        } else if (nextFireTime.equals(trigger.getNextFireTime())) {
            return false;
        }
        return true;
    }

    public void storeCalendar(String name, Calendar calendar, boolean replaceExisting, boolean updateTriggers) throws JobPersistenceException {
        this.log.debug("Store calendar: name={}, calendar={}, replaceExisting={}, updateTriggers={}", new Object[]{name, calendar, replaceExisting, updateTriggers});
        this.execute(db -> {
            CalendarEntity entity = this.calendarEntityAdapter.readByName(db, name);
            if (entity == null) {
                entity = new CalendarEntity(name, calendar);
                this.calendarEntityAdapter.addEntity(db, (Entity)entity);
            } else if (replaceExisting) {
                entity.setValue(calendar);
                this.calendarEntityAdapter.editEntity(db, (Entity)entity);
            }
            if (updateTriggers) {
                for (TriggerEntity triggerEntity : this.triggerEntityAdapter.browseByCalendarName(db, name)) {
                    ((OperableTrigger)triggerEntity.getValue()).updateWithNewCalendar(calendar, this.misfireThreshold);
                    this.triggerEntityAdapter.editEntity(db, (Entity)triggerEntity);
                }
            }
            return null;
        });
    }

    public boolean removeCalendar(String name) throws JobPersistenceException {
        this.log.debug("Remove calendar: {}", (Object)name);
        return this.execute(db -> this.calendarEntityAdapter.deleteByName(db, name));
    }

    @Nullable
    public Calendar retrieveCalendar(String name) throws JobPersistenceException {
        return this.execute(db -> {
            CalendarEntity entity = this.calendarEntityAdapter.readByName(db, name);
            return entity != null ? (Calendar)entity.getValue() : null;
        });
    }

    public int getNumberOfCalendars() throws JobPersistenceException {
        return this.execute(db -> this.calendarEntityAdapter.countI(db));
    }

    public List<String> getCalendarNames() throws JobPersistenceException {
        return this.execute(db -> this.calendarEntityAdapter.browseNames(db));
    }

    @Nullable
    private Calendar findCalendar(ODatabaseDocumentTx db, String name) {
        CalendarEntity calendarEntity = this.calendarEntityAdapter.readByName(db, name);
        if (calendarEntity != null) {
            return (Calendar)calendarEntity.getValue();
        }
        return null;
    }

    private Iterable<TriggerEntity> local(Iterable<TriggerEntity> triggers) {
        if (this.isClustered()) {
            return Iterables.filter(triggers, entity -> this.isLocal((TriggerEntity)((Object)entity)) || this.isOrphaned((TriggerEntity)((Object)entity)));
        }
        return triggers;
    }

    private boolean canBeAcquired(TriggerEntity entity, ODatabaseDocumentTx db, long timeWindowStart, long timeWindowEnd) {
        OperableTrigger trigger = (OperableTrigger)entity.getValue();
        if (trigger.getNextFireTime() == null) {
            return false;
        }
        if (this.applyMisfire(db, entity) && trigger.getNextFireTime() == null) {
            return false;
        }
        if (trigger.getNextFireTime().getTime() > timeWindowEnd) {
            return false;
        }
        if (trigger.getMisfireInstruction() != -1 && trigger.getNextFireTime().getTime() < timeWindowStart) {
            return false;
        }
        return !this.isClustered() || !this.isLimitedToMissingNode(entity);
    }

    private boolean isLocal(TriggerEntity entity) {
        if (this.isClustered()) {
            String localId = this.nodeAccess.getId();
            JobDataMap triggerDetail = ((OperableTrigger)entity.getValue()).getJobDataMap();
            if (triggerDetail.containsKey((Object)"limitnode")) {
                String limitedNodeId = triggerDetail.getString("limitnode");
                return localId.equals(limitedNodeId);
            }
            String owner = triggerDetail.getString(NODE_ID);
            return localId.equals(owner);
        }
        return true;
    }

    private boolean isOrphaned(TriggerEntity entity) {
        if (this.isClustered()) {
            Set memberIds = this.nodeAccess.getMemberIds();
            JobDataMap triggerDetail = ((OperableTrigger)entity.getValue()).getJobDataMap();
            String limitedNodeId = triggerDetail.getString("limitnode");
            String owner = triggerDetail.getString(NODE_ID);
            return limitedNodeId != null ? !memberIds.contains(limitedNodeId) : !memberIds.contains(owner);
        }
        return false;
    }

    private boolean isLimitedToMissingNode(TriggerEntity entity) {
        OperableTrigger trigger = (OperableTrigger)entity.getValue();
        JobDataMap triggerDetail = trigger.getJobDataMap();
        if (triggerDetail.containsKey((Object)"limitnode")) {
            String limitedNodeId = triggerDetail.getString("limitnode");
            if (!this.nodeAccess.getId().equals(limitedNodeId)) {
                String description = trigger.getDescription();
                if (Strings2.isBlank((String)description)) {
                    description = trigger.getJobKey().getName();
                }
                if (Strings2.isBlank((String)limitedNodeId)) {
                    this.log.warn("Cannot run task '{}' because it is not configured for HA", (Object)description);
                } else {
                    this.log.warn("Cannot run task '{}' because it uses node {} which is not a member of this cluster", (Object)description, (Object)limitedNodeId);
                }
                return true;
            }
        }
        return false;
    }

    private boolean isMultiNodeTask(JobDetail jobDetail) {
        return jobDetail.getJobDataMap().getBoolean("multinode");
    }

    private static interface Operation<T> {
        @Nullable
        public T execute(ODatabaseDocumentTx var1) throws JobPersistenceException;
    }
}

