/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.quartz.internal.orient;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.util.List;
import javax.annotation.Nullable;
import org.quartz.utils.Key;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.orient.entity.EntityAdapter;

public class ReadEntityByKeyAction<EntityT extends Entity>
extends ComponentSupport {
    private final EntityAdapter<EntityT> adapter;
    private final String query;

    public ReadEntityByKeyAction(EntityAdapter<EntityT> adapter, String namePropery, String groupProperty) {
        this.adapter = (EntityAdapter)Preconditions.checkNotNull(adapter);
        Preconditions.checkNotNull((Object)namePropery);
        Preconditions.checkNotNull((Object)groupProperty);
        this.query = String.format("SELECT FROM %s WHERE %s = ? AND %s = ?", adapter.getTypeName(), namePropery, groupProperty);
    }

    @Nullable
    public EntityT execute(ODatabaseDocumentTx db, Key key) {
        Preconditions.checkNotNull((Object)db);
        Preconditions.checkNotNull((Object)key);
        List results = (List)db.command((OCommandRequest)new OSQLSynchQuery(this.query)).execute(new Object[]{key.getName(), key.getGroup()});
        if (results.isEmpty()) {
            return null;
        }
        return (EntityT)this.adapter.readEntity((ODocument)results.get(0));
    }

    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "{" + "query='" + this.query + '\'' + '}';
    }
}

