/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.quartz.internal.orient;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.quartz.JobKey;
import org.quartz.TriggerKey;
import org.quartz.spi.OperableTrigger;
import org.sonatype.nexus.quartz.internal.orient.MarshalledEntity;

public class TriggerEntity
extends MarshalledEntity<OperableTrigger> {
    private String name;
    @Nullable
    private String group;
    private String jobName;
    @Nullable
    private String jobGroup;
    @Nullable
    private String calendarName;
    private State state;

    public TriggerEntity() {
    }

    public TriggerEntity(OperableTrigger value, State state) {
        this.setValue(value);
        this.setState(state);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Nullable
    public String getGroup() {
        return this.group;
    }

    public void setGroup(@Nullable String group) {
        this.group = group;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    @Nullable
    public String getJobGroup() {
        return this.jobGroup;
    }

    public void setJobGroup(@Nullable String jobGroup) {
        this.jobGroup = jobGroup;
    }

    @Nullable
    public String getCalendarName() {
        return this.calendarName;
    }

    public void setCalendarName(@Nullable String calendarName) {
        this.calendarName = calendarName;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    @Override
    public void setValue(OperableTrigger value) {
        super.setValue(value);
        TriggerKey key = value.getKey();
        Preconditions.checkState((key != null ? 1 : 0) != 0, (Object)"Missing key");
        this.setName(key.getName());
        this.setGroup(key.getGroup());
        JobKey jobKey = value.getJobKey();
        Preconditions.checkState((jobKey != null ? 1 : 0) != 0, (Object)"Missing job-key");
        this.setJobName(jobKey.getName());
        this.setJobGroup(jobKey.getGroup());
        this.setCalendarName(value.getCalendarName());
    }

    @Override
    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "{" + "name='" + this.name + '\'' + ", group='" + this.group + '\'' + ", jobName='" + this.jobName + '\'' + ", jobGroup='" + this.jobGroup + '\'' + ", calendarName='" + this.calendarName + '\'' + ", state=" + (Object)((Object)this.state) + ", value=" + this.getValue() + '}';
    }

    public static enum State {
        WAITING,
        ACQUIRED,
        COMPLETE,
        PAUSED,
        BLOCKED,
        PAUSED_BLOCKED,
        ERROR;

    }
}

