/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.quartz.internal.orient;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.inject.Singleton;
import org.quartz.CronExpression;
import org.quartz.JobKey;
import org.quartz.TriggerKey;
import org.quartz.spi.OperableTrigger;
import org.quartz.utils.Key;
import org.sonatype.nexus.common.entity.EntityEvent;
import org.sonatype.nexus.common.entity.EntityMetadata;
import org.sonatype.nexus.orient.OClassNameBuilder;
import org.sonatype.nexus.orient.OIndexNameBuilder;
import org.sonatype.nexus.orient.entity.AttachedEntityMetadata;
import org.sonatype.nexus.orient.entity.EntityAdapter;
import org.sonatype.nexus.orient.entity.IterableEntityAdapter;
import org.sonatype.nexus.orient.entity.action.BrowseEntitiesByPropertyAction;
import org.sonatype.nexus.orient.entity.action.BrowseEntitiesByPropertyInSetAction;
import org.sonatype.nexus.orient.entity.action.BrowseEntitiesWithPredicateAction;
import org.sonatype.nexus.orient.entity.action.DeleteEntitiesAction;
import org.sonatype.nexus.orient.entity.action.DeleteEntityByPropertyAction;
import org.sonatype.nexus.quartz.internal.orient.CronExpressionMixin;
import org.sonatype.nexus.quartz.internal.orient.DeleteEntityByKeyAction;
import org.sonatype.nexus.quartz.internal.orient.ExistsByKeyAction;
import org.sonatype.nexus.quartz.internal.orient.FieldObjectMapper;
import org.sonatype.nexus.quartz.internal.orient.JacksonMarshaller;
import org.sonatype.nexus.quartz.internal.orient.MarshalledEntityAdapter;
import org.sonatype.nexus.quartz.internal.orient.Marshaller;
import org.sonatype.nexus.quartz.internal.orient.ReadEntityByKeyAction;
import org.sonatype.nexus.quartz.internal.orient.TriggerCreatedEvent;
import org.sonatype.nexus.quartz.internal.orient.TriggerDeletedEvent;
import org.sonatype.nexus.quartz.internal.orient.TriggerEntity;
import org.sonatype.nexus.quartz.internal.orient.TriggerUpdatedEvent;

@Named
@Singleton
public class TriggerEntityAdapter
extends MarshalledEntityAdapter<TriggerEntity> {
    private static final String DB_CLASS = new OClassNameBuilder().prefix("quartz").type("trigger").build();
    private static final String P_NAME = "name";
    private static final String P_GROUP = "group";
    private static final String P_JOB_NAME = "job_name";
    private static final String P_JOB_GROUP = "job_group";
    private static final String P_CALENDAR_NAME = "calendar_name";
    private static final String P_STATE = "state";
    private static final String I_NAME_GROUP = new OIndexNameBuilder().type(DB_CLASS).property("name").property("group").build();
    private static final String I_JOB_NAME_JOB_GROUP = new OIndexNameBuilder().type(DB_CLASS).property("job_name").property("job_group").build();
    private static final String I_CALENDAR_NAME = new OIndexNameBuilder().type(DB_CLASS).property("calendar_name").build();
    private static final String I_STATE = new OIndexNameBuilder().type(DB_CLASS).property("state").build();
    private final ReadEntityByKeyAction<TriggerEntity> readByKey = new ReadEntityByKeyAction(this, "name", "group");
    private final ExistsByKeyAction existsByKey = new ExistsByKeyAction((EntityAdapter<?>)this, "name", "group");
    public final BrowseEntitiesByPropertyAction<TriggerEntity> browseByState = new BrowseEntitiesByPropertyAction((IterableEntityAdapter)this, new String[]{"state"});
    public final BrowseEntitiesByPropertyInSetAction<TriggerEntity> browseByStates = new BrowseEntitiesByPropertyInSetAction((IterableEntityAdapter)this, "state");
    private final BrowseEntitiesByPropertyAction<TriggerEntity> browseByGroup = new BrowseEntitiesByPropertyAction((IterableEntityAdapter)this, new String[]{"group"});
    private final BrowseEntitiesByPropertyAction<TriggerEntity> browseByCalendarName = new BrowseEntitiesByPropertyAction((IterableEntityAdapter)this, new String[]{"calendar_name"});
    private final BrowseEntitiesWithPredicateAction<TriggerEntity> browseWithPredicate = new BrowseEntitiesWithPredicateAction((IterableEntityAdapter)this);
    private final DeleteEntityByKeyAction deleteByKey = new DeleteEntityByKeyAction((EntityAdapter<?>)this, "name", "group");
    private final DeleteEntitiesAction deleteAll = new DeleteEntitiesAction((EntityAdapter)this);
    private final DeleteEntityByPropertyAction deleteByJobKey = new DeleteEntityByPropertyAction((EntityAdapter)this, new String[]{"job_name", "job_group"});
    private static final String BROWSE_BY_JOB_KEY_QUERY = String.format("SELECT FROM %s WHERE %s = ? AND %s = ?", DB_CLASS, "job_name", "job_group");

    public TriggerEntityAdapter() {
        super(DB_CLASS, TriggerEntityAdapter.createMarshaller(), OperableTrigger.class.getClassLoader());
    }

    private static Marshaller createMarshaller() {
        return new JacksonMarshaller(new FieldObjectMapper().addMixIn(CronExpression.class, CronExpressionMixin.class));
    }

    @Override
    protected void defineType(OClass type) {
        super.defineType(type);
        type.createProperty(P_NAME, OType.STRING).setMandatory(true).setNotNull(true);
        type.createProperty(P_GROUP, OType.STRING).setMandatory(true).setNotNull(false);
        type.createProperty(P_JOB_NAME, OType.STRING).setMandatory(true).setNotNull(true);
        type.createProperty(P_JOB_GROUP, OType.STRING).setMandatory(true).setNotNull(false);
        type.createProperty(P_CALENDAR_NAME, OType.STRING).setMandatory(true).setNotNull(false);
        type.createProperty(P_STATE, OType.STRING).setMandatory(true).setNotNull(true);
        type.createIndex(I_NAME_GROUP, OClass.INDEX_TYPE.UNIQUE, new String[]{P_NAME, P_GROUP});
        type.createIndex(I_JOB_NAME_JOB_GROUP, OClass.INDEX_TYPE.NOTUNIQUE, new String[]{P_JOB_NAME, P_JOB_GROUP});
        type.createIndex(I_CALENDAR_NAME, OClass.INDEX_TYPE.NOTUNIQUE, new String[]{P_CALENDAR_NAME});
        type.createIndex(I_STATE, OClass.INDEX_TYPE.NOTUNIQUE, new String[]{P_STATE});
    }

    protected TriggerEntity newEntity() {
        return new TriggerEntity();
    }

    protected void readFields(ODocument document, TriggerEntity entity) throws Exception {
        super.readFields(document, entity);
        entity.setName((String)document.field(P_NAME));
        entity.setGroup((String)document.field(P_GROUP));
        entity.setJobName((String)document.field(P_JOB_NAME));
        entity.setJobGroup((String)document.field(P_JOB_GROUP));
        entity.setCalendarName((String)document.field(P_CALENDAR_NAME));
        entity.setState(TriggerEntity.State.valueOf((String)document.field(P_STATE)));
    }

    protected void writeFields(ODocument document, TriggerEntity entity) throws Exception {
        super.writeFields(document, entity);
        document.field(P_NAME, (Object)entity.getName());
        document.field(P_GROUP, (Object)entity.getGroup());
        document.field(P_JOB_NAME, (Object)entity.getJobName());
        document.field(P_JOB_GROUP, (Object)entity.getJobGroup());
        document.field(P_CALENDAR_NAME, (Object)entity.getCalendarName());
        document.field(P_STATE, (Object)entity.getState().name());
    }

    @Nullable
    public TriggerEntity readByKey(ODatabaseDocumentTx db, TriggerKey key) {
        return this.readByKey.execute(db, (Key)key);
    }

    public boolean existsByKey(ODatabaseDocumentTx db, TriggerKey key) {
        return this.existsByKey.execute(db, (Key)key);
    }

    public Iterable<TriggerEntity> browseByState(ODatabaseDocumentTx db, Object state) {
        return this.browseByState.execute(db, new Object[]{state});
    }

    public Iterable<TriggerEntity> browseByStates(ODatabaseDocumentTx db, Collection<? extends Object> states) {
        return this.browseByStates.execute(db, states);
    }

    public Iterable<TriggerEntity> browseByGroup(ODatabaseDocumentTx db, Object group) {
        return this.browseByGroup.execute(db, new Object[]{group});
    }

    public Iterable<TriggerEntity> browseByCalendarName(ODatabaseDocumentTx db, Object calendarName) {
        return this.browseByCalendarName.execute(db, new Object[]{calendarName});
    }

    public Iterable<TriggerEntity> browseWithPredicate(ODatabaseDocumentTx db, Predicate<TriggerEntity> predicate) {
        return this.browseWithPredicate.execute(db, predicate);
    }

    public boolean deleteByKey(ODatabaseDocumentTx db, TriggerKey key) {
        return this.deleteByKey.execute(db, (Key)key);
    }

    public void deleteAll(ODatabaseDocumentTx db) {
        this.deleteAll.execute(db);
    }

    public Iterable<TriggerEntity> browseByJobKey(ODatabaseDocumentTx db, JobKey jobKey) {
        Preconditions.checkNotNull((Object)db);
        Preconditions.checkNotNull((Object)jobKey);
        List results = (List)db.command((OCommandRequest)new OSQLSynchQuery(BROWSE_BY_JOB_KEY_QUERY)).execute(new Object[]{jobKey.getName(), jobKey.getGroup()});
        return this.transform(results);
    }

    public void deleteByJobKey(ODatabaseDocumentTx db, JobKey jobKey) {
        this.deleteByJobKey.execute(db, new Object[]{jobKey.getName(), jobKey.getGroup()});
    }

    public boolean sendEvents() {
        return true;
    }

    public EntityEvent newEvent(ODocument document, EntityAdapter.EventKind eventKind) {
        AttachedEntityMetadata metadata = new AttachedEntityMetadata((EntityAdapter)this, document);
        switch (eventKind) {
            case CREATE: {
                return new TriggerCreatedEvent((EntityMetadata)metadata);
            }
            case UPDATE: {
                return new TriggerUpdatedEvent((EntityMetadata)metadata);
            }
            case DELETE: {
                return new TriggerDeletedEvent((EntityMetadata)metadata);
            }
        }
        return null;
    }
}

