/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.quartz.internal.task;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.util.Date;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import org.quartz.JobKey;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.quartz.internal.QuartzSchedulerSPI;
import org.sonatype.nexus.scheduling.TaskInfo;
import org.sonatype.nexus.scheduling.schedule.Schedule;

public class QuartzTaskFuture
extends ComponentSupport
implements Future<Object> {
    static final String FUTURE_KEY = QuartzTaskFuture.class.getName();
    private final QuartzSchedulerSPI scheduler;
    private final JobKey jobKey;
    private final String taskLogName;
    private final Date startedAt;
    private final Schedule startedBy;
    private final String triggerSource;
    private final CountDownLatch countDownLatch;
    private volatile Thread jobExecutingThread;
    private volatile TaskInfo.RunState runState;
    private Exception exception;
    private Object result;

    public QuartzTaskFuture(QuartzSchedulerSPI scheduler, JobKey jobKey, String taskLogName, Date startedAt, Schedule startedBy, @Nullable String triggerSource) {
        this.scheduler = (QuartzSchedulerSPI)((Object)Preconditions.checkNotNull((Object)((Object)scheduler)));
        this.jobKey = (JobKey)Preconditions.checkNotNull((Object)jobKey);
        this.taskLogName = (String)Preconditions.checkNotNull((Object)taskLogName);
        this.startedAt = (Date)Preconditions.checkNotNull((Object)startedAt);
        this.startedBy = (Schedule)Preconditions.checkNotNull((Object)startedBy);
        this.triggerSource = triggerSource;
        this.countDownLatch = new CountDownLatch(1);
        this.runState = TaskInfo.RunState.STARTING;
    }

    public void setJobExecutingThread(Thread thread) {
        this.jobExecutingThread = (Thread)Preconditions.checkNotNull((Object)thread);
    }

    public void setResult(Object result, Exception exception) {
        this.result = result;
        this.exception = exception;
        this.jobExecutingThread = null;
        this.countDownLatch.countDown();
    }

    public Date getStartedAt() {
        return this.startedAt;
    }

    public Schedule getStartedBy() {
        return this.startedBy;
    }

    public TaskInfo.RunState getRunState() {
        return this.runState;
    }

    public void setRunState(TaskInfo.RunState runState) {
        Preconditions.checkState((this.runState.ordinal() <= runState.ordinal() ? 1 : 0) != 0, (String)"Illegal run state transition: %s -> %s", (Object)this.runState, (Object)runState);
        this.log.debug("Task {} : {} runState transition {} -> {}", new Object[]{this.jobKey.getName(), this.taskLogName, this.runState, runState});
        this.runState = runState;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        boolean canceled = this.scheduler.cancelJob(this.jobKey);
        Thread thread = this.jobExecutingThread;
        if (!canceled && thread != null && mayInterruptIfRunning) {
            if (this.log.isDebugEnabled()) {
                this.log.info("Task cancelling w/ interruption {} : {}", (Object)this.jobKey.getName(), (Object)this.taskLogName);
            } else {
                this.log.info("Task cancelling w/ interruption {}", (Object)this.taskLogName);
            }
            thread.interrupt();
            canceled = true;
        }
        if (canceled || this.runState == TaskInfo.RunState.STARTING) {
            this.doCancel();
        }
        return canceled;
    }

    public void doCancel() {
        this.setRunState(TaskInfo.RunState.CANCELED);
        this.setResult(null, new CancellationException("Task canceled"));
        if (this.log.isDebugEnabled()) {
            this.log.info("Task canceled {} : {}", (Object)this.jobKey.getName(), (Object)this.taskLogName);
        } else {
            this.log.info("Task canceled {}", (Object)this.taskLogName);
        }
    }

    @Override
    public boolean isCancelled() {
        return this.runState == TaskInfo.RunState.CANCELED;
    }

    @Override
    public boolean isDone() {
        return this.countDownLatch.getCount() == 0L;
    }

    @Nullable
    public String getTriggerSource() {
        return this.triggerSource;
    }

    private void maybePropagateException() throws InterruptedException, ExecutionException {
        if (this.exception != null) {
            Throwables.throwIfUnchecked((Throwable)this.exception);
            Throwables.throwIfInstanceOf((Throwable)this.exception, InterruptedException.class);
            Throwables.throwIfInstanceOf((Throwable)this.exception, ExecutionException.class);
            throw new ExecutionException("Job failure", this.exception);
        }
    }

    @Override
    public Object get() throws InterruptedException, ExecutionException {
        this.countDownLatch.await();
        this.maybePropagateException();
        return this.result;
    }

    @Override
    public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.countDownLatch.await(timeout, unit);
        this.maybePropagateException();
        return this.result;
    }
}

