/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.quartz.internal.task;

import com.google.common.base.Preconditions;
import java.util.Date;
import javax.annotation.Nullable;
import org.quartz.JobKey;
import org.quartz.SchedulerException;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.quartz.internal.QuartzSchedulerSPI;
import org.sonatype.nexus.quartz.internal.task.QuartzTaskFuture;
import org.sonatype.nexus.quartz.internal.task.QuartzTaskState;
import org.sonatype.nexus.scheduling.TaskConfiguration;
import org.sonatype.nexus.scheduling.TaskInfo;
import org.sonatype.nexus.scheduling.TaskRemovedException;
import org.sonatype.nexus.scheduling.events.TaskDeletedEvent;
import org.sonatype.nexus.scheduling.schedule.Manual;
import org.sonatype.nexus.scheduling.schedule.Schedule;

public class QuartzTaskInfo
extends ComponentSupport
implements TaskInfo {
    static final String TASK_INFO_KEY = QuartzTaskInfo.class.getName();
    private final EventManager eventManager;
    private final QuartzSchedulerSPI scheduler;
    private final JobKey jobKey;
    private volatile TaskInfo.State state;
    private volatile QuartzTaskState taskState;
    private volatile QuartzTaskFuture taskFuture;
    private volatile boolean removed;

    public QuartzTaskInfo(EventManager eventManager, QuartzSchedulerSPI scheduler, JobKey jobKey, QuartzTaskState taskState, @Nullable QuartzTaskFuture taskFuture) {
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
        this.scheduler = (QuartzSchedulerSPI)((Object)Preconditions.checkNotNull((Object)((Object)scheduler)));
        this.jobKey = (JobKey)Preconditions.checkNotNull((Object)jobKey);
        this.removed = false;
        this.setNexusTaskState(taskFuture != null ? TaskInfo.State.RUNNING : TaskInfo.State.WAITING, taskState, taskFuture);
    }

    public synchronized boolean isRemovedOrDone() {
        return this.removed || TaskInfo.State.DONE == this.state;
    }

    public synchronized void setNexusTaskState(TaskInfo.State state, QuartzTaskState taskState, @Nullable QuartzTaskFuture taskFuture) {
        Preconditions.checkNotNull((Object)state);
        Preconditions.checkNotNull((Object)taskState);
        Preconditions.checkState((TaskInfo.State.RUNNING != state || taskFuture != null ? 1 : 0) != 0, (Object)"Running task must have future");
        TaskConfiguration config = taskState.getConfiguration();
        if (this.state == null) {
            this.log.info("Task {} : state={}", (Object)config.getTaskLogName(), (Object)state);
        } else if (this.state != state) {
            String newState = state.name();
            if (state != TaskInfo.State.RUNNING && taskState.getLastRunState() != null) {
                newState = String.valueOf(newState) + " (" + taskState.getLastRunState().getEndState().name() + ")";
            }
            if (this.log.isDebugEnabled()) {
                this.log.info("Task {} : {} state change {} -> {}", new Object[]{this.jobKey, config.getTaskLogName(), this.state, newState});
            } else {
                this.log.info("Task {} state change {} -> {}", new Object[]{config.getTaskLogName(), this.state, newState});
            }
        } else {
            this.log.debug("Task {} : {} : state={} nextRun={}", new Object[]{this.jobKey.getName(), config.getTaskLogName(), state, taskState.getNextExecutionTime()});
        }
        this.state = state;
        this.taskState = taskState;
        this.taskFuture = taskFuture;
        if (!this.removed && state == TaskInfo.State.DONE) {
            this.scheduler.removeTask(this.jobKey);
            this.removed = true;
            this.log.debug("Task {} : {} is done and removed", (Object)this.jobKey.getName(), (Object)config.getTaskLogName());
        }
    }

    public synchronized void setNexusTaskStateIfInState(TaskInfo.State state, QuartzTaskState taskState, @Nullable QuartzTaskFuture taskFuture) {
        if (this.state == state) {
            this.setNexusTaskState(state, taskState, taskFuture);
        }
    }

    public JobKey getJobKey() {
        return this.jobKey;
    }

    @Nullable
    public QuartzTaskFuture getTaskFuture() {
        return this.taskFuture;
    }

    public String getId() {
        return this.getConfiguration().getId();
    }

    public String getName() {
        return this.getConfiguration().getName();
    }

    public String getTypeId() {
        return this.getConfiguration().getTypeId();
    }

    public String getMessage() {
        return this.getConfiguration().getMessage();
    }

    public synchronized TaskConfiguration getConfiguration() {
        return this.taskState.getConfiguration();
    }

    public synchronized Schedule getSchedule() {
        return this.taskState.getSchedule();
    }

    public synchronized TaskInfo.CurrentState getCurrentState() {
        if (this.taskState.getSchedule() instanceof Manual) {
            return new CurrentStateImpl(this.state, null, this.taskFuture);
        }
        return new CurrentStateImpl(this.state, this.taskState.getNextExecutionTime(), this.taskFuture);
    }

    @Nullable
    public synchronized TaskInfo.LastRunState getLastRunState() {
        return this.taskState.getLastRunState();
    }

    public synchronized boolean remove() {
        TaskConfiguration config = this.taskState.getConfiguration();
        if (this.isRemovedOrDone()) {
            this.log.debug("Task {} : {} already removed", (Object)this.jobKey.getName(), (Object)config.getTaskLogName());
            return true;
        }
        if (this.taskFuture != null && !this.taskFuture.cancel(false)) {
            this.log.debug("Task {} : {} is running as is not cancelable", (Object)this.jobKey.getName(), (Object)config.getTaskLogName());
            return false;
        }
        if (!QuartzTaskState.hasLastRunState(config)) {
            QuartzTaskState.setLastRunState(config, TaskInfo.EndState.CANCELED, new Date(), 0L);
        }
        this.removed = true;
        boolean result = this.scheduler.removeTask(this.jobKey);
        if (result) {
            this.log.info("Task {} removed", (Object)config.getTaskLogName());
            this.eventManager.post((Object)new TaskDeletedEvent((TaskInfo)this));
        } else {
            this.log.warn("Task {} vanished", (Object)config.getTaskLogName());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskInfo runNow(String triggerSource) throws TaskRemovedException {
        QuartzTaskInfo quartzTaskInfo = this;
        synchronized (quartzTaskInfo) {
            Preconditions.checkState((TaskInfo.State.RUNNING != this.state ? 1 : 0) != 0, (Object)"Task already running");
            if (!this.getConfiguration().isEnabled()) {
                this.log.warn("Task {} is disabled and will not be run", (Object)this.taskState.getConfiguration().getTaskLogName());
                return this;
            }
            if (this.isRemovedOrDone()) {
                throw new TaskRemovedException("Task removed: " + this.jobKey);
            }
        }
        try {
            this.log.info("Task {} runNow", (Object)this.taskState.getConfiguration().getTaskLogName());
            this.scheduler.runNow(triggerSource, this.jobKey, this, this.taskState);
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public String getTriggerSource() {
        QuartzTaskFuture currentTaskFuture = this.taskFuture;
        return currentTaskFuture != null ? currentTaskFuture.getTriggerSource() : null;
    }

    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "{" + "jobKey=" + this.jobKey + ", state=" + this.state + ", taskState=" + this.taskState + ", taskFuture=" + this.taskFuture + ", removed=" + this.removed + '}';
    }

    private static class CurrentStateImpl
    implements TaskInfo.CurrentState {
        private final TaskInfo.State state;
        private final Date nextRun;
        private final QuartzTaskFuture future;

        public CurrentStateImpl(TaskInfo.State state, Date nextRun, QuartzTaskFuture taskFuture) {
            this.state = state;
            this.nextRun = nextRun;
            this.future = taskFuture;
        }

        public TaskInfo.State getState() {
            return this.state;
        }

        @Nullable
        public Date getNextRun() {
            return this.nextRun;
        }

        @Nullable
        public Date getRunStarted() {
            return this.state == TaskInfo.State.RUNNING ? this.future.getStartedAt() : null;
        }

        @Nullable
        public TaskInfo.RunState getRunState() {
            return this.state == TaskInfo.State.RUNNING ? this.future.getRunState() : null;
        }

        @Nullable
        public QuartzTaskFuture getFuture() {
            return this.future;
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + "{" + "state=" + this.state + ", nextRun=" + this.nextRun + ", future=" + this.future + '}';
        }
    }
}

