/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.quartz.internal.task;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.InterruptableJob;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.quartz.UnableToInterruptJobException;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.goodies.common.Mutex;
import org.sonatype.nexus.common.app.BaseUrlManager;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.quartz.internal.QuartzSchedulerSPI;
import org.sonatype.nexus.quartz.internal.task.QuartzTaskFuture;
import org.sonatype.nexus.quartz.internal.task.QuartzTaskInfo;
import org.sonatype.nexus.scheduling.Cancelable;
import org.sonatype.nexus.scheduling.Task;
import org.sonatype.nexus.scheduling.TaskConfiguration;
import org.sonatype.nexus.scheduling.TaskFactory;
import org.sonatype.nexus.scheduling.TaskInfo;
import org.sonatype.nexus.scheduling.TaskInterruptedException;
import org.sonatype.nexus.scheduling.events.TaskBlockedEvent;
import org.sonatype.nexus.scheduling.events.TaskEventCanceled;
import org.sonatype.nexus.scheduling.events.TaskStartedRunningEvent;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
@Named
public class QuartzTaskJob
extends ComponentSupport
implements InterruptableJob {
    private static final Mutex MUTEX = new Mutex();
    private final EventManager eventManager;
    private final Provider<QuartzSchedulerSPI> scheduler;
    private final TaskFactory taskFactory;
    private final BaseUrlManager baseUrlManager;
    private JobExecutionContext context;
    private QuartzTaskInfo taskInfo;
    private QuartzTaskFuture taskFuture;
    private Task task;

    @Inject
    public QuartzTaskJob(EventManager eventManager, Provider<QuartzSchedulerSPI> scheduler, TaskFactory taskFactory, BaseUrlManager baseUrlManager) {
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
        this.scheduler = (Provider)Preconditions.checkNotNull(scheduler);
        this.taskFactory = (TaskFactory)Preconditions.checkNotNull((Object)taskFactory);
        this.baseUrlManager = (BaseUrlManager)Preconditions.checkNotNull((Object)baseUrlManager);
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        this.context = (JobExecutionContext)Preconditions.checkNotNull((Object)context);
        try {
            try {
                this.doExecute();
            }
            catch (Exception e) {
                Throwables.throwIfInstanceOf((Throwable)e, JobExecutionException.class);
                throw new JobExecutionException((Throwable)e);
            }
        }
        finally {
            this.context = null;
        }
    }

    private void doExecute() throws Exception {
        Exception failure;
        block12: {
            failure = null;
            try {
                this.taskInfo = (QuartzTaskInfo)((Object)this.context.get((Object)QuartzTaskInfo.TASK_INFO_KEY));
                Preconditions.checkState((this.taskInfo != null ? 1 : 0) != 0);
                this.taskFuture = (QuartzTaskFuture)this.context.get((Object)QuartzTaskFuture.FUTURE_KEY);
                Preconditions.checkState((this.taskFuture != null ? 1 : 0) != 0);
                this.taskFuture.setJobExecutingThread(Thread.currentThread());
                this.baseUrlManager.detectAndHoldUrl();
                TaskConfiguration config = QuartzTaskJob.configurationOf(this.context.getJobDetail());
                this.task = this.taskFactory.create(config);
                try {
                    if (this.taskFuture.isCancelled()) break block12;
                    this.mayBlock();
                    if (this.taskFuture.isCancelled()) break block12;
                    try {
                        this.context.setResult(this.task.call());
                    }
                    finally {
                        QuartzTaskJob.updateJobData(this.context.getJobDetail(), this.task.taskConfiguration());
                    }
                }
                catch (TaskInterruptedException e) {
                    this.log.info("Task {} : {} canceled, exception: {}", new Object[]{config.getId(), config.getTaskLogName(), e.getMessage(), this.log.isDebugEnabled() ? e : null});
                    QuartzTaskFuture future = this.taskInfo.getTaskFuture();
                    if (future != null && !future.isCancelled()) {
                        future.doCancel();
                        this.eventManager.post((Object)new TaskEventCanceled((TaskInfo)this.taskInfo));
                    }
                }
                catch (InterruptedException e) {
                    this.log.info("Task {} : {} interrupted, exception: {}", new Object[]{config.getId(), config.getTaskLogName(), e.getMessage(), this.log.isDebugEnabled() ? e : null});
                    QuartzTaskFuture future = this.taskInfo.getTaskFuture();
                    if (future != null) {
                        future.doCancel();
                        this.eventManager.post((Object)new TaskEventCanceled((TaskInfo)this.taskInfo));
                    }
                }
                catch (Exception e) {
                    this.log.warn("Task {} : {} execution failure", new Object[]{config.getId(), config.getTaskLogName(), e});
                    failure = e;
                }
            }
            catch (Exception e) {
                this.log.warn("Task {} instantiation failure", (Object)this.context.getJobDetail().getKey(), (Object)e);
                failure = e;
            }
        }
        if (failure != null) {
            throw failure;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void mayBlock() throws Exception {
        block8: while (true) {
            List<TaskInfo> blockedBy;
            Mutex mutex = MUTEX;
            synchronized (mutex) {
                blockedBy = this.blockedBy();
                if (blockedBy.isEmpty()) {
                    this.log.trace("No blockers for task: {}", (Object)this.task);
                    this.markTaskAsRunning();
                    return;
                }
                TaskInfo.RunState previousRunState = this.taskFuture.getRunState();
                this.taskFuture.setRunState(TaskInfo.RunState.BLOCKED);
                if (TaskInfo.RunState.BLOCKED != previousRunState) {
                    this.eventManager.post((Object)new TaskBlockedEvent((TaskInfo)this.taskInfo));
                }
            }
            this.log.trace("Task: {} is blocked by: {}", (Object)this.task, blockedBy);
            Iterator<TaskInfo> iterator = blockedBy.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block8;
                TaskInfo taskInfo = iterator.next();
                try {
                    Future future = taskInfo.getCurrentState().getFuture();
                    if (future != null) {
                        future.get(1L, TimeUnit.MINUTES);
                    }
                    if (!this.taskFuture.isCancelled()) continue;
                    return;
                }
                catch (TimeoutException e) {
                    this.log.trace("Wait for unblock expired", (Throwable)e);
                    throw new TaskInterruptedException("Blocked for too long, giving up", true);
                }
                catch (Exception e) {
                    this.log.trace("Blocked task failed; ignoring", (Throwable)e);
                }
            }
            break;
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
    }

    private void markTaskAsRunning() throws Exception {
        this.log.trace("Task {} will be marked as running if it is not canceled", (Object)this.task);
        if (!this.taskFuture.isCancelled()) {
            this.log.trace("Task {} is not canceled, marking as running.", (Object)this.task);
            this.taskFuture.setRunState(TaskInfo.RunState.RUNNING);
            this.eventManager.post((Object)new TaskStartedRunningEvent((TaskInfo)this.taskInfo));
        }
    }

    private List<TaskInfo> blockedBy() {
        return ((QuartzSchedulerSPI)((Object)this.scheduler.get())).listsTasks().stream().filter(t -> !this.task.getId().equals(t.getId()) && this.task.taskConfiguration().getTypeId().equals(t.getConfiguration().getTypeId()) && TaskInfo.State.RUNNING == t.getCurrentState().getState() && this.notStartingOrBlocked(t.getCurrentState().getRunState())).collect(Collectors.toList());
    }

    private boolean notStartingOrBlocked(TaskInfo.RunState runState) {
        return TaskInfo.RunState.STARTING != runState && TaskInfo.RunState.BLOCKED != runState;
    }

    public void interrupt() throws UnableToInterruptJobException {
        if (this.task instanceof Cancelable && !((Cancelable)this.task).isCanceled()) {
            ((Cancelable)this.task).cancel();
            this.eventManager.post((Object)new TaskEventCanceled((TaskInfo)this.taskInfo));
        } else if (this.task != null) {
            this.log.info("Task not cancelable: {}", (Object)this.task.taskConfiguration().getTaskLogName());
            throw new UnableToInterruptJobException("Task not cancelable: " + this.task);
        }
    }

    public static TaskConfiguration configurationOf(JobDetail jobDetail) {
        Preconditions.checkNotNull((Object)jobDetail);
        TaskConfiguration config = new TaskConfiguration();
        for (Map.Entry entry : jobDetail.getJobDataMap().entrySet()) {
            if (!(entry.getValue() instanceof String)) continue;
            config.setString((String)entry.getKey(), (String)entry.getValue());
        }
        return config;
    }

    public static void updateJobData(JobDetail jobDetail, TaskConfiguration taskConfiguration) {
        JobDataMap jobDataMap = jobDetail.getJobDataMap();
        taskConfiguration.asMap().forEach((key, value) -> {
            if (!value.equals(jobDataMap.get(key))) {
                jobDataMap.put(key, value);
            }
        });
    }
}

