/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.quartz.internal.task;

import com.google.common.base.Preconditions;
import java.util.Date;
import javax.annotation.Nullable;
import org.quartz.JobDetail;
import org.sonatype.nexus.scheduling.TaskConfiguration;
import org.sonatype.nexus.scheduling.TaskInfo;
import org.sonatype.nexus.scheduling.schedule.Schedule;

public class QuartzTaskState {
    public static final String LAST_RUN_STATE_END_STATE = "lastRunState.endState";
    public static final String LAST_RUN_STATE_RUN_STARTED = "lastRunState.runStarted";
    public static final String LAST_RUN_STATE_RUN_DURATION = "lastRunState.runDuration";
    private final TaskConfiguration taskConfiguration;
    private final Schedule schedule;
    private final Date nextExecutionTime;

    public QuartzTaskState(TaskConfiguration config, Schedule schedule, @Nullable Date nextExecutionTime) {
        this.taskConfiguration = (TaskConfiguration)Preconditions.checkNotNull((Object)config);
        this.schedule = (Schedule)Preconditions.checkNotNull((Object)schedule);
        this.nextExecutionTime = nextExecutionTime;
    }

    public TaskConfiguration getConfiguration() {
        return this.taskConfiguration;
    }

    public Schedule getSchedule() {
        return this.schedule;
    }

    public Date getNextExecutionTime() {
        return this.nextExecutionTime;
    }

    @Nullable
    public TaskInfo.LastRunState getLastRunState() {
        return QuartzTaskState.getLastRunState(this.taskConfiguration);
    }

    public static void setLastRunState(TaskConfiguration config, TaskInfo.EndState endState, Date runStarted, long runDuration) {
        Preconditions.checkNotNull((Object)config);
        Preconditions.checkNotNull((Object)endState);
        Preconditions.checkNotNull((Object)runStarted);
        Preconditions.checkArgument((runDuration >= 0L ? 1 : 0) != 0);
        config.setString(LAST_RUN_STATE_END_STATE, endState.name());
        config.setLong(LAST_RUN_STATE_RUN_STARTED, runStarted.getTime());
        config.setLong(LAST_RUN_STATE_RUN_DURATION, runDuration);
    }

    public static void setLastRunState(JobDetail jobDetail, TaskInfo.EndState endState, Date runStarted, long runDuration) {
        Preconditions.checkNotNull((Object)jobDetail);
        Preconditions.checkNotNull((Object)endState);
        Preconditions.checkNotNull((Object)runStarted);
        Preconditions.checkArgument((runDuration >= 0L ? 1 : 0) != 0);
        jobDetail.getJobDataMap().put(LAST_RUN_STATE_END_STATE, endState.name());
        jobDetail.getJobDataMap().put(LAST_RUN_STATE_RUN_STARTED, runStarted.getTime());
        jobDetail.getJobDataMap().put(LAST_RUN_STATE_RUN_DURATION, runDuration);
    }

    @Nullable
    public static TaskInfo.LastRunState getLastRunState(TaskConfiguration config) {
        if (QuartzTaskState.hasLastRunState(config)) {
            String endStateString = config.getString(LAST_RUN_STATE_END_STATE);
            long runStarted = config.getLong(LAST_RUN_STATE_RUN_STARTED, System.currentTimeMillis());
            long runDuration = config.getLong(LAST_RUN_STATE_RUN_DURATION, 0L);
            return new LastRunStateImpl(TaskInfo.EndState.valueOf((String)endStateString), new Date(runStarted), runDuration);
        }
        return null;
    }

    public static boolean hasLastRunState(TaskConfiguration config) {
        Preconditions.checkNotNull((Object)config);
        return config.getString(LAST_RUN_STATE_END_STATE) != null;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "taskConfiguration=" + this.taskConfiguration + ", schedule=" + this.schedule + ", nextExecutionTime=" + this.nextExecutionTime + '}';
    }

    private static class LastRunStateImpl
    implements TaskInfo.LastRunState {
        private final TaskInfo.EndState endState;
        private final Date runStarted;
        private final long runDuration;

        public LastRunStateImpl(TaskInfo.EndState endState, Date runStarted, long runDuration) {
            this.endState = endState;
            this.runStarted = runStarted;
            this.runDuration = runDuration;
        }

        public TaskInfo.EndState getEndState() {
            return this.endState;
        }

        public Date getRunStarted() {
            return this.runStarted;
        }

        public long getRunDuration() {
            return this.runDuration;
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + "{" + "endState=" + this.endState + ", runStarted=" + this.runStarted + ", runDuration=" + this.runDuration + '}';
        }
    }
}

