/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.restore.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.blobstore.restore.internal.YumRestoreBlobData;
import javax.annotation.Nonnull;
import org.eclipse.aether.util.StringUtils;
import org.sonatype.nexus.blobstore.restore.RestoreBlobData;
import org.sonatype.nexus.repository.proxy.ProxyFacet;
import org.sonatype.nexus.repository.yum.AssetKind;
import org.sonatype.nexus.repository.yum.utils.YumPathUtils;

public final class YumRestoreBlobDataFactory {
    public YumRestoreBlobData create(@Nonnull RestoreBlobData data) {
        Preconditions.checkState((!StringUtils.isEmpty((String)data.getBlobName()) ? 1 : 0) != 0, (Object)"Blob name cannot be empty");
        AssetKind assetKind = this.parseAssetKind(data.getBlobName());
        if (data.getRepository().optionalFacet(ProxyFacet.class).isPresent() && assetKind == AssetKind.COMPS) {
            assetKind = AssetKind.REPODATA;
        }
        return new YumRestoreBlobData(data.getBlobName(), assetKind, data);
    }

    private AssetKind parseAssetKind(String blobName) {
        if (YumPathUtils.REPOMD_ASC_MATCHER.matcher(blobName).matches()) {
            return AssetKind.REPOMD_ASC;
        }
        if (YumPathUtils.REPOMD_MATCHER.matcher(blobName).matches()) {
            return AssetKind.REPOMD;
        }
        if (YumPathUtils.COMPS_MATCHER.matcher(blobName).matches()) {
            return AssetKind.COMPS;
        }
        if (YumPathUtils.REPODATA_MATCHER.matcher(blobName).matches()) {
            return AssetKind.REPODATA;
        }
        if (YumPathUtils.RPM_MATCHER.matcher(blobName).matches()) {
            return AssetKind.RPM;
        }
        throw new IllegalStateException();
    }
}

