/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.restore.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.sonatype.nexus.blobstore.restore.internal.YumRestoreBlobData;
import com.sonatype.nexus.blobstore.restore.internal.YumRestoreBlobDataFactory;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.blobstore.restore.BaseRestoreBlobStrategy;
import org.sonatype.nexus.blobstore.restore.RestoreBlobData;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.log.DryRunPrefix;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.yum.YumFacet;

@Named(value="yum")
@Singleton
public class YumRestoreBlobStrategy
extends BaseRestoreBlobStrategy<YumRestoreBlobData> {
    final YumRestoreBlobDataFactory yumRestoreBlobDataFactory;

    @Inject
    public YumRestoreBlobStrategy(RepositoryManager repositoryManager, BlobStoreManager blobStoreManager, NodeAccess nodeAccess, DryRunPrefix dryRunPrefix, YumRestoreBlobDataFactory yumRestoreBlobDataFactory) {
        super(nodeAccess, repositoryManager, blobStoreManager, dryRunPrefix);
        this.yumRestoreBlobDataFactory = (YumRestoreBlobDataFactory)Preconditions.checkNotNull((Object)yumRestoreBlobDataFactory);
    }

    protected YumRestoreBlobData createRestoreData(RestoreBlobData blobData) {
        return this.yumRestoreBlobDataFactory.create(blobData);
    }

    protected boolean canAttemptRestore(@Nonnull YumRestoreBlobData data) {
        Repository repository = data.getBlobData().getRepository();
        Optional yumFacet = repository.optionalFacet(YumFacet.class);
        if (!yumFacet.isPresent()) {
            this.log.warn("Skipping as Yum Facet not found on repository: {}", (Object)repository.getName());
            return false;
        }
        return true;
    }

    protected String getAssetPath(@Nonnull YumRestoreBlobData data) {
        return data.getPath();
    }

    protected boolean assetExists(@Nonnull YumRestoreBlobData data) throws IOException {
        YumFacet yumFacet = (YumFacet)data.getBlobData().getRepository().facet(YumFacet.class);
        return yumFacet.getAsset(data.getBlobData().getBlobName()) != null;
    }

    protected void createAssetFromBlob(@Nonnull AssetBlob assetBlob, @Nonnull YumRestoreBlobData data) throws IOException {
        YumFacet yumFacet = (YumFacet)data.getBlobData().getRepository().facet(YumFacet.class);
        switch (data.getAssetKind()) {
            case RPM: {
                yumFacet.storeRpm(data.getPath(), assetBlob, new AttributesMap());
                break;
            }
            case REPOMD: 
            case REPOMD_ASC: 
            case REPODATA: 
            case COMPS: {
                yumFacet.storeMetadata(data.getPath(), assetBlob, data.getAssetKind(), new AttributesMap());
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    @Nonnull
    protected List<HashAlgorithm> getHashAlgorithms() {
        return Lists.newArrayList((Object[])new HashAlgorithm[]{HashAlgorithm.SHA1, HashAlgorithm.SHA256, HashAlgorithm.SHA512, HashAlgorithm.MD5});
    }
}

