/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class ScanPropertiesLoader {
    private final Logger log;
    private final Map<String, Collection<String>> aliases;

    @Inject
    public ScanPropertiesLoader() {
        this(LoggerFactory.getLogger(ScanPropertiesLoader.class));
    }

    public ScanPropertiesLoader(Logger log) {
        this.log = log;
        this.aliases = new LinkedHashMap<String, Collection<String>>();
        this.aliases.put("anonymize", Arrays.asList("anonymizePaths", "anonymizeArtifactIds"));
        this.aliases.put("filenames", Arrays.asList("archiveNames", "resourceNames"));
        this.aliases.put("allData", Arrays.asList("archiveNames", "resourceNames", "pomProperties", "fileSizes", "hashFiles", "!anonymizePaths", "!anonymizeArtifactIds"));
    }

    public void load(Properties props, File file) throws IOException {
        this.log.info("Loading scan configuration from {}", (Object)file);
        try (FileInputStream is = new FileInputStream(file);){
            props.load(is);
        }
    }

    public void loadDefaults(Properties props, String resource) throws IOException {
        if (resource != null) {
            URL url = this.getClass().getClassLoader().getResource(resource);
            if (url != null) {
                this.loadDefaults(props, url);
            } else {
                this.log.warn("Could not load scan configuration defaults from resource {}", (Object)resource);
            }
        }
        Enumeration<URL> en = this.getClass().getClassLoader().getResources("META-INF/insight/configuration.properties");
        while (en.hasMoreElements()) {
            URL url = en.nextElement();
            this.loadDefaults(props, url);
        }
    }

    private void loadDefaults(Properties props, URL url) throws IOException {
        this.log.debug("Loading scan configuration defaults from {}", (Object)url);
        Properties defaults = new Properties();
        try (InputStream is = url.openStream();){
            defaults.load(is);
        }
        this.merge(props, defaults);
    }

    private void merge(Properties dominant, Properties recessive) {
        for (Map.Entry<Object, Object> entry : recessive.entrySet()) {
            String key = entry.getKey().toString();
            if (dominant.getProperty(key) != null) continue;
            dominant.setProperty(key, entry.getValue().toString());
        }
    }

    public void resolveAliases(Properties props) {
        for (Map.Entry<String, Collection<String>> entry : this.aliases.entrySet()) {
            String value = props.getProperty(entry.getKey());
            if (value == null) continue;
            for (String key : entry.getValue()) {
                if (key.startsWith("!")) {
                    if (props.getProperty(key = key.substring(1)) != null) continue;
                    props.setProperty(key, Boolean.toString(!Boolean.parseBoolean(value)));
                    continue;
                }
                if (props.getProperty(key) != null) continue;
                props.setProperty(key, value);
            }
        }
    }
}

