/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.raw;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.raw.RawContentFacet;
import org.sonatype.nexus.repository.rest.UploadDefinitionExtension;
import org.sonatype.nexus.repository.security.ContentPermissionChecker;
import org.sonatype.nexus.repository.security.VariableResolverAdapter;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.upload.AssetUpload;
import org.sonatype.nexus.repository.upload.ComponentUpload;
import org.sonatype.nexus.repository.upload.UploadDefinition;
import org.sonatype.nexus.repository.upload.UploadFieldDefinition;
import org.sonatype.nexus.repository.upload.UploadHandlerSupport;
import org.sonatype.nexus.repository.upload.UploadRegexMap;
import org.sonatype.nexus.repository.upload.UploadResponse;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.PartPayload;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named(value="raw")
@Singleton
public class RawUploadHandler
extends UploadHandlerSupport {
    private static final String FILENAME = "filename";
    private static final String DIRECTORY = "directory";
    private static final String DIRECTORY_HELP_TEXT = "Destination for uploaded files (e.g. /path/to/files/)";
    private static final String FIELD_GROUP_NAME = "Component attributes";
    private UploadDefinition definition;
    private final ContentPermissionChecker contentPermissionChecker;
    private final VariableResolverAdapter variableResolverAdapter;

    @Inject
    public RawUploadHandler(ContentPermissionChecker contentPermissionChecker, @Named(value="simple") VariableResolverAdapter variableResolverAdapter, Set<UploadDefinitionExtension> uploadDefinitionExtensions) {
        super(uploadDefinitionExtensions);
        this.contentPermissionChecker = contentPermissionChecker;
        this.variableResolverAdapter = variableResolverAdapter;
    }

    public UploadResponse handle(Repository repository, ComponentUpload upload) throws IOException {
        String path;
        RawContentFacet facet = (RawContentFacet)repository.facet(RawContentFacet.class);
        String basePath = ((String)upload.getFields().get(DIRECTORY)).trim();
        ArrayList responseContents = Lists.newArrayList();
        LinkedHashMap<String, PartPayload> pathToPayload = new LinkedHashMap<String, PartPayload>();
        for (AssetUpload assetUpload : upload.getAssetUploads()) {
            path = this.normalizePath(String.valueOf(basePath) + '/' + ((String)assetUpload.getFields().get(FILENAME)).trim());
            this.ensurePermitted(repository.getName(), "raw", path, Collections.emptyMap());
            pathToPayload.put(path, assetUpload.getPayload());
        }
        UnitOfWork.begin((Supplier)((StorageFacet)repository.facet(StorageFacet.class)).txSupplier());
        try {
            for (Map.Entry entry : pathToPayload.entrySet()) {
                path = (String)entry.getKey();
                Content content = facet.put(path, (Payload)entry.getValue());
                responseContents.add(content);
            }
        }
        finally {
            UnitOfWork.end();
        }
        return new UploadResponse((Collection)responseContents, new ArrayList(pathToPayload.keySet()));
    }

    private String normalizePath(String path) {
        String result = path.replaceAll("/+", "/");
        if (result.startsWith("/")) {
            result = result.substring(1);
        }
        if (result.endsWith("/")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public UploadDefinition getDefinition() {
        if (this.definition == null) {
            this.definition = this.getDefinition("raw", true, Collections.singletonList(new UploadFieldDefinition(DIRECTORY, DIRECTORY_HELP_TEXT, false, UploadFieldDefinition.Type.STRING, FIELD_GROUP_NAME)), Collections.singletonList(new UploadFieldDefinition(FILENAME, false, UploadFieldDefinition.Type.STRING)), new UploadRegexMap("(.*)", new String[]{FILENAME}));
        }
        return this.definition;
    }

    public VariableResolverAdapter getVariableResolverAdapter() {
        return this.variableResolverAdapter;
    }

    public ContentPermissionChecker contentPermissionChecker() {
        return this.contentPermissionChecker;
    }
}

