/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.restore.maven.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.blobstore.restore.BaseRestoreBlobStrategy;
import org.sonatype.nexus.blobstore.restore.RestoreBlobData;
import org.sonatype.nexus.blobstore.restore.maven.internal.MavenRestoreBlobData;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.log.DryRunPrefix;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.maven.MavenFacet;
import org.sonatype.nexus.repository.maven.MavenPath;
import org.sonatype.nexus.repository.maven.MavenPathParser;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.transaction.TransactionalStoreMetadata;
import org.sonatype.nexus.repository.transaction.TransactionalTouchBlob;

@Named(value="maven2")
@Singleton
public class MavenRestoreBlobStrategy
extends BaseRestoreBlobStrategy<MavenRestoreBlobData> {
    private final MavenPathParser mavenPathParser;

    @Inject
    public MavenRestoreBlobStrategy(MavenPathParser mavenPathParser, NodeAccess nodeAccess, RepositoryManager repositoryManager, BlobStoreManager blobStoreManager, DryRunPrefix dryRunPrefix) {
        super(nodeAccess, repositoryManager, blobStoreManager, dryRunPrefix);
        this.mavenPathParser = (MavenPathParser)Preconditions.checkNotNull((Object)mavenPathParser);
    }

    protected MavenRestoreBlobData createRestoreData(RestoreBlobData blobData) {
        return new MavenRestoreBlobData(blobData, this.mavenPathParser.parsePath(blobData.getBlobName()));
    }

    protected boolean canAttemptRestore(@Nonnull MavenRestoreBlobData data) {
        MavenPath mavenPath = data.getMavenPath();
        Repository repository = data.getBlobData().getRepository();
        if (mavenPath.getCoordinates() == null && !this.mavenPathParser.isRepositoryMetadata(mavenPath)) {
            this.log.warn("Skipping as no maven coordinates found and is not maven metadata");
            return false;
        }
        Optional mavenFacet = repository.optionalFacet(MavenFacet.class);
        if (!mavenFacet.isPresent()) {
            this.log.warn("Skipping as Maven Facet not found on repository: {}", (Object)repository.getName());
            return false;
        }
        return true;
    }

    @Nonnull
    protected List<HashAlgorithm> getHashAlgorithms() {
        return Lists.newArrayList((Object[])new HashAlgorithm[]{HashAlgorithm.MD5, HashAlgorithm.SHA1});
    }

    protected String getAssetPath(@Nonnull MavenRestoreBlobData data) {
        return data.getMavenPath().getPath();
    }

    @TransactionalTouchBlob
    protected boolean assetExists(@Nonnull MavenRestoreBlobData data) throws IOException {
        return ((MavenFacet)data.getBlobData().getRepository().facet(MavenFacet.class)).get(data.getMavenPath()) != null;
    }

    @TransactionalStoreMetadata
    protected void createAssetFromBlob(@Nonnull AssetBlob assetBlob, @Nonnull MavenRestoreBlobData data) throws IOException {
        ((MavenFacet)data.getBlobData().getRepository().facet(MavenFacet.class)).put(data.getMavenPath(), assetBlob, null);
    }
}

