/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.concur.executors;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class SubExecutorService
implements ExecutorService {
    private final ExecutorService executorService;
    private boolean alive = true;
    private final Lock aliveLock = new ReentrantLock();
    private final Condition terminated = this.aliveLock.newCondition();
    private final Set<Task> tasks = new HashSet<Task>();

    public SubExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    @Override
    public void shutdown() {
        this.acquireAlive();
        try {
            this.alive = false;
            this.shutdownTasks(this.tasks);
        }
        finally {
            this.releaseAlive();
        }
    }

    @Override
    public List<Runnable> shutdownNow() {
        throw new UnsupportedOperationException("shutdownNow is not supported");
    }

    @Override
    public boolean isShutdown() {
        this.acquireAlive();
        try {
            boolean bl = !this.isAlive();
            return bl;
        }
        finally {
            this.releaseAlive();
        }
    }

    @Override
    public boolean isTerminated() {
        this.acquireAlive();
        try {
            boolean bl = !this.isRunning();
            return bl;
        }
        finally {
            this.releaseAlive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        this.acquireAlive();
        try {
            boolean bl = !this.isRunning() || this.terminated.await(timeout, unit);
            return bl;
        }
        finally {
            this.releaseAlive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Future<T> submit(Callable<T> task) {
        this.acquireAlive();
        try {
            if (this.isAlive()) {
                CallableTask wrapped = new CallableTask(task, true);
                wrapped.acquireExecution();
                try {
                    wrapped.setFuture(this.getExecutorService().submit(wrapped));
                    CallableTask callableTask = this.register(wrapped);
                    return callableTask;
                }
                finally {
                    wrapped.releaseExecution();
                }
            }
            Future future = (Future)this.throwRejected(task);
            return future;
        }
        finally {
            this.releaseAlive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        this.acquireAlive();
        try {
            if (this.isAlive()) {
                RunnableTask<T> wrapped = new RunnableTask<T>(task, true);
                wrapped.acquireExecution();
                try {
                    wrapped.setFuture(this.getExecutorService().submit(wrapped, result));
                    RunnableTask runnableTask = this.register(wrapped);
                    return runnableTask;
                }
                finally {
                    wrapped.releaseExecution();
                }
            }
            Future future = (Future)this.throwRejected(task);
            return future;
        }
        finally {
            this.releaseAlive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<?> submit(Runnable task) {
        this.acquireAlive();
        try {
            if (this.isAlive()) {
                RunnableTask wrapped = new RunnableTask(task, true);
                wrapped.acquireExecution();
                try {
                    wrapped.setFuture(this.getExecutorService().submit(wrapped));
                    RunnableTask runnableTask = this.register(wrapped);
                    return runnableTask;
                }
                finally {
                    wrapped.releaseExecution();
                }
            }
            Future future = (Future)this.throwRejected(task);
            return future;
        }
        finally {
            this.releaseAlive();
        }
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        throw new UnsupportedOperationException("invokeAll is not supported");
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException("invokeAll is not supported");
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        throw new UnsupportedOperationException("invokeAny is not supported");
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        throw new UnsupportedOperationException("invokeAny is not supported");
    }

    @Override
    public void execute(Runnable command) {
        this.submit(command);
    }

    public String toString() {
        return "Sub(" + this.getExecutorService().toString() + ")";
    }

    protected void acquireAlive() {
        this.aliveLock.lock();
    }

    protected void releaseAlive() {
        this.aliveLock.unlock();
    }

    protected boolean isAlive() {
        return this.alive;
    }

    protected boolean isRunning() {
        return this.isAlive() || !this.tasks.isEmpty();
    }

    protected ExecutorService getExecutorService() {
        return this.executorService;
    }

    protected <T> T throwRejected(Object task) {
        throw new RejectedExecutionException("Task " + task + " rejected from " + this);
    }

    protected <T extends Task> T register(T task) {
        this.tasks.add(task);
        return task;
    }

    protected void unregister(Task task) {
        this.tasks.remove(task);
        if (!this.isAlive() && this.tasks.isEmpty()) {
            this.terminated.signalAll();
        }
    }

    protected void shutdownTasks(Set<Task> tasks) {
    }

    protected class CallableTask<V>
    implements Task<V> {
        private final Semaphore executionLock = new Semaphore(1);
        private final Callable<V> callable;
        private final boolean unregister;
        private Future<V> future;

        public CallableTask(Callable callable, boolean unregister) {
            this.callable = callable;
            this.unregister = unregister;
        }

        @Override
        public Future<V> getFuture() {
            return this.future;
        }

        @Override
        public void setFuture(Future<V> future) {
            this.future = future;
        }

        @Override
        public void acquireExecution() {
            this.executionLock.acquireUninterruptibly();
        }

        @Override
        public void releaseExecution() {
            this.executionLock.release();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.acquireExecution();
            try {
                if (!this.unregister && this.isCancelled()) {
                    return;
                }
                try {
                    try {
                        this.callable.call();
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                finally {
                    if (this.unregister) {
                        SubExecutorService.this.acquireAlive();
                        try {
                            SubExecutorService.this.unregister(this);
                        }
                        finally {
                            SubExecutorService.this.releaseAlive();
                        }
                    }
                }
            }
            finally {
                this.releaseExecution();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V call() throws Exception {
            this.acquireExecution();
            try {
                V v;
                block15: {
                    if (!this.unregister && this.isCancelled()) {
                        V v2 = null;
                        return v2;
                    }
                    try {
                        v = this.callable.call();
                        if (!this.unregister) break block15;
                        SubExecutorService.this.acquireAlive();
                    }
                    catch (Throwable throwable) {
                        if (this.unregister) {
                            SubExecutorService.this.acquireAlive();
                            try {
                                SubExecutorService.this.unregister(this);
                            }
                            finally {
                                SubExecutorService.this.releaseAlive();
                            }
                        }
                        throw throwable;
                    }
                    try {
                        SubExecutorService.this.unregister(this);
                    }
                    finally {
                        SubExecutorService.this.releaseAlive();
                    }
                }
                return v;
            }
            finally {
                this.releaseExecution();
            }
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.getFuture().cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.getFuture().isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.getFuture().isDone();
        }

        @Override
        public V get() throws InterruptedException, ExecutionException {
            return this.getFuture().get();
        }

        @Override
        public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.getFuture().get(timeout, unit);
        }
    }

    protected class RunnableTask<V>
    implements Task<V> {
        private final Semaphore executionLock = new Semaphore(1);
        private final Runnable runnable;
        private final boolean unregister;
        private Future<V> future;

        public RunnableTask(Runnable runnable, boolean unregister) {
            this.runnable = runnable;
            this.unregister = unregister;
        }

        @Override
        public Future<V> getFuture() {
            return this.future;
        }

        @Override
        public void setFuture(Future<V> future) {
            this.future = future;
        }

        @Override
        public void acquireExecution() {
            this.executionLock.acquireUninterruptibly();
        }

        @Override
        public void releaseExecution() {
            this.executionLock.release();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.acquireExecution();
            try {
                if (!this.unregister && this.isCancelled()) {
                    return;
                }
                try {
                    this.runnable.run();
                }
                finally {
                    if (this.unregister) {
                        SubExecutorService.this.acquireAlive();
                        try {
                            SubExecutorService.this.unregister(this);
                        }
                        finally {
                            SubExecutorService.this.releaseAlive();
                        }
                    }
                }
            }
            finally {
                this.releaseExecution();
            }
        }

        @Override
        public V call() throws Exception {
            this.run();
            return null;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.getFuture().cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.getFuture().isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.getFuture().isDone();
        }

        @Override
        public V get() throws InterruptedException, ExecutionException {
            return this.getFuture().get();
        }

        @Override
        public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.getFuture().get(timeout, unit);
        }
    }

    protected static interface Task<V>
    extends Runnable,
    Callable<V>,
    Future<V> {
        public Future<V> getFuture();

        public void setFuture(Future<V> var1);

        public void acquireExecution();

        public void releaseExecution();
    }
}

