/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.record.ridbag.sbtree;

import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import com.orientechnologies.common.concur.resource.OCloseable;
import com.orientechnologies.orient.core.OOrientShutdownListener;
import com.orientechnologies.orient.core.OOrientStartupListener;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OBonsaiCollectionPointer;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OSBTreeCollectionManager;
import com.orientechnologies.orient.core.index.sbtreebonsai.local.OSBTreeBonsai;
import com.orientechnologies.orient.core.storage.OStorage;
import java.util.Iterator;
import java.util.UUID;

public abstract class OSBTreeCollectionManagerAbstract
implements OCloseable,
OSBTreeCollectionManager,
OOrientStartupListener,
OOrientShutdownListener {
    public static final String FILE_NAME_PREFIX = "collections_";
    public static final String DEFAULT_EXTENSION = ".sbc";
    private static final ConcurrentLinkedHashMap<CacheKey, SBTreeBonsaiContainer> GLOBAL_TREE_CACHE = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(Long.MAX_VALUE).build();
    private static final int GLOBAL_EVICTION_THRESHOLD = OGlobalConfiguration.SBTREEBONSAI_LINKBAG_CACHE_EVICTION_SIZE.getValueAsInteger();
    private static final int GLOBAL_CACHE_MAX_SIZE = OGlobalConfiguration.SBTREEBONSAI_LINKBAG_CACHE_SIZE.getValueAsInteger();
    private static final Object[] GLOBAL_LOCKS;
    private static final int GLOBAL_SHIFT;
    private static final int GLOBAL_MASK;
    protected final int evictionThreshold;
    protected final int cacheMaxSize;
    protected final int shift;
    protected final int mask;
    protected final Object[] locks;
    private final ConcurrentLinkedHashMap<CacheKey, SBTreeBonsaiContainer> treeCache;
    private final OStorage storage;

    public static String generateLockName(int clusterId) {
        return FILE_NAME_PREFIX + clusterId + DEFAULT_EXTENSION;
    }

    public OSBTreeCollectionManagerAbstract(OStorage storage) {
        this(GLOBAL_TREE_CACHE, storage, GLOBAL_EVICTION_THRESHOLD, GLOBAL_CACHE_MAX_SIZE, GLOBAL_LOCKS);
    }

    OSBTreeCollectionManagerAbstract(OStorage storage, int evictionThreshold, int cacheMaxSize) {
        this((ConcurrentLinkedHashMap<CacheKey, SBTreeBonsaiContainer>)new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(Long.MAX_VALUE).build(), storage, evictionThreshold, cacheMaxSize, null);
    }

    private OSBTreeCollectionManagerAbstract(ConcurrentLinkedHashMap<CacheKey, SBTreeBonsaiContainer> treeCache, OStorage storage, int evictionThreshold, int cacheMaxSize, Object[] locks) {
        this.treeCache = treeCache;
        this.storage = storage;
        this.evictionThreshold = evictionThreshold;
        this.cacheMaxSize = cacheMaxSize;
        if (locks == null) {
            int concurrencyLevel = Runtime.getRuntime().availableProcessors() * 8;
            int size = 1;
            int shifted = 0;
            while (size < concurrencyLevel) {
                size <<= 1;
                ++shifted;
            }
            this.shift = 32 - shifted;
            this.mask = size - 1;
            locks = new Object[size];
            for (int i = 0; i < locks.length; ++i) {
                locks[i] = new Object();
            }
        } else {
            this.shift = GLOBAL_SHIFT;
            this.mask = GLOBAL_MASK;
        }
        this.locks = locks;
        Orient.instance().registerWeakOrientStartupListener(this);
        Orient.instance().registerWeakOrientShutdownListener(this);
    }

    @Override
    public void onStartup() {
    }

    @Override
    public void onShutdown() {
        this.treeCache.clear();
    }

    @Override
    public OSBTreeBonsai<OIdentifiable, Integer> createAndLoadTree(int clusterId) {
        return this.loadSBTree(this.createSBTree(clusterId, null));
    }

    @Override
    public OBonsaiCollectionPointer createSBTree(int clusterId, UUID ownerUUID) {
        OSBTreeBonsai<OIdentifiable, Integer> tree = this.createTree(clusterId);
        return tree.getCollectionPointer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OSBTreeBonsai<OIdentifiable, Integer> loadSBTree(OBonsaiCollectionPointer collectionPointer) {
        OSBTreeBonsai tree;
        Object lock;
        CacheKey cacheKey = new CacheKey(this.storage, collectionPointer);
        Object object = lock = this.treesSubsetLock(cacheKey);
        synchronized (object) {
            SBTreeBonsaiContainer container = (SBTreeBonsaiContainer)this.treeCache.get((Object)cacheKey);
            if (container != null) {
                container.usagesCounter++;
                tree = container.tree;
            } else {
                tree = this.loadTree(collectionPointer);
                if (tree != null) {
                    assert (tree.getRootBucketPointer().equals(collectionPointer.getRootPointer()));
                    container = new SBTreeBonsaiContainer(tree);
                    container.usagesCounter++;
                    this.treeCache.put((Object)cacheKey, (Object)container);
                }
            }
        }
        if (tree != null) {
            this.evict();
        }
        return tree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseSBTree(OBonsaiCollectionPointer collectionPointer) {
        Object lock;
        CacheKey cacheKey = new CacheKey(this.storage, collectionPointer);
        Object object = lock = this.treesSubsetLock(cacheKey);
        synchronized (object) {
            SBTreeBonsaiContainer container = (SBTreeBonsaiContainer)this.treeCache.getQuietly((Object)cacheKey);
            assert (container != null);
            container.usagesCounter--;
            assert (container.usagesCounter >= 0);
        }
        this.evict();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(OBonsaiCollectionPointer collectionPointer) {
        Object lock;
        CacheKey cacheKey = new CacheKey(this.storage, collectionPointer);
        Object object = lock = this.treesSubsetLock(cacheKey);
        synchronized (object) {
            SBTreeBonsaiContainer container = (SBTreeBonsaiContainer)this.treeCache.getQuietly((Object)cacheKey);
            assert (container != null);
            if (container.usagesCounter != 0) {
                throw new IllegalStateException("Cannot delete SBTreeBonsai instance because it is used in other thread.");
            }
            this.treeCache.remove((Object)cacheKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evict() {
        if (this.treeCache.size() <= this.cacheMaxSize) {
            return;
        }
        for (CacheKey cacheKey : this.treeCache.ascendingKeySetWithLimit(this.evictionThreshold)) {
            Object treeLock;
            Object object = treeLock = this.treesSubsetLock(cacheKey);
            synchronized (object) {
                SBTreeBonsaiContainer container = (SBTreeBonsaiContainer)this.treeCache.getQuietly((Object)cacheKey);
                if (container != null && container.usagesCounter == 0) {
                    this.treeCache.remove((Object)cacheKey);
                }
            }
        }
    }

    @Override
    public void close() {
        this.clear();
    }

    public void clear() {
        Iterator i = this.treeCache.keySet().iterator();
        while (i.hasNext()) {
            CacheKey cacheKey = (CacheKey)i.next();
            if (cacheKey.storage != this.storage) continue;
            i.remove();
        }
    }

    protected abstract OSBTreeBonsai<OIdentifiable, Integer> createTree(int var1);

    protected abstract OSBTreeBonsai<OIdentifiable, Integer> loadTree(OBonsaiCollectionPointer var1);

    int size() {
        return this.treeCache.size();
    }

    private Object treesSubsetLock(CacheKey cacheKey) {
        int hashCode = cacheKey.hashCode();
        int index = hashCode >>> this.shift & this.mask;
        return this.locks[index];
    }

    static {
        int concurrencyLevel = Runtime.getRuntime().availableProcessors() * 8;
        int size = 1;
        int shifted = 0;
        while (size < concurrencyLevel) {
            size <<= 1;
            ++shifted;
        }
        GLOBAL_SHIFT = 32 - shifted;
        GLOBAL_MASK = size - 1;
        Object[] locks = new Object[size];
        for (int i = 0; i < locks.length; ++i) {
            locks[i] = new Object();
        }
        GLOBAL_LOCKS = locks;
    }

    private static final class CacheKey {
        private final OStorage storage;
        private final OBonsaiCollectionPointer pointer;

        public CacheKey(OStorage storage, OBonsaiCollectionPointer pointer) {
            this.storage = storage;
            this.pointer = pointer;
        }

        public int hashCode() {
            return this.storage.hashCode() ^ this.pointer.hashCode();
        }

        public boolean equals(Object obj) {
            CacheKey other = (CacheKey)obj;
            return this.storage == other.storage && this.pointer.equals(other.pointer);
        }
    }

    private static final class SBTreeBonsaiContainer {
        private final OSBTreeBonsai<OIdentifiable, Integer> tree;
        private int usagesCounter = 0;

        private SBTreeBonsaiContainer(OSBTreeBonsai<OIdentifiable, Integer> tree) {
            this.tree = tree;
        }
    }
}

