/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.orient.core.collate.OCollate;
import com.orientechnologies.orient.core.config.OStorageConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.index.OCompositeIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.index.OIndexFactory;
import com.orientechnologies.orient.core.index.OIndexes;
import com.orientechnologies.orient.core.index.OPropertyIndexDefinition;
import com.orientechnologies.orient.core.index.OPropertyListIndexDefinition;
import com.orientechnologies.orient.core.index.OPropertyMapIndexDefinition;
import com.orientechnologies.orient.core.index.OPropertyRidBagIndexDefinition;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.storage.OStorage;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;

public class OIndexDefinitionFactory {
    private static final Pattern FILED_NAME_PATTERN = Pattern.compile("\\s+");

    public static OIndexDefinition createIndexDefinition(OClass oClass, List<String> fieldNames, List<OType> types, List<OCollate> collates, String indexKind, String algorithm) {
        OIndexDefinitionFactory.checkTypes(oClass, fieldNames, types);
        if (fieldNames.size() == 1) {
            return OIndexDefinitionFactory.createSingleFieldIndexDefinition(oClass, fieldNames.get(0), types.get(0), collates == null ? null : collates.get(0), indexKind, algorithm);
        }
        return OIndexDefinitionFactory.createMultipleFieldIndexDefinition(oClass, fieldNames, types, collates, indexKind, algorithm);
    }

    public static String extractFieldName(String fieldDefinition) {
        String[] fieldNameParts = FILED_NAME_PATTERN.split(fieldDefinition);
        if (fieldNameParts.length == 1) {
            return fieldDefinition;
        }
        if (fieldNameParts.length == 3 && "by".equalsIgnoreCase(fieldNameParts[1])) {
            return fieldNameParts[0];
        }
        throw new IllegalArgumentException("Illegal field name format, should be '<property> [by key|value]' but was '" + fieldDefinition + '\'');
    }

    private static OIndexDefinition createMultipleFieldIndexDefinition(OClass oClass, List<String> fieldsToIndex, List<OType> types, List<OCollate> collates, String indexKind, String algorithm) {
        OIndexFactory factory = OIndexes.getFactory(indexKind, algorithm);
        String className = oClass.getName();
        OCompositeIndexDefinition compositeIndex = new OCompositeIndexDefinition(className);
        int fieldsToIndexSize = fieldsToIndex.size();
        for (int i = 0; i < fieldsToIndexSize; ++i) {
            OCollate collate = null;
            if (collates != null) {
                collate = collates.get(i);
            }
            compositeIndex.addIndex(OIndexDefinitionFactory.createSingleFieldIndexDefinition(oClass, fieldsToIndex.get(i), types.get(i), collate, indexKind, algorithm));
        }
        return compositeIndex;
    }

    private static void checkTypes(OClass oClass, List<String> fieldNames, List<OType> types) {
        if (fieldNames.size() != types.size()) {
            throw new IllegalArgumentException("Count of field names doesn't match count of field types. It was " + fieldNames.size() + " fields, but " + types.size() + " types.");
        }
        int fieldNamesSize = fieldNames.size();
        for (int i = 0; i < fieldNamesSize; ++i) {
            String fieldName = fieldNames.get(i);
            OType type = types.get(i);
            OProperty property = oClass.getProperty(fieldName);
            if (property == null || type.equals((Object)property.getType())) continue;
            throw new IllegalArgumentException("Property type list not match with real property types");
        }
    }

    private static OIndexDefinition createSingleFieldIndexDefinition(OClass oClass, String field, OType type, OCollate collate, String indexKind, String algorithm) {
        OPropertyIndexDefinition indexDefinition;
        String fieldName = OClassImpl.decodeClassName(OIndexDefinitionFactory.adjustFieldName(oClass, OIndexDefinitionFactory.extractFieldName(field)));
        OProperty propertyToIndex = oClass.getProperty(fieldName);
        if (type == OType.EMBEDDEDMAP || type == OType.LINKMAP) {
            OType indexType;
            OPropertyMapIndexDefinition.INDEX_BY indexBy = OIndexDefinitionFactory.extractMapIndexSpecifier(field);
            if (indexBy.equals((Object)OPropertyMapIndexDefinition.INDEX_BY.KEY)) {
                indexType = OType.STRING;
            } else if (type == OType.LINKMAP) {
                indexType = OType.LINK;
            } else {
                indexType = propertyToIndex.getLinkedType();
                if (indexType == null) {
                    throw new OIndexException("Linked type was not provided. You should provide linked type for embedded collections that are going to be indexed.");
                }
            }
            indexDefinition = new OPropertyMapIndexDefinition(oClass.getName(), fieldName, indexType, indexBy);
        } else if (type.equals((Object)OType.EMBEDDEDLIST) || type.equals((Object)OType.EMBEDDEDSET) || type.equals((Object)OType.LINKLIST) || type.equals((Object)OType.LINKSET)) {
            OType indexType;
            if (type.equals((Object)OType.LINKSET)) {
                indexType = OType.LINK;
            } else if (type.equals((Object)OType.LINKLIST)) {
                indexType = OType.LINK;
            } else {
                indexType = propertyToIndex.getLinkedType();
                if (indexType == null) {
                    throw new OIndexException("Linked type was not provided. You should provide linked type for embedded collections that are going to be indexed.");
                }
            }
            indexDefinition = new OPropertyListIndexDefinition(oClass.getName(), fieldName, indexType);
        } else {
            indexDefinition = type.equals((Object)OType.LINKBAG) ? new OPropertyRidBagIndexDefinition(oClass.getName(), fieldName) : new OPropertyIndexDefinition(oClass.getName(), fieldName, type);
        }
        if (collate == null && propertyToIndex != null) {
            collate = propertyToIndex.getCollate();
        }
        if (collate != null) {
            indexDefinition.setCollate(collate);
        }
        return indexDefinition;
    }

    private static OPropertyMapIndexDefinition.INDEX_BY extractMapIndexSpecifier(String fieldName) {
        Locale locale;
        String[] fieldNameParts = FILED_NAME_PATTERN.split(fieldName);
        if (fieldNameParts.length == 1) {
            return OPropertyMapIndexDefinition.INDEX_BY.KEY;
        }
        if (fieldNameParts.length == 3 && "by".equals(fieldNameParts[1].toLowerCase(locale = OIndexDefinitionFactory.getServerLocale()))) {
            try {
                return OPropertyMapIndexDefinition.INDEX_BY.valueOf(fieldNameParts[2].toUpperCase(locale));
            }
            catch (IllegalArgumentException iae) {
                throw new IllegalArgumentException("Illegal field name format, should be '<property> [by key|value]' but was '" + fieldName + '\'', iae);
            }
        }
        throw new IllegalArgumentException("Illegal field name format, should be '<property> [by key|value]' but was '" + fieldName + '\'');
    }

    private static Locale getServerLocale() {
        ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.instance().get();
        OStorage storage = db.getStorage();
        OStorageConfiguration configuration = storage.getConfiguration();
        return configuration.getLocaleInstance();
    }

    private static String adjustFieldName(OClass clazz, String fieldName) {
        OProperty property = clazz.getProperty(fieldName);
        if (property != null) {
            return property.getName();
        }
        return fieldName;
    }
}

