/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.security;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;

public class ORule
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ResourceGeneric resourceGeneric;
    private final Map<String, Byte> specificResources = new HashMap<String, Byte>();
    private Byte access = null;

    public ORule(ResourceGeneric resourceGeneric, Map<String, Byte> specificResources, Byte access) {
        this.resourceGeneric = resourceGeneric;
        if (specificResources != null) {
            this.specificResources.putAll(specificResources);
        }
        this.access = access;
    }

    public static ResourceGeneric mapLegacyResourceToGenericResource(String resource) {
        Map.Entry found = ResourceGeneric.legacyToGenericMap.floorEntry(resource.toLowerCase(Locale.ENGLISH));
        if (found == null) {
            return null;
        }
        if (resource.length() < found.getKey().length()) {
            return null;
        }
        if (resource.substring(0, found.getKey().length()).equalsIgnoreCase(found.getKey())) {
            return (ResourceGeneric)found.getValue();
        }
        return null;
    }

    public static String mapResourceGenericToLegacyResource(ResourceGeneric resourceGeneric) {
        return (String)ResourceGeneric.genericToLegacyMap.get(resourceGeneric);
    }

    public static String mapLegacyResourceToSpecificResource(String resource) {
        Map.Entry found = ResourceGeneric.legacyToGenericMap.floorEntry(resource.toLowerCase(Locale.ENGLISH));
        if (found == null) {
            return resource;
        }
        if (resource.length() < found.getKey().length()) {
            return resource;
        }
        if (resource.length() == found.getKey().length()) {
            return null;
        }
        if (resource.substring(0, found.getKey().length()).equalsIgnoreCase(found.getKey())) {
            return resource.substring(found.getKey().length() + 1);
        }
        return resource;
    }

    public Byte getAccess() {
        return this.access;
    }

    public ResourceGeneric getResourceGeneric() {
        return this.resourceGeneric;
    }

    public Map<String, Byte> getSpecificResources() {
        return this.specificResources;
    }

    public void grantAccess(String resource, int operation) {
        if (resource == null) {
            this.access = this.grant((byte)operation, this.access);
        } else {
            resource = resource.toLowerCase(Locale.ENGLISH);
            Byte ac = this.specificResources.get(resource);
            this.specificResources.put(resource, this.grant((byte)operation, ac));
        }
    }

    private byte grant(byte operation, Byte ac) {
        if (operation == 0) {
            return 0;
        }
        byte currentValue = ac == null ? (byte)0 : ac;
        currentValue = (byte)(currentValue | operation);
        return currentValue;
    }

    public void revokeAccess(String resource, int operation) {
        if (operation == 0) {
            return;
        }
        if (resource == null) {
            this.access = this.revoke((byte)operation, this.access);
        } else {
            resource = resource.toLowerCase(Locale.ENGLISH);
            Byte ac = this.specificResources.get(resource);
            this.specificResources.put(resource, this.revoke((byte)operation, ac));
        }
    }

    private byte revoke(byte operation, Byte ac) {
        byte currentValue;
        if (ac == null) {
            currentValue = 0;
        } else {
            currentValue = ac;
            currentValue = (byte)(currentValue & ~operation);
        }
        return currentValue;
    }

    public Boolean isAllowed(String name, int operation) {
        if (name == null) {
            return this.allowed((byte)operation, this.access);
        }
        if (this.specificResources.isEmpty()) {
            return this.isAllowed(null, operation);
        }
        Byte ac = this.specificResources.get(name.toLowerCase(Locale.ENGLISH));
        Boolean allowed = this.allowed((byte)operation, ac);
        if (allowed == null) {
            return this.isAllowed(null, operation);
        }
        return allowed;
    }

    private Boolean allowed(byte operation, Byte ac) {
        if (ac == null) {
            return null;
        }
        byte mask = operation;
        return (ac & mask) == mask;
    }

    public boolean containsSpecificResource(String resource) {
        if (this.specificResources.isEmpty()) {
            return false;
        }
        return this.specificResources.containsKey(resource.toLowerCase(Locale.ENGLISH));
    }

    public static abstract class ResourceGeneric
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private static final TreeMap<String, ResourceGeneric> nameToGenericMap = new TreeMap();
        private static final TreeMap<String, ResourceGeneric> legacyToGenericMap = new TreeMap();
        private static final Map<ResourceGeneric, String> genericToLegacyMap = new HashMap<ResourceGeneric, String>();
        public static final ResourceGeneric FUNCTION = new ResourceGeneric("FUNCTION", "database.function"){};
        public static final ResourceGeneric CLASS = new ResourceGeneric("CLASS", "database.class"){};
        public static final ResourceGeneric CLUSTER = new ResourceGeneric("CLUSTER", "database.cluster"){};
        public static final ResourceGeneric BYPASS_RESTRICTED = new ResourceGeneric("BYPASS_RESTRICTED", "database.bypassRestricted"){};
        public static final ResourceGeneric DATABASE = new ResourceGeneric("DATABASE", "database"){};
        public static final ResourceGeneric SCHEMA = new ResourceGeneric("SCHEMA", "database.schema"){};
        public static final ResourceGeneric COMMAND = new ResourceGeneric("COMMAND", "database.command"){};
        public static final ResourceGeneric COMMAND_GREMLIN = new ResourceGeneric("COMMAND_GREMLIN", "database.command.gremlin"){};
        public static final ResourceGeneric RECORD_HOOK = new ResourceGeneric("RECORD_HOOK", "database.hook.record"){};
        public static final ResourceGeneric SYSTEM_CLUSTERS = new ResourceGeneric("SYSTEM_CLUSTER", "database.systemclusters"){};
        public static final ResourceGeneric SERVER = new ResourceGeneric("SERVER", "server"){};
        public static final ResourceGeneric DATABASE_COPY = new ResourceGeneric("DATABASE_COPY", "database.copy"){};
        public static final ResourceGeneric DATABASE_CREATE = new ResourceGeneric("DATABASE_CREATE", "database.create"){};
        public static final ResourceGeneric DATABASE_DROP = new ResourceGeneric("DATABASE_DROP", "database.drop"){};
        public static final ResourceGeneric DATABASE_EXISTS = new ResourceGeneric("DATABASE_EXISTS", "database.exists"){};
        public static final ResourceGeneric DATABASE_FREEZE = new ResourceGeneric("DATABASE_FREEZE", "database.freeze"){};
        public static final ResourceGeneric DATABASE_RELEASE = new ResourceGeneric("DATABASE_RELEASE", "database.release"){};
        public static final ResourceGeneric DATABASE_PASSTHROUGH = new ResourceGeneric("DATABASE_PASSTHROUGH", "database.passthrough"){};
        public static final ResourceGeneric DATABASE_BACKUP = new ResourceGeneric("DATABASE_BACKUP", "database.backup"){};
        public static final ResourceGeneric DATABASE_RESTORE = new ResourceGeneric("DATABASE_RESTORE", "database.restore"){};
        private final String name;
        private final String legacyName;

        protected ResourceGeneric(String name, String legacyName) {
            this.name = name;
            this.legacyName = legacyName != null ? legacyName : name;
            ResourceGeneric.register(this);
        }

        public String getName() {
            return this.name;
        }

        public String getLegacyName() {
            return this.legacyName;
        }

        private static void register(ResourceGeneric resource) {
            String legacyNameLowCase = resource.legacyName.toLowerCase(Locale.ENGLISH);
            if (nameToGenericMap.containsKey(resource.name) || legacyToGenericMap.containsKey(resource.legacyName.toLowerCase(Locale.ENGLISH)) || genericToLegacyMap.containsKey(resource)) {
                throw new IllegalArgumentException(resource + " already registered");
            }
            nameToGenericMap.put(resource.name, resource);
            legacyToGenericMap.put(legacyNameLowCase, resource);
            genericToLegacyMap.put(resource, resource.legacyName);
        }

        public static ResourceGeneric valueOf(String name) {
            return nameToGenericMap.get(name);
        }

        public static ResourceGeneric[] values() {
            return genericToLegacyMap.keySet().toArray(new ResourceGeneric[genericToLegacyMap.size()]);
        }

        public String toString() {
            return ResourceGeneric.class.getSimpleName() + " [name=" + this.name + ", legacyName=" + this.legacyName + "]";
        }
    }
}

