/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.schedule;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OCallable;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.iterator.ORecordIteratorClass;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.schedule.OScheduledEvent;
import com.orientechnologies.orient.core.schedule.OScheduler;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class OSchedulerImpl
implements OScheduler {
    private ConcurrentHashMap<String, OScheduledEvent> events = new ConcurrentHashMap();

    @Override
    public void scheduleEvent(OScheduledEvent event) {
        if (event.getDocument().getIdentity().isNew()) {
            event.save();
        }
        if (this.events.putIfAbsent(event.getName(), event) == null) {
            event.schedule();
        }
    }

    @Override
    public void removeEvent(String eventName) {
        OLogManager.instance().debug((Object)this, "Removing scheduled event '%s'...", eventName);
        final OScheduledEvent event = this.events.remove(eventName);
        if (event != null) {
            event.interrupt();
            try {
                event.getDocument().reload();
            }
            catch (ORecordNotFoundException ignore) {
                return;
            }
            ODatabaseDocumentTx.executeWithRetries(new OCallable<Object, Integer>(){

                @Override
                public Object call(Integer iArgument) {
                    OLogManager.instance().debug((Object)this, "Deleting scheduled event '%s' rid=%s...", event, event.getDocument().getIdentity());
                    try {
                        event.getDocument().delete();
                    }
                    catch (ORecordNotFoundException oRecordNotFoundException) {
                        // empty catch block
                    }
                    return null;
                }
            }, 10, 0, new ORecord[]{event.getDocument()});
        }
    }

    @Override
    public void updateEvent(OScheduledEvent event) {
        OScheduledEvent oldEvent = this.events.remove(event.getName());
        if (oldEvent != null) {
            oldEvent.interrupt();
        }
        this.scheduleEvent(event);
        OLogManager.instance().debug((Object)this, "Updated scheduled event '%s' rid=%s...", event, event.getDocument().getIdentity());
    }

    @Override
    public Map<String, OScheduledEvent> getEvents() {
        return this.events;
    }

    @Override
    public OScheduledEvent getEvent(String name) {
        return this.events.get(name);
    }

    @Override
    public void load() {
        ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.instance().get();
        if (db.getMetadata().getSchema().existsClass("OSchedule")) {
            ORecordIteratorClass<ODocument> result = db.browseClass("OSchedule");
            for (ODocument d : result) {
                OScheduledEvent event = new OScheduledEvent(d);
                if (this.events.putIfAbsent(event.getName(), event) != null) continue;
                this.scheduleEvent(event);
            }
        }
    }

    @Override
    public void close() {
        for (OScheduledEvent event : this.events.values()) {
            event.interrupt();
        }
        this.events.clear();
    }

    @Override
    public void create() {
        ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.instance().get();
        if (db.getMetadata().getSchema().existsClass("OSchedule")) {
            return;
        }
        OClass f = db.getMetadata().getSchema().createClass("OSchedule");
        f.createProperty("name", OType.STRING, (OType)null, true).setMandatory(true).setNotNull(true);
        f.createProperty("rule", OType.STRING, (OType)null, true).setMandatory(true).setNotNull(true);
        f.createProperty("arguments", OType.EMBEDDEDMAP, (OType)null, true);
        f.createProperty("status", OType.STRING, (OType)null, true);
        f.createProperty("function", OType.LINK, db.getMetadata().getSchema().getClass("OFunction"), true).setMandatory(true).setNotNull(true);
        f.createProperty("starttime", OType.DATETIME, (OType)null, true);
    }
}

