/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.record;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.OBlob;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ORecordBytes;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;

public class ORecordSerializerRaw
implements ORecordSerializer {
    public static final String NAME = "ORecordDocumentRaw";

    public ORecord fromStream(byte[] iSource) {
        return new ORecordBytes(iSource);
    }

    @Override
    public int getCurrentVersion() {
        return 0;
    }

    @Override
    public int getMinSupportedVersion() {
        return 0;
    }

    @Override
    public String[] getFieldNames(ODocument reference, byte[] iSource) {
        return null;
    }

    public String toString() {
        return NAME;
    }

    @Override
    public ORecord fromStream(byte[] iSource, ORecord iRecord, String[] iFields) {
        OBlob record = (OBlob)iRecord;
        record.reset();
        record.fromStream(iSource);
        return record;
    }

    @Override
    public byte[] writeClassOnly(ORecord iSource) {
        return new byte[0];
    }

    @Override
    public byte[] toStream(ORecord iSource, boolean iOnlyDelta) {
        try {
            return iSource.toStream();
        }
        catch (Exception e) {
            String message = "Error on unmarshalling object in binary format: " + iSource.getIdentity();
            OLogManager.instance().error(this, message, e, new Object[0]);
            throw OException.wrapException(new OSerializationException(message), e);
        }
    }

    @Override
    public boolean getSupportBinaryEvaluate() {
        return false;
    }
}

