/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.functions.coll;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.functions.coll.OSQLFunctionMultiValueAbstract;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OSQLFunctionDocument
extends OSQLFunctionMultiValueAbstract<ODocument> {
    public static final String NAME = "document";

    public OSQLFunctionDocument() {
        super(NAME, 1, -1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object execute(Object iThis, OIdentifiable iCurrentRecord, Object iCurrentResult, Object[] iParams, OCommandContext iContext) {
        if (iParams.length > 2) {
            this.context = new ODocument();
        }
        if (iParams.length == 1) {
            if (iParams[0] instanceof ODocument) {
                ((ODocument)this.context).merge((ODocument)iParams[0], true, false);
                return this.prepareResult((ODocument)this.context);
            } else {
                if (!(iParams[0] instanceof Map)) throw new IllegalArgumentException("Map function: expected a map or pairs of parameters as key, value");
                ((ODocument)this.context).fields((Map)iParams[0]);
            }
            return this.prepareResult((ODocument)this.context);
        } else {
            if (iParams.length % 2 != 0) {
                throw new IllegalArgumentException("Map function: expected a map or pairs of parameters as key, value");
            }
            for (int i = 0; i < iParams.length; i += 2) {
                String key = iParams[i].toString();
                Object value = iParams[i + 1];
                if (value == null) continue;
                if (iParams.length <= 2 && this.context == null) {
                    this.context = new ODocument();
                }
                ((ODocument)this.context).field(key, value);
            }
        }
        return this.prepareResult((ODocument)this.context);
    }

    @Override
    public String getSyntax() {
        return "document(<map>|[<key>,<value>]*)";
    }

    public boolean aggregateResults(Object[] configuredParameters) {
        return configuredParameters.length <= 2;
    }

    @Override
    public ODocument getResult() {
        ODocument res = (ODocument)this.context;
        this.context = null;
        return this.prepareResult(res);
    }

    protected ODocument prepareResult(ODocument res) {
        if (this.returnDistributedResult()) {
            ODocument doc = new ODocument();
            doc.field("node", this.getDistributedStorageId());
            doc.field("context", res);
            return doc;
        }
        return res;
    }

    @Override
    public Object mergeDistributedResult(List<Object> resultsToMerge) {
        if (this.returnDistributedResult()) {
            HashMap<String, Map> chunks = new HashMap<String, Map>();
            for (Object iParameter : resultsToMerge) {
                Map container = (Map)((Map)iParameter).get("doc");
                chunks.put((String)container.get("node"), (Map)container.get("context"));
            }
            HashMap result = new HashMap();
            for (Map chunk : chunks.values()) {
                result.putAll(chunk);
            }
            return result;
        }
        if (!resultsToMerge.isEmpty()) {
            return resultsToMerge.get(0);
        }
        return null;
    }
}

