/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.functions.text;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.method.misc.OAbstractSQLMethod;
import java.util.Map;

public class OSQLMethodToJSON
extends OAbstractSQLMethod {
    public static final String NAME = "tojson";

    public OSQLMethodToJSON() {
        super(NAME, 0, 1);
    }

    @Override
    public String getSyntax() {
        return "toJSON([<format>])";
    }

    @Override
    public Object execute(Object iThis, OIdentifiable iCurrentRecord, OCommandContext iContext, Object ioResult, Object[] iParams) {
        String format;
        if (iThis == null) {
            return null;
        }
        String string = format = iParams.length > 0 ? ((String)iParams[0]).replace("\"", "") : null;
        if (iThis instanceof ORecord) {
            ORecord record = (ORecord)iThis;
            return iParams.length == 1 ? record.toJSON(format) : record.toJSON();
        }
        if (iThis instanceof Map) {
            ODocument doc = new ODocument().fromMap((Map)iThis);
            return iParams.length == 1 ? doc.toJSON(format) : doc.toJSON();
        }
        if (OMultiValue.isMultiValue(iThis)) {
            StringBuilder builder = new StringBuilder();
            builder.append("[");
            boolean first = true;
            for (Object o : OMultiValue.getMultiValueIterable(iThis, false)) {
                if (!first) {
                    builder.append(",");
                }
                builder.append(this.execute(o, iCurrentRecord, iContext, ioResult, iParams));
                first = false;
            }
            builder.append("]");
            return builder.toString();
        }
        return null;
    }
}

