/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class OCollection
extends SimpleNode {
    protected List<OExpression> expressions = new ArrayList<OExpression>();

    public OCollection(int id) {
        super(id);
    }

    public OCollection(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        builder.append("[");
        boolean first = true;
        for (OExpression expr : this.expressions) {
            if (!first) {
                builder.append(", ");
            }
            expr.toString(params, builder);
            first = false;
        }
        builder.append("]");
    }

    public Object execute(OIdentifiable iCurrentRecord, OCommandContext ctx) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (OExpression exp : this.expressions) {
            result.add(exp.execute(iCurrentRecord, ctx));
        }
        return result;
    }
}

