/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.ORecordAttribute;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public class OSuffixIdentifier
extends SimpleNode {
    protected OIdentifier identifier;
    protected ORecordAttribute recordAttribute;
    protected boolean star = false;

    public OSuffixIdentifier(int id) {
        super(id);
    }

    public OSuffixIdentifier(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        if (this.identifier != null) {
            this.identifier.toString(params, builder);
        } else if (this.recordAttribute != null) {
            this.recordAttribute.toString(params, builder);
        } else if (this.star) {
            builder.append("*");
        }
    }

    public Object execute(OIdentifiable iCurrentRecord, OCommandContext ctx) {
        if (this.star) {
            return iCurrentRecord;
        }
        if (this.identifier != null) {
            String varName = this.identifier.getStringValue();
            if (ctx != null && ctx.getVariable(varName) != null) {
                return ctx.getVariable(varName);
            }
            if (iCurrentRecord != null) {
                return ((ODocument)iCurrentRecord.getRecord()).field(varName);
            }
            return null;
        }
        if (this.recordAttribute != null && iCurrentRecord != null) {
            return ((ODocument)iCurrentRecord.getRecord()).field(this.recordAttribute.name);
        }
        return null;
    }

    public Object execute(Object currentValue, OCommandContext ctx) {
        if (currentValue == null) {
            return null;
        }
        if (this.star) {
            return currentValue;
        }
        if (this.identifier != null) {
            String varName = this.identifier.getStringValue();
            if (ctx.getVariable(varName) != null) {
                return ctx.getVariable(varName);
            }
            if (currentValue instanceof OIdentifiable) {
                return ((ODocument)((OIdentifiable)currentValue).getRecord()).field(varName);
            }
            if (currentValue instanceof Map) {
                return ((Map)currentValue).get(varName);
            }
            if (OMultiValue.isMultiValue(currentValue)) {
                Iterator<Object> iterator = OMultiValue.getMultiValueIterator(currentValue);
                ArrayList<Object> result = new ArrayList<Object>();
                while (iterator.hasNext()) {
                    result.add(this.execute(iterator.next(), ctx));
                }
                return result;
            }
            throw new UnsupportedOperationException("Implement SuffixIdentifier!");
        }
        if (this.recordAttribute != null) {
            if (currentValue instanceof OIdentifiable) {
                return ((ODocument)((OIdentifiable)currentValue).getRecord()).field(this.recordAttribute.name);
            }
            if (currentValue instanceof Map) {
                return ((Map)currentValue).get(this.recordAttribute.name);
            }
            if (OMultiValue.isMultiValue(currentValue)) {
                Iterator<Object> iterator = OMultiValue.getMultiValueIterator(currentValue);
                ArrayList<Object> result = new ArrayList<Object>();
                while (iterator.hasNext()) {
                    result.add(this.execute(iterator.next(), ctx));
                }
                return result;
            }
            throw new UnsupportedOperationException("Implement SuffixIdentifier!");
        }
        return null;
    }

    public boolean isBaseIdentifier() {
        return this.identifier != null;
    }

    public OIdentifier getIdentifier() {
        return this.identifier;
    }
}

