/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.query;

import com.orientechnologies.common.util.OCommonConst;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OQueryParsingException;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.query.OQueryAbstract;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.OMemoryStream;
import com.orientechnologies.orient.core.serialization.OSerializableStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class OSQLQuery<T>
extends OQueryAbstract<T>
implements OCommandRequestText {
    protected String text;

    public OSQLQuery() {
    }

    public OSQLQuery(String iText) {
        this.text = iText.trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<T> run(Object ... iArgs) {
        ODatabaseDocumentInternal database = ODatabaseRecordThreadLocal.instance().get();
        if (database == null) {
            throw new OQueryParsingException("No database configured");
        }
        database.getMetadata().makeThreadLocalSchemaSnapshot();
        try {
            this.setParameters(iArgs);
            List list = (List)database.getStorage().command(this);
            return list;
        }
        finally {
            database.getMetadata().clearThreadLocalSchemaSnapshot();
        }
    }

    @Override
    public T runFirst(Object ... iArgs) {
        this.setLimit(1);
        List result = (List)this.execute(iArgs);
        return result != null && !result.isEmpty() ? (T)result.get(0) : null;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public OCommandRequestText setText(String iText) {
        this.text = iText;
        return this;
    }

    public String toString() {
        return "sql." + this.text;
    }

    @Override
    public OSerializableStream fromStream(byte[] iStream) throws OSerializationException {
        OMemoryStream buffer = new OMemoryStream(iStream);
        this.queryFromStream(buffer);
        return this;
    }

    @Override
    public byte[] toStream() throws OSerializationException {
        return this.queryToStream().toByteArray();
    }

    protected OMemoryStream queryToStream() {
        OMemoryStream buffer = new OMemoryStream();
        buffer.setUtf8(this.text);
        buffer.set(this.limit);
        buffer.setUtf8(this.fetchPlan != null ? this.fetchPlan : "");
        buffer.set(this.serializeQueryParameters(this.parameters));
        return buffer;
    }

    protected void queryFromStream(OMemoryStream buffer) {
        this.text = buffer.getAsString();
        this.limit = buffer.getAsInteger();
        this.setFetchPlan(buffer.getAsString());
        byte[] paramBuffer = buffer.getAsByteArray();
        this.parameters = this.deserializeQueryParameters(paramBuffer);
    }

    protected Map<Object, Object> deserializeQueryParameters(byte[] paramBuffer) {
        if (paramBuffer == null || paramBuffer.length == 0) {
            return Collections.emptyMap();
        }
        ODocument param = new ODocument();
        param.fromStream(paramBuffer);
        param.setFieldType("params", OType.EMBEDDEDMAP);
        Map params = (Map)param.rawField("params");
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        for (Map.Entry p : params.entrySet()) {
            if (Character.isDigit(((String)p.getKey()).charAt(0))) {
                result.put(Integer.parseInt((String)p.getKey()), p.getValue());
                continue;
            }
            result.put(p.getKey(), p.getValue());
        }
        return result;
    }

    protected byte[] serializeQueryParameters(Map<Object, Object> params) {
        if (params == null || params.size() == 0) {
            return OCommonConst.EMPTY_BYTE_ARRAY;
        }
        ODocument param = new ODocument();
        param.field("params", this.convertToRIDsIfPossible(params));
        return param.toStream();
    }

    private Map<Object, Object> convertToRIDsIfPossible(Map<Object, Object> params) {
        HashMap<Object, Object> newParams = new HashMap<Object, Object>(params.size());
        for (Map.Entry<Object, Object> entry : params.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof Set && !((Set)value).isEmpty() && ((Set)value).iterator().next() instanceof ORecord) {
                HashSet<ORID> newSet = new HashSet<ORID>();
                for (ORecord oRecord : (Set)value) {
                    newSet.add(oRecord.getIdentity());
                }
                newParams.put(entry.getKey(), newSet);
                continue;
            }
            if (value instanceof List && !((List)value).isEmpty() && ((List)value).get(0) instanceof ORecord) {
                ArrayList<ORID> newList = new ArrayList<ORID>();
                for (ORecord oRecord : (List)value) {
                    newList.add(oRecord.getIdentity());
                }
                newParams.put(entry.getKey(), newList);
                continue;
            }
            if (value instanceof Map && !((Map)value).isEmpty() && ((Map)value).values().iterator().next() instanceof ORecord) {
                HashMap newMap = new HashMap();
                for (Map.Entry entry2 : ((Map)value).entrySet()) {
                    newMap.put(entry2.getKey(), ((ORecord)entry2.getValue()).getIdentity());
                }
                newParams.put(entry.getKey(), newMap);
                continue;
            }
            if (value instanceof OIdentifiable) {
                newParams.put(entry.getKey(), ((OIdentifiable)value).getIdentity());
                continue;
            }
            newParams.put(entry.getKey(), value);
        }
        return newParams;
    }
}

