/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.query;

import com.orientechnologies.orient.core.command.OCommandResultListener;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.serialization.OMemoryStream;
import com.orientechnologies.orient.core.sql.query.OBasicResultSet;
import com.orientechnologies.orient.core.sql.query.OResultSet;
import com.orientechnologies.orient.core.sql.query.OSQLAsynchQuery;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class OSQLSynchQuery<T>
extends OSQLAsynchQuery<T>
implements OCommandResultListener,
Iterable<T> {
    private final OResultSet<T> result;
    private ORID nextPageRID;
    private Map<Object, Object> previousQueryParams = new HashMap<Object, Object>();

    public OSQLSynchQuery() {
        this.result = new OBasicResultSet(null);
        this.resultListener = this;
    }

    public OSQLSynchQuery(String iText) {
        super(iText);
        this.result = new OBasicResultSet(iText);
        this.resultListener = this;
    }

    public OSQLSynchQuery(String iText, int iLimit) {
        super(iText, iLimit, null);
        this.result = new OBasicResultSet(iText);
        this.resultListener = this;
    }

    @Override
    public void reset() {
        this.result.clear();
    }

    @Override
    public boolean result(Object iRecord) {
        if (iRecord != null) {
            this.result.add(iRecord);
        }
        return true;
    }

    @Override
    public void end() {
        this.result.setCompleted();
    }

    @Override
    public List<T> run(Object ... iArgs) {
        String currentThreadName = Thread.currentThread().getName();
        try {
            if (currentThreadName == null || !currentThreadName.contains("<query>") && !currentThreadName.contains("<command>")) {
                if (currentThreadName == null) {
                    currentThreadName = "";
                }
                try {
                    Thread.currentThread().setName(currentThreadName + " <query>" + this.getText() + "</query>");
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            this.result.clear();
            Map<Object, Object> queryParams = this.fetchQueryParams(iArgs);
            this.resetNextRIDIfParametersWereChanged(queryParams);
            List res = super.run(iArgs);
            if (res != this.result && res != null && this.result.isEmptyNoWait()) {
                for (Object item : res) {
                    this.result.add(item);
                }
            }
            this.result.setCompleted();
            if (!this.result.isEmpty()) {
                this.previousQueryParams = new HashMap<Object, Object>(queryParams);
                ORID lastRid = ((OIdentifiable)this.result.get(this.result.size() - 1)).getIdentity();
                this.nextPageRID = new ORecordId(lastRid.next());
            }
            try {
                Thread.currentThread().setName(currentThreadName);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            return this.result;
        }
        catch (RuntimeException e) {
            try {
                Thread.currentThread().setName(currentThreadName);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            throw e;
        }
    }

    @Override
    public boolean isIdempotent() {
        return true;
    }

    @Override
    public Object getResult() {
        return this.result;
    }

    public ORID getNextPageRID() {
        return this.nextPageRID;
    }

    public void resetPagination() {
        this.nextPageRID = null;
    }

    @Override
    public Iterator<T> iterator() {
        this.execute(new Object[0]);
        return ((Iterable)this.getResult()).iterator();
    }

    @Override
    public boolean isAsynchronous() {
        return false;
    }

    @Override
    protected OMemoryStream queryToStream() {
        OMemoryStream buffer = super.queryToStream();
        buffer.setUtf8(this.nextPageRID != null ? this.nextPageRID.toString() : "");
        byte[] queryParams = this.serializeQueryParameters(this.previousQueryParams);
        buffer.set(queryParams);
        return buffer;
    }

    @Override
    protected void queryFromStream(OMemoryStream buffer) {
        super.queryFromStream(buffer);
        String rid = buffer.getAsString();
        this.nextPageRID = "".equals(rid) ? null : new ORecordId(rid);
        byte[] serializedPrevParams = buffer.getAsByteArray();
        this.previousQueryParams = this.deserializeQueryParameters(serializedPrevParams);
    }

    private void resetNextRIDIfParametersWereChanged(Map<Object, Object> queryParams) {
        if (!queryParams.equals(this.previousQueryParams)) {
            this.nextPageRID = null;
        }
    }

    private Map<Object, Object> fetchQueryParams(Object ... iArgs) {
        if (iArgs != null && iArgs.length > 0) {
            return this.convertToParameters(iArgs);
        }
        Map<Object, Object> queryParams = this.getParameters();
        if (queryParams == null) {
            queryParams = new HashMap<Object, Object>();
        }
        return queryParams;
    }
}

