/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.base;

import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.cache.OCachePointer;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALChanges;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ODurablePage {
    public static final int MAGIC_NUMBER_OFFSET = 0;
    protected static final int CRC32_OFFSET = 8;
    public static final int WAL_SEGMENT_OFFSET = 12;
    public static final int WAL_POSITION_OFFSET = 20;
    public static final int MAX_PAGE_SIZE_BYTES = OGlobalConfiguration.DISK_CACHE_PAGE_SIZE.getValueAsInteger() * 1024;
    protected static final int NEXT_FREE_POSITION = 28;
    protected OWALChanges changes;
    private final OCacheEntry cacheEntry;
    private final OCachePointer pointer;

    public ODurablePage(OCacheEntry cacheEntry, OWALChanges changes) {
        assert (cacheEntry != null || changes != null);
        this.cacheEntry = cacheEntry;
        this.pointer = cacheEntry != null ? cacheEntry.getCachePointer() : null;
        this.changes = changes;
    }

    public static OLogSequenceNumber getLogSequenceNumberFromPage(ByteBuffer buffer) {
        buffer.position(12);
        long segment = buffer.getLong();
        long position = buffer.getLong();
        return new OLogSequenceNumber(segment, position);
    }

    public static void getPageData(ByteBuffer buffer, byte[] data, int offset, int length) {
        buffer.position(0);
        buffer.get(data, offset, length);
    }

    public static OLogSequenceNumber getLogSequenceNumber(int offset, byte[] data) {
        long segment = OLongSerializer.INSTANCE.deserializeNative(data, offset + 12);
        long position = OLongSerializer.INSTANCE.deserializeNative(data, offset + 20);
        return new OLogSequenceNumber(segment, position);
    }

    protected int getIntValue(int pageOffset) {
        assert (this.cacheEntry.isLockAcquiredByCurrentThread());
        if (this.changes == null) {
            ByteBuffer buffer = this.pointer.getExclusiveBuffer();
            return buffer.getInt(pageOffset);
        }
        ByteBuffer buffer = this.pointer.getBufferDuplicate();
        return this.changes.getIntValue(buffer, pageOffset);
    }

    protected long getLongValue(int pageOffset) {
        assert (this.cacheEntry.isLockAcquiredByCurrentThread());
        if (this.changes == null) {
            ByteBuffer buffer = this.pointer.getExclusiveBuffer();
            return buffer.getLong(pageOffset);
        }
        ByteBuffer buffer = this.pointer.getBufferDuplicate();
        return this.changes.getLongValue(buffer, pageOffset);
    }

    protected byte[] getBinaryValue(int pageOffset, int valLen) {
        assert (this.cacheEntry.isLockAcquiredByCurrentThread());
        ByteBuffer buffer = this.pointer.getBufferDuplicate();
        if (this.changes == null) {
            byte[] result = new byte[valLen];
            buffer.position(pageOffset);
            buffer.get(result);
            return result;
        }
        return this.changes.getBinaryValue(buffer, pageOffset, valLen);
    }

    protected int getObjectSizeInDirectMemory(OBinarySerializer binarySerializer, int offset) {
        assert (this.cacheEntry.isLockAcquiredByCurrentThread());
        ByteBuffer buffer = this.pointer.getBufferDuplicate();
        if (this.changes == null) {
            buffer.position(offset);
            return binarySerializer.getObjectSizeInByteBuffer(buffer);
        }
        return binarySerializer.getObjectSizeInByteBuffer(buffer, this.changes, offset);
    }

    protected <T> T deserializeFromDirectMemory(OBinarySerializer<T> binarySerializer, int offset) {
        assert (this.cacheEntry.isLockAcquiredByCurrentThread());
        ByteBuffer buffer = this.pointer.getBufferDuplicate();
        if (this.changes == null) {
            buffer.position(offset);
            return binarySerializer.deserializeFromByteBufferObject(buffer);
        }
        return binarySerializer.deserializeFromByteBufferObject(buffer, this.changes, offset);
    }

    protected byte getByteValue(int pageOffset) {
        assert (this.cacheEntry.isLockAcquiredByCurrentThread());
        if (this.changes == null) {
            ByteBuffer buffer = this.pointer.getExclusiveBuffer();
            return buffer.get(pageOffset);
        }
        ByteBuffer buffer = this.pointer.getBufferDuplicate();
        return this.changes.getByteValue(buffer, pageOffset);
    }

    protected int setIntValue(int pageOffset, int value) throws IOException {
        assert (this.cacheEntry.isLockAcquiredByCurrentThread());
        ByteBuffer buffer = this.pointer.getExclusiveBuffer();
        if (this.changes != null) {
            this.changes.setIntValue(buffer, value, pageOffset);
        } else {
            buffer.putInt(pageOffset, value);
            this.cacheEntry.markDirty();
        }
        return 4;
    }

    protected int setByteValue(int pageOffset, byte value) {
        assert (this.cacheEntry.isLockAcquiredByCurrentThread());
        ByteBuffer buffer = this.pointer.getExclusiveBuffer();
        if (this.changes != null) {
            this.changes.setByteValue(buffer, value, pageOffset);
        } else {
            buffer.put(pageOffset, value);
            this.cacheEntry.markDirty();
        }
        return 1;
    }

    protected int setLongValue(int pageOffset, long value) throws IOException {
        assert (this.cacheEntry.isLockAcquiredByCurrentThread());
        ByteBuffer buffer = this.pointer.getExclusiveBuffer();
        if (this.changes != null) {
            this.changes.setLongValue(buffer, value, pageOffset);
        } else {
            buffer.putLong(pageOffset, value);
            this.cacheEntry.markDirty();
        }
        return 8;
    }

    protected int setBinaryValue(int pageOffset, byte[] value) throws IOException {
        assert (this.cacheEntry.isLockAcquiredByCurrentThread());
        if (value.length == 0) {
            return 0;
        }
        ByteBuffer buffer = this.pointer.getExclusiveBuffer();
        if (this.changes != null) {
            this.changes.setBinaryValue(buffer, value, pageOffset);
        } else {
            buffer.position(pageOffset);
            buffer.put(value);
            this.cacheEntry.markDirty();
        }
        return value.length;
    }

    protected void moveData(int from, int to, int len) throws IOException {
        assert (this.cacheEntry.isLockAcquiredByCurrentThread());
        if (len == 0) {
            return;
        }
        ByteBuffer buffer = this.pointer.getExclusiveBuffer();
        if (this.changes != null) {
            this.changes.moveData(buffer, from, to, len);
        } else {
            ByteBuffer rb = buffer.asReadOnlyBuffer();
            rb.position(from);
            rb.limit(from + len);
            buffer.position(to);
            buffer.put(rb);
            this.cacheEntry.markDirty();
        }
    }

    public OWALChanges getChanges() {
        return this.changes;
    }

    public void restoreChanges(OWALChanges changes) {
        assert (this.cacheEntry.isLockAcquiredByCurrentThread());
        ByteBuffer buffer = this.cacheEntry.getCachePointer().getExclusiveBuffer();
        buffer.position(0);
        changes.applyChanges(buffer);
        this.cacheEntry.markDirty();
    }

    public OLogSequenceNumber getLsn() {
        assert (this.cacheEntry.isLockAcquiredByCurrentThread());
        long segment = this.getLongValue(12);
        long position = this.getLongValue(20);
        return new OLogSequenceNumber(segment, position);
    }

    public void setLsn(OLogSequenceNumber lsn) {
        assert (this.cacheEntry.isLockAcquiredByCurrentThread());
        ByteBuffer buffer = this.pointer.getExclusiveBuffer();
        buffer.position(12);
        buffer.putLong(lsn.getSegment());
        buffer.putLong(lsn.getPosition());
        this.cacheEntry.markDirty();
    }

    public String toString() {
        if (this.cacheEntry != null) {
            return this.getClass().getSimpleName() + "{fileId=" + this.cacheEntry.getFileId() + ", pageIndex=" + this.cacheEntry.getPageIndex() + '}';
        }
        return super.toString();
    }
}

