/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.statistic;

import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.impl.local.statistic.OClusterCountersHolder;
import com.orientechnologies.orient.core.storage.impl.local.statistic.OOperation;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;

public class OSessionStoragePerformanceStatistic {
    private static final int NANOS_IN_SECOND = 1000000000;
    private final Deque<Long> timeStamps = new ArrayDeque<Long>();
    private Deque<Component> componentsStack = new ArrayDeque<Component>();
    private final PerformanceCountersHolder performanceCountersHolder;
    private final NanoTimer nanoTimer;
    private final long intervalBetweenSnapshots;
    private final long cleanUpInterval;
    private long lastSnapshotTimestamp = -1L;
    private long lastCleanUpTimeStamp = -1L;
    private volatile PerformanceSnapshot snapshot;
    private Map<String, PerformanceCountersHolder> countersByComponent = new HashMap<String, PerformanceCountersHolder>();
    private WritCacheCountersHolder writCacheCountersHolder;
    private StorageCountersHolder storageCountersHolder;
    private WALCountersHolder walCountersHolder;

    public OSessionStoragePerformanceStatistic(long intervalBetweenSnapshots, long cleanUpInterval) {
        this(intervalBetweenSnapshots, new NanoTimer(){

            @Override
            public long getNano() {
                return System.nanoTime();
            }
        }, cleanUpInterval);
    }

    public OSessionStoragePerformanceStatistic(long intervalBetweenSnapshots, NanoTimer nanoTimer, long cleanUpInterval) {
        this.nanoTimer = nanoTimer;
        this.intervalBetweenSnapshots = intervalBetweenSnapshots;
        this.performanceCountersHolder = ComponentType.GENERAL.newCountersHolder();
        this.cleanUpInterval = cleanUpInterval;
        this.lastCleanUpTimeStamp = nanoTimer.getNano();
    }

    public void startComponentOperation(String componentName, ComponentType type) {
        Component currentComponent = this.componentsStack.peek();
        if (currentComponent != null && componentName.equals(currentComponent.name)) {
            currentComponent.operationCount++;
            return;
        }
        this.componentsStack.push(new Component(componentName, type));
    }

    public void completeComponentOperation() {
        Component currentComponent = this.componentsStack.peek();
        if (currentComponent == null) {
            return;
        }
        currentComponent.operationCount--;
        if (currentComponent.operationCount == 0) {
            String componentName = currentComponent.name;
            PerformanceCountersHolder cHolder = this.countersByComponent.get(componentName);
            if (cHolder == null) {
                cHolder = currentComponent.type.newCountersHolder();
                this.countersByComponent.put(componentName, cHolder);
            }
            cHolder.operationsCount++;
            this.componentsStack.pop();
            this.makeSnapshotIfNeeded(-1L);
        }
    }

    public long getReadSpeedFromCacheInPages() {
        return this.performanceCountersHolder.getReadSpeedFromCacheInPages();
    }

    public long getReadSpeedFromCacheInPages(String componentName) {
        if (componentName == null) {
            return this.performanceCountersHolder.getReadSpeedFromCacheInPages();
        }
        PerformanceCountersHolder cHolder = this.countersByComponent.get(componentName);
        if (cHolder != null) {
            return cHolder.getReadSpeedFromCacheInPages();
        }
        return -1L;
    }

    public long getReadSpeedFromFileInPages() {
        return this.performanceCountersHolder.getReadSpeedFromFileInPages();
    }

    public long getReadSpeedFromFileInPages(String componentName) {
        if (componentName == null) {
            return this.performanceCountersHolder.getReadSpeedFromFileInPages();
        }
        PerformanceCountersHolder cHolder = this.countersByComponent.get(componentName);
        if (cHolder != null) {
            return cHolder.getReadSpeedFromFileInPages();
        }
        return -1L;
    }

    public long getAmountOfPagesReadFromCache() {
        return this.performanceCountersHolder.getAmountOfPagesReadFromCache();
    }

    public long getAmountOfPagesReadFromCache(String componentName) {
        if (componentName == null) {
            return this.performanceCountersHolder.getAmountOfPagesReadFromCache();
        }
        PerformanceCountersHolder cHolder = this.countersByComponent.get(componentName);
        if (cHolder != null) {
            return cHolder.getAmountOfPagesReadFromCache();
        }
        return -1L;
    }

    public long getAmountOfPagesReadFromFile() {
        return this.performanceCountersHolder.getAmountOfPagesReadFromFile();
    }

    public long getAmountOfPagesReadFromFile(String componentName) {
        if (componentName == null) {
            return this.performanceCountersHolder.getAmountOfPagesReadFromFile();
        }
        PerformanceCountersHolder cHolder = this.countersByComponent.get(componentName);
        if (cHolder != null) {
            return cHolder.getAmountOfPagesReadFromFile();
        }
        return -1L;
    }

    public long getWriteSpeedInCacheInPages() {
        return this.performanceCountersHolder.getWriteSpeedInCacheInPages();
    }

    public long getWriteSpeedInCacheInPages(String componentName) {
        if (componentName == null) {
            return this.performanceCountersHolder.getWriteSpeedInCacheInPages();
        }
        PerformanceCountersHolder cHolder = this.countersByComponent.get(componentName);
        if (cHolder != null) {
            return cHolder.getWriteSpeedInCacheInPages();
        }
        return -1L;
    }

    public long getAmountOfPagesWrittenInCache() {
        return this.performanceCountersHolder.getAmountOfPagesWrittenInCache();
    }

    public long getAmountOfPagesWrittenInCache(String componentName) {
        if (componentName == null) {
            return this.performanceCountersHolder.getAmountOfPagesWrittenInCache();
        }
        PerformanceCountersHolder cHolder = this.countersByComponent.get(componentName);
        if (cHolder != null) {
            return cHolder.getAmountOfPagesWrittenInCache();
        }
        return -1L;
    }

    public PerformanceSnapshot getSnapshot() {
        return this.snapshot;
    }

    public long getCommitTime() {
        return this.performanceCountersHolder.getCommitTime();
    }

    public int getCacheHits() {
        return this.performanceCountersHolder.getCacheHits();
    }

    public int getCacheHits(String componentName) {
        if (componentName == null) {
            return this.performanceCountersHolder.getCacheHits();
        }
        PerformanceCountersHolder cHolder = this.countersByComponent.get(componentName);
        if (cHolder != null) {
            return cHolder.getCacheHits();
        }
        return -1;
    }

    public long getAmountOfPagesPerOperation(String componentName) {
        if (componentName == null) {
            return -1L;
        }
        PerformanceCountersHolder cHolder = this.countersByComponent.get(componentName);
        if (cHolder != null) {
            return cHolder.getAmountOfPagesPerOperation();
        }
        return -1L;
    }

    public void pushComponentCounters(Map<String, PerformanceCountersHolder> counters) {
        if (this.snapshot == null) {
            return;
        }
        for (Map.Entry<String, PerformanceCountersHolder> entry : this.snapshot.countersByComponent.entrySet()) {
            String componentName = entry.getKey();
            PerformanceCountersHolder holder = counters.get(componentName);
            if (holder == null) {
                holder = entry.getValue().newInstance();
                counters.put(componentName, holder);
            }
            entry.getValue().pushData(holder);
        }
    }

    public WritCacheCountersHolder pushWriteCacheCounters(WritCacheCountersHolder holder) {
        if (this.snapshot == null) {
            return holder;
        }
        if (this.snapshot.writCacheCountersHolder == null) {
            return holder;
        }
        if (holder == null) {
            holder = new WritCacheCountersHolder();
        }
        this.snapshot.writCacheCountersHolder.pushData(holder);
        return holder;
    }

    public StorageCountersHolder pushStorageCounters(StorageCountersHolder holder) {
        if (this.snapshot == null) {
            return holder;
        }
        if (this.snapshot.storageCountersHolder == null) {
            return holder;
        }
        if (holder == null) {
            holder = new StorageCountersHolder();
        }
        this.snapshot.storageCountersHolder.pushData(holder);
        return holder;
    }

    public WALCountersHolder pushWALCounters(WALCountersHolder holder) {
        if (this.snapshot == null) {
            return holder;
        }
        if (this.snapshot.walCountersHolder == null) {
            return holder;
        }
        if (holder == null) {
            holder = new WALCountersHolder();
        }
        this.snapshot.walCountersHolder.pushData(holder);
        return holder;
    }

    public void pushSystemCounters(PerformanceCountersHolder holder) {
        if (this.snapshot == null) {
            return;
        }
        this.snapshot.performanceCountersHolder.pushData(holder);
    }

    public void pushComponentCounters(String name, PerformanceCountersHolder holder) {
        if (this.snapshot == null) {
            return;
        }
        PerformanceCountersHolder countersHolder = this.snapshot.countersByComponent.get(name);
        if (countersHolder != null) {
            countersHolder.pushData(holder);
        }
    }

    public ODocument toDocument() {
        ODocument document = this.performanceCountersHolder.toDocument();
        document.field("commitTime", this.getCommitTime(), OType.LONG);
        HashMap<String, ODocument> countersMap = new HashMap<String, ODocument>();
        for (Map.Entry<String, PerformanceCountersHolder> entry : this.countersByComponent.entrySet()) {
            countersMap.put(entry.getKey(), entry.getValue().toDocument());
        }
        document.field("dataByComponent", countersMap, OType.EMBEDDEDMAP);
        if (this.walCountersHolder != null) {
            ODocument wal = this.walCountersHolder.toDocument();
            document.field("walData", wal, OType.EMBEDDED);
        }
        return document;
    }

    public void incrementPageAccessOnCacheLevel(boolean cacheHit) {
        this.performanceCountersHolder.cacheAccessCount++;
        if (cacheHit) {
            this.performanceCountersHolder.cacheHit++;
        }
        for (Component component : this.componentsStack) {
            String componentName = component.name;
            PerformanceCountersHolder cHolder = this.countersByComponent.get(componentName);
            if (cHolder == null) {
                cHolder = component.type.newCountersHolder();
                this.countersByComponent.put(componentName, cHolder);
            }
            cHolder.cacheAccessCount++;
            if (!cacheHit) continue;
            cHolder.cacheHit++;
        }
        this.makeSnapshotIfNeeded(-1L);
    }

    public void startPageReadFromFileTimer() {
        this.pushTimer();
    }

    public void stopPageReadFromFileTimer(int readPages) {
        PerformanceCountersHolder currentHolder;
        long endTs = this.nanoTimer.getNano();
        long timeDiff = endTs - this.timeStamps.pop();
        Object object = this.performanceCountersHolder;
        ((PerformanceCountersHolder)object).pageReadFromFileTime = ((PerformanceCountersHolder)object).pageReadFromFileTime + timeDiff;
        object = this.performanceCountersHolder;
        ((PerformanceCountersHolder)object).pageReadFromFileCount = ((PerformanceCountersHolder)object).pageReadFromFileCount + (long)readPages;
        for (Component component : this.componentsStack) {
            String componentName = component.name;
            PerformanceCountersHolder cHolder = this.countersByComponent.get(componentName);
            if (cHolder == null) {
                cHolder = component.type.newCountersHolder();
                this.countersByComponent.put(componentName, cHolder);
            }
            PerformanceCountersHolder performanceCountersHolder = cHolder;
            performanceCountersHolder.pageReadFromFileTime = performanceCountersHolder.pageReadFromFileTime + timeDiff;
            performanceCountersHolder = cHolder;
            performanceCountersHolder.pageReadFromFileCount = performanceCountersHolder.pageReadFromFileCount + (long)readPages;
        }
        Component currentComponent = this.componentsStack.peek();
        if (currentComponent != null && (currentHolder = this.countersByComponent.get(currentComponent.name)).currentOperation != null) {
            currentHolder.currentOperation.incrementOperationsCounter(0, readPages);
        }
        this.makeSnapshotIfNeeded(endTs);
    }

    public void startWriteCacheFlushTimer() {
        this.pushTimer();
    }

    public void stopWriteCacheFlushTimer(int pagesFlushed) {
        if (this.writCacheCountersHolder == null) {
            this.writCacheCountersHolder = new WritCacheCountersHolder();
        }
        long endTs = this.nanoTimer.getNano();
        long timeDiff = endTs - this.timeStamps.pop();
        this.writCacheCountersHolder.flushOperationsCount++;
        WritCacheCountersHolder writCacheCountersHolder = this.writCacheCountersHolder;
        writCacheCountersHolder.amountOfPagesFlushed = writCacheCountersHolder.amountOfPagesFlushed + (long)pagesFlushed;
        writCacheCountersHolder = this.writCacheCountersHolder;
        writCacheCountersHolder.flushOperationsTime = writCacheCountersHolder.flushOperationsTime + timeDiff;
        this.makeSnapshotIfNeeded(endTs);
    }

    public void startFuzzyCheckpointTimer() {
        this.pushTimer();
    }

    public void stopFuzzyCheckpointTimer() {
        if (this.writCacheCountersHolder == null) {
            this.writCacheCountersHolder = new WritCacheCountersHolder();
        }
        long endTs = this.nanoTimer.getNano();
        long timeDiff = endTs - this.timeStamps.pop();
        this.writCacheCountersHolder.fuzzyCheckpointCount++;
        WritCacheCountersHolder writCacheCountersHolder = this.writCacheCountersHolder;
        writCacheCountersHolder.fuzzyCheckpointTime = writCacheCountersHolder.fuzzyCheckpointTime + timeDiff;
        this.makeSnapshotIfNeeded(endTs);
    }

    public void startPageReadFromCacheTimer() {
        this.pushTimer();
    }

    private void pushTimer() {
        this.timeStamps.push(this.nanoTimer.getNano());
    }

    public void stopPageReadFromCacheTimer() {
        PerformanceCountersHolder currentHolder;
        long endTs = this.nanoTimer.getNano();
        long timeDiff = endTs - this.timeStamps.pop();
        PerformanceCountersHolder performanceCountersHolder = this.performanceCountersHolder;
        performanceCountersHolder.pageReadFromCacheTime = performanceCountersHolder.pageReadFromCacheTime + timeDiff;
        this.performanceCountersHolder.pageReadFromCacheCount++;
        for (Component component : this.componentsStack) {
            String componentName = component.name;
            PerformanceCountersHolder cHolder = this.countersByComponent.get(componentName);
            if (cHolder == null) {
                cHolder = component.type.newCountersHolder();
                this.countersByComponent.put(componentName, cHolder);
            }
            PerformanceCountersHolder performanceCountersHolder2 = cHolder;
            performanceCountersHolder2.pageReadFromCacheTime = performanceCountersHolder2.pageReadFromCacheTime + timeDiff;
            cHolder.pageReadFromCacheCount++;
        }
        Component currentComponent = this.componentsStack.peek();
        if (currentComponent != null && (currentHolder = this.countersByComponent.get(currentComponent.name)).currentOperation != null) {
            currentHolder.currentOperation.incrementOperationsCounter(1, 0);
        }
        this.makeSnapshotIfNeeded(endTs);
    }

    public void startFullCheckpointTimer() {
        this.pushTimer();
    }

    public void stopFullCheckpointTimer() {
        long endTs = this.nanoTimer.getNano();
        long timeDiff = endTs - this.timeStamps.pop();
        if (this.storageCountersHolder == null) {
            this.storageCountersHolder = new StorageCountersHolder();
        }
        this.storageCountersHolder.fullCheckpointOperationsCount++;
        StorageCountersHolder storageCountersHolder = this.storageCountersHolder;
        storageCountersHolder.fullCheckpointOperationsTime = storageCountersHolder.fullCheckpointOperationsTime + timeDiff;
        this.makeSnapshotIfNeeded(endTs);
    }

    public void startPageWriteInCacheTimer() {
        this.pushTimer();
    }

    public void stopPageWriteInCacheTimer() {
        long endTs = this.nanoTimer.getNano();
        long timeDiff = endTs - this.timeStamps.pop();
        PerformanceCountersHolder performanceCountersHolder = this.performanceCountersHolder;
        performanceCountersHolder.pageWriteToCacheTime = performanceCountersHolder.pageWriteToCacheTime + timeDiff;
        this.performanceCountersHolder.pageWriteToCacheCount++;
        for (Component component : this.componentsStack) {
            String componentName = component.name;
            PerformanceCountersHolder cHolder = this.countersByComponent.get(componentName);
            if (cHolder == null) {
                cHolder = component.type.newCountersHolder();
                this.countersByComponent.put(componentName, cHolder);
            }
            PerformanceCountersHolder performanceCountersHolder2 = cHolder;
            performanceCountersHolder2.pageWriteToCacheTime = performanceCountersHolder2.pageWriteToCacheTime + timeDiff;
            cHolder.pageWriteToCacheCount++;
        }
        this.makeSnapshotIfNeeded(endTs);
    }

    public void startRecordCreationTimer() {
        this.pushTimer();
    }

    public void stopRecordCreationTimer() {
        Component component = this.componentsStack.peek();
        this.checkComponentType(component, ComponentType.CLUSTER);
        long endTs = this.nanoTimer.getNano();
        long timeDiff = endTs - this.timeStamps.pop();
        OClusterCountersHolder cHolder = (OClusterCountersHolder)this.countersByComponent.get(component.name);
        if (cHolder == null) {
            cHolder = (OClusterCountersHolder)ComponentType.CLUSTER.newCountersHolder();
            this.countersByComponent.put(component.name, cHolder);
        }
        ++cHolder.createdRecords;
        cHolder.timeRecordCreation += timeDiff;
        this.makeSnapshotIfNeeded(endTs);
    }

    public void startRecordDeletionTimer() {
        this.pushTimer();
    }

    public void stopRecordDeletionTimer() {
        Component component = this.componentsStack.peek();
        this.checkComponentType(component, ComponentType.CLUSTER);
        long endTs = this.nanoTimer.getNano();
        long timeDiff = endTs - this.timeStamps.pop();
        OClusterCountersHolder cHolder = (OClusterCountersHolder)this.countersByComponent.get(component.name);
        if (cHolder == null) {
            cHolder = (OClusterCountersHolder)ComponentType.CLUSTER.newCountersHolder();
            this.countersByComponent.put(component.name, cHolder);
        }
        ++cHolder.deletedRecords;
        cHolder.timeRecordDeletion += timeDiff;
        this.makeSnapshotIfNeeded(endTs);
    }

    public void startRecordUpdateTimer() {
        this.pushTimer();
    }

    public void stopRecordUpdateTimer() {
        Component component = this.componentsStack.peek();
        this.checkComponentType(component, ComponentType.CLUSTER);
        long endTs = this.nanoTimer.getNano();
        long timeDiff = endTs - this.timeStamps.pop();
        OClusterCountersHolder cHolder = (OClusterCountersHolder)this.countersByComponent.get(component.name);
        if (cHolder == null) {
            cHolder = (OClusterCountersHolder)ComponentType.CLUSTER.newCountersHolder();
            this.countersByComponent.put(component.name, cHolder);
        }
        ++cHolder.updatedRecords;
        cHolder.timeRecordUpdate += timeDiff;
        this.makeSnapshotIfNeeded(endTs);
    }

    public void startRecordReadTimer() {
        this.pushTimer();
    }

    public void stopRecordReadTimer() {
        Component component = this.componentsStack.peek();
        this.checkComponentType(component, ComponentType.CLUSTER);
        long endTs = this.nanoTimer.getNano();
        long timeDiff = endTs - this.timeStamps.pop();
        OClusterCountersHolder cHolder = (OClusterCountersHolder)this.countersByComponent.get(component.name);
        if (cHolder == null) {
            cHolder = (OClusterCountersHolder)ComponentType.CLUSTER.newCountersHolder();
            this.countersByComponent.put(component.name, cHolder);
        }
        ++cHolder.readRecords;
        cHolder.timeRecordRead += timeDiff;
        this.makeSnapshotIfNeeded(endTs);
    }

    public void startIndexEntryUpdateTimer() {
        this.pushTimer();
    }

    public void stopIndexEntryUpdateTimer() {
        Component component = this.componentsStack.peek();
        this.checkComponentType(component, ComponentType.INDEX);
        long endTs = this.nanoTimer.getNano();
        long timeDiff = endTs - this.timeStamps.pop();
        IndexCountersHolder cHolder = (IndexCountersHolder)this.countersByComponent.get(component.name);
        if (cHolder == null) {
            cHolder = (IndexCountersHolder)ComponentType.INDEX.newCountersHolder();
            this.countersByComponent.put(component.name, cHolder);
        }
        cHolder.updatedEntries++;
        IndexCountersHolder indexCountersHolder = cHolder;
        indexCountersHolder.timeUpdateEntry = indexCountersHolder.timeUpdateEntry + timeDiff;
        this.makeSnapshotIfNeeded(endTs);
    }

    public void startIndexEntryDeletionTimer() {
        this.pushTimer();
    }

    public void stopIndexEntryDeletionTimer() {
        Component component = this.componentsStack.peek();
        this.checkComponentType(component, ComponentType.INDEX);
        long endTs = this.nanoTimer.getNano();
        long timeDiff = endTs - this.timeStamps.pop();
        IndexCountersHolder cHolder = (IndexCountersHolder)this.countersByComponent.get(component.name);
        if (cHolder == null) {
            cHolder = (IndexCountersHolder)ComponentType.INDEX.newCountersHolder();
            this.countersByComponent.put(component.name, cHolder);
        }
        cHolder.deletedEntries++;
        IndexCountersHolder indexCountersHolder = cHolder;
        indexCountersHolder.timeDeleteEntry = indexCountersHolder.timeDeleteEntry + timeDiff;
        this.makeSnapshotIfNeeded(endTs);
    }

    public void startIndexEntryReadTimer() {
        this.pushTimer();
    }

    public void stopIndexEntryReadTimer() {
        Component component = this.componentsStack.peek();
        this.checkComponentType(component, ComponentType.INDEX);
        long endTs = this.nanoTimer.getNano();
        long timeDiff = endTs - this.timeStamps.pop();
        IndexCountersHolder cHolder = (IndexCountersHolder)this.countersByComponent.get(component.name);
        if (cHolder == null) {
            cHolder = (IndexCountersHolder)ComponentType.INDEX.newCountersHolder();
            this.countersByComponent.put(component.name, cHolder);
        }
        cHolder.readEntries++;
        IndexCountersHolder indexCountersHolder = cHolder;
        indexCountersHolder.timeReadEntry = indexCountersHolder.timeReadEntry + timeDiff;
        this.makeSnapshotIfNeeded(endTs);
    }

    public void startRidBagEntryReadTimer() {
        this.pushTimer();
    }

    public void stopRidBagEntryReadTimer(int entriesRead) {
        Component component = this.componentsStack.peek();
        this.checkComponentType(component, ComponentType.RIDBAG);
        long endTs = this.nanoTimer.getNano();
        long timeDiff = endTs - this.timeStamps.pop();
        RidbagCountersHolder cHolder = (RidbagCountersHolder)this.countersByComponent.get(component.name);
        if (cHolder == null) {
            cHolder = (RidbagCountersHolder)ComponentType.INDEX.newCountersHolder();
            this.countersByComponent.put(component.name, cHolder);
        }
        RidbagCountersHolder ridbagCountersHolder = cHolder;
        ridbagCountersHolder.readEntries = ridbagCountersHolder.readEntries + (long)entriesRead;
        ridbagCountersHolder = cHolder;
        ridbagCountersHolder.timeReadEntry = ridbagCountersHolder.timeReadEntry + timeDiff;
        this.makeSnapshotIfNeeded(endTs);
    }

    public void startRidBagEntryUpdateTimer() {
        this.pushTimer();
    }

    public void stopRidBagEntryUpdateTimer() {
        Component component = this.componentsStack.peek();
        this.checkComponentType(component, ComponentType.RIDBAG);
        long endTs = this.nanoTimer.getNano();
        long timeDiff = endTs - this.timeStamps.pop();
        RidbagCountersHolder cHolder = (RidbagCountersHolder)this.countersByComponent.get(component.name);
        if (cHolder == null) {
            cHolder = (RidbagCountersHolder)ComponentType.INDEX.newCountersHolder();
            this.countersByComponent.put(component.name, cHolder);
        }
        cHolder.updatedEntries++;
        RidbagCountersHolder ridbagCountersHolder = cHolder;
        ridbagCountersHolder.timeUpdateEntry = ridbagCountersHolder.timeUpdateEntry + timeDiff;
        this.makeSnapshotIfNeeded(endTs);
    }

    public void startRidBagEntryDeletionTimer() {
        this.pushTimer();
    }

    public void stopRidBagEntryDeletionTimer() {
        Component component = this.componentsStack.peek();
        this.checkComponentType(component, ComponentType.RIDBAG);
        long endTs = this.nanoTimer.getNano();
        long timeDiff = endTs - this.timeStamps.pop();
        RidbagCountersHolder cHolder = (RidbagCountersHolder)this.countersByComponent.get(component.name);
        if (cHolder == null) {
            cHolder = (RidbagCountersHolder)ComponentType.INDEX.newCountersHolder();
            this.countersByComponent.put(component.name, cHolder);
        }
        cHolder.deletedEntries++;
        RidbagCountersHolder ridbagCountersHolder = cHolder;
        ridbagCountersHolder.timeDeleteEntry = ridbagCountersHolder.timeDeleteEntry + timeDiff;
        this.makeSnapshotIfNeeded(endTs);
    }

    public void startRidBagEntryLoadTimer() {
        this.pushTimer();
    }

    public void stopRidBagEntryLoadTimer() {
        Component component = this.componentsStack.peek();
        this.checkComponentType(component, ComponentType.RIDBAG);
        long endTs = this.nanoTimer.getNano();
        long timeDiff = endTs - this.timeStamps.pop();
        RidbagCountersHolder cHolder = (RidbagCountersHolder)this.countersByComponent.get(component.name);
        if (cHolder == null) {
            cHolder = (RidbagCountersHolder)ComponentType.INDEX.newCountersHolder();
            this.countersByComponent.put(component.name, cHolder);
        }
        cHolder.loads++;
        RidbagCountersHolder ridbagCountersHolder = cHolder;
        ridbagCountersHolder.loadTime = ridbagCountersHolder.loadTime + timeDiff;
        this.makeSnapshotIfNeeded(endTs);
    }

    public void startCommitTimer() {
        this.pushTimer();
    }

    public void stopCommitTimer() {
        long endTs = this.nanoTimer.getNano();
        long timeDiff = endTs - this.timeStamps.pop();
        PerformanceCountersHolder performanceCountersHolder = this.performanceCountersHolder;
        performanceCountersHolder.commitTime = performanceCountersHolder.commitTime + timeDiff;
        this.performanceCountersHolder.commitCount++;
        this.makeSnapshotIfNeeded(endTs);
    }

    public void startWALLogRecordTimer() {
        this.pushTimer();
    }

    public void stopWALRecordTimer(boolean isStartRecord, boolean isStopRecord) {
        long endTs = this.nanoTimer.getNano();
        long timeDiff = endTs - this.timeStamps.pop();
        if (this.walCountersHolder == null) {
            this.walCountersHolder = new WALCountersHolder();
        }
        this.walCountersHolder.logRecordCount++;
        WALCountersHolder wALCountersHolder = this.walCountersHolder;
        wALCountersHolder.logRecordTime = wALCountersHolder.logRecordTime + timeDiff;
        if (isStartRecord) {
            this.walCountersHolder.startRecordCount++;
            wALCountersHolder = this.walCountersHolder;
            wALCountersHolder.startRecordTime = wALCountersHolder.startRecordTime + timeDiff;
        } else if (isStopRecord) {
            this.walCountersHolder.stopRecordCount++;
            wALCountersHolder = this.walCountersHolder;
            wALCountersHolder.stopRecordTime = wALCountersHolder.stopRecordTime + timeDiff;
        }
        this.makeSnapshotIfNeeded(endTs);
    }

    public void startWALFlushTimer() {
        this.pushTimer();
    }

    public void stopWALFlushTimer() {
        long endTs = this.nanoTimer.getNano();
        long timeDiff = endTs - this.timeStamps.pop();
        if (this.walCountersHolder == null) {
            this.walCountersHolder = new WALCountersHolder();
        }
        this.walCountersHolder.flushCount++;
        WALCountersHolder wALCountersHolder = this.walCountersHolder;
        wALCountersHolder.flushTime = wALCountersHolder.flushTime + timeDiff;
        this.makeSnapshotIfNeeded(endTs);
    }

    private void checkComponentType(Component component, ComponentType expected) {
        if (!component.type.equals((Object)expected)) {
            throw new IllegalStateException("Invalid component type , required " + (Object)((Object)expected) + " but found " + (Object)((Object)component.type));
        }
    }

    private void makeSnapshotIfNeeded(long currentTime) {
        if (currentTime < 0L) {
            currentTime = this.nanoTimer.getNano();
        }
        if (this.lastSnapshotTimestamp == -1L) {
            this.lastSnapshotTimestamp = 0L;
        }
        if (this.lastSnapshotTimestamp < 0L || currentTime - this.lastSnapshotTimestamp >= this.intervalBetweenSnapshots) {
            this.snapshot = new PerformanceSnapshot(this.performanceCountersHolder, this.countersByComponent, this.writCacheCountersHolder, this.storageCountersHolder, this.walCountersHolder);
            this.lastSnapshotTimestamp = currentTime;
        }
        if (this.cleanUpInterval > 0L && currentTime - this.lastCleanUpTimeStamp >= this.cleanUpInterval) {
            this.performanceCountersHolder.clean();
            for (PerformanceCountersHolder pch : this.countersByComponent.values()) {
                pch.clean();
            }
            if (this.writCacheCountersHolder != null) {
                this.writCacheCountersHolder.clean();
            }
            if (this.storageCountersHolder != null) {
                this.storageCountersHolder.clean();
            }
            if (this.writCacheCountersHolder != null) {
                this.walCountersHolder.clean();
            }
            this.lastCleanUpTimeStamp = currentTime;
        }
    }

    public static void writeMetric(ODocument document, String metricName, Number metricValue) {
        OSessionStoragePerformanceStatistic.writeMetric(document, metricName, metricValue, OType.LONG);
    }

    public static void writeMetric(ODocument document, String metricName, Number metricValue, OType metricType) {
        if (metricValue.longValue() != -1L) {
            document.field(metricName, metricValue, metricType);
        }
    }

    public static interface CountersHolder<T extends CountersHolder> {
        public void clean();

        public void pushData(T var1);

        public ODocument toDocument();
    }

    public static final class PerformanceSnapshot {
        public final PerformanceCountersHolder performanceCountersHolder;
        public final WritCacheCountersHolder writCacheCountersHolder;
        public final StorageCountersHolder storageCountersHolder;
        public final WALCountersHolder walCountersHolder;
        public final Map<String, PerformanceCountersHolder> countersByComponent;

        PerformanceSnapshot(PerformanceCountersHolder performanceCountersHolder, Map<String, PerformanceCountersHolder> countersByComponent, WritCacheCountersHolder writCacheCountersHolder, StorageCountersHolder storageCountersHolder, WALCountersHolder walCountersHolder) {
            this.performanceCountersHolder = performanceCountersHolder.newInstance();
            performanceCountersHolder.pushData(this.performanceCountersHolder);
            HashMap<String, PerformanceCountersHolder> counters = new HashMap<String, PerformanceCountersHolder>();
            for (Map.Entry<String, PerformanceCountersHolder> entry : countersByComponent.entrySet()) {
                PerformanceCountersHolder holder = entry.getValue().newInstance();
                entry.getValue().pushData(holder);
                counters.put(entry.getKey(), holder);
            }
            this.countersByComponent = counters;
            if (writCacheCountersHolder != null) {
                WritCacheCountersHolder wh = new WritCacheCountersHolder();
                writCacheCountersHolder.pushData(wh);
                this.writCacheCountersHolder = wh;
            } else {
                this.writCacheCountersHolder = null;
            }
            if (storageCountersHolder != null) {
                StorageCountersHolder sch = new StorageCountersHolder();
                storageCountersHolder.pushData(sch);
                this.storageCountersHolder = sch;
            } else {
                this.storageCountersHolder = null;
            }
            if (walCountersHolder != null) {
                WALCountersHolder wch = new WALCountersHolder();
                walCountersHolder.pushData(wch);
                this.walCountersHolder = wch;
            } else {
                this.walCountersHolder = null;
            }
        }
    }

    public static class PerformanceCountersHolder
    implements CountersHolder<PerformanceCountersHolder> {
        private long commitCount = 0L;
        private long commitTime = 0L;
        private long operationsCount = 0L;
        private long cacheAccessCount = 0L;
        private long cacheHit = 0L;
        private long pageReadFromFileTime = 0L;
        private long pageReadFromFileCount = 0L;
        private long pageReadFromCacheTime = 0L;
        private long pageReadFromCacheCount = 0L;
        private long pageWriteToCacheTime = 0L;
        private long pageWriteToCacheCount = 0L;
        private OOperation currentOperation;

        @Override
        public void clean() {
            this.commitCount = 0L;
            this.commitTime = 0L;
            this.operationsCount = 0L;
            this.cacheAccessCount = 0L;
            this.cacheHit = 0L;
            this.pageReadFromFileTime = 0L;
            this.pageReadFromFileCount = 0L;
            this.pageReadFromCacheTime = 0L;
            this.pageReadFromCacheCount = 0L;
            this.pageWriteToCacheTime = 0L;
            this.pageWriteToCacheCount = 0L;
        }

        @Override
        public void pushData(PerformanceCountersHolder aggregator) {
            aggregator.operationsCount += this.operationsCount;
            aggregator.cacheAccessCount += this.cacheAccessCount;
            aggregator.cacheHit += this.cacheHit;
            aggregator.pageReadFromFileTime += this.pageReadFromFileTime;
            aggregator.pageReadFromFileCount += this.pageReadFromFileCount;
            aggregator.pageReadFromCacheTime += this.pageReadFromCacheTime;
            aggregator.pageReadFromCacheCount += this.pageReadFromCacheCount;
            aggregator.pageWriteToCacheTime += this.pageWriteToCacheTime;
            aggregator.pageWriteToCacheCount += this.pageWriteToCacheCount;
            aggregator.commitTime += this.commitTime;
            aggregator.commitCount += this.commitCount;
        }

        public long getCommitTime() {
            if (this.commitCount == 0L) {
                return -1L;
            }
            return this.commitTime / this.commitCount;
        }

        public long getReadSpeedFromCacheInPages() {
            if (this.pageReadFromCacheTime == 0L) {
                return -1L;
            }
            return this.pageReadFromCacheCount * 1000000000L / this.pageReadFromCacheTime;
        }

        public long getReadSpeedFromFileInPages() {
            if (this.pageReadFromFileTime == 0L) {
                return -1L;
            }
            return this.pageReadFromFileCount * 1000000000L / this.pageReadFromFileTime;
        }

        public long getAmountOfPagesReadFromCache() {
            return this.pageReadFromCacheCount;
        }

        public long getAmountOfPagesReadFromFile() {
            return this.pageReadFromFileCount;
        }

        public long getWriteSpeedInCacheInPages() {
            if (this.pageWriteToCacheTime == 0L) {
                return -1L;
            }
            return this.pageWriteToCacheCount * 1000000000L / this.pageWriteToCacheTime;
        }

        public long getAmountOfPagesWrittenInCache() {
            return this.pageWriteToCacheCount;
        }

        public int getCacheHits() {
            if (this.cacheAccessCount == 0L) {
                return -1;
            }
            return (int)(this.cacheHit * 100L / this.cacheAccessCount);
        }

        public long getAmountOfPagesPerOperation() {
            if (this.operationsCount == 0L) {
                return -1L;
            }
            return this.pageReadFromCacheCount / this.operationsCount;
        }

        @Override
        public ODocument toDocument() {
            ODocument document = new ODocument();
            OSessionStoragePerformanceStatistic.writeMetric(document, "readSpeedFromCacheInPages", this.getReadSpeedFromCacheInPages(), OType.LONG);
            OSessionStoragePerformanceStatistic.writeMetric(document, "readSpeedFromFileInPages", this.getReadSpeedFromFileInPages(), OType.LONG);
            OSessionStoragePerformanceStatistic.writeMetric(document, "amountOfPagesReadFromCache", this.getAmountOfPagesReadFromCache(), OType.LONG);
            OSessionStoragePerformanceStatistic.writeMetric(document, "writeSpeedInCacheInPages", this.getWriteSpeedInCacheInPages(), OType.LONG);
            OSessionStoragePerformanceStatistic.writeMetric(document, "amountOfPagesWrittenInCache", this.getAmountOfPagesWrittenInCache(), OType.LONG);
            OSessionStoragePerformanceStatistic.writeMetric(document, "amountOfPagesReadFromFile", this.getAmountOfPagesReadFromFile(), OType.LONG);
            OSessionStoragePerformanceStatistic.writeMetric(document, "cacheHits", this.getCacheHits(), OType.INTEGER);
            OSessionStoragePerformanceStatistic.writeMetric(document, "amountOfPagesPerOperation", this.getAmountOfPagesPerOperation(), OType.LONG);
            OSessionStoragePerformanceStatistic.writeMetric(document, "commitTime", this.getCommitTime(), OType.LONG);
            return document;
        }

        public PerformanceCountersHolder newInstance() {
            return new PerformanceCountersHolder();
        }
    }

    public static class RidbagCountersHolder
    extends PerformanceCountersHolder {
        private long updatedEntries;
        private long timeUpdateEntry;
        private long updateEntryPages;
        private long updateEntryFilePages;
        private long deletedEntries;
        private long timeDeleteEntry;
        private long deleteEntryPages;
        private long deleteEntryFilePages;
        private long readEntries;
        private long timeReadEntry;
        private long readEntryPages;
        private long readEntryFilePages;
        private long loads;
        private long loadTime;
        private long loadPages;
        private long loadFilePages;

        @Override
        public PerformanceCountersHolder newInstance() {
            return new RidbagCountersHolder();
        }

        @Override
        public void clean() {
            super.clean();
            this.updatedEntries = 0L;
            this.timeUpdateEntry = 0L;
            this.updateEntryPages = 0L;
            this.updateEntryFilePages = 0L;
            this.deletedEntries = 0L;
            this.timeDeleteEntry = 0L;
            this.deleteEntryPages = 0L;
            this.deleteEntryFilePages = 0L;
            this.readEntries = 0L;
            this.timeReadEntry = 0L;
            this.readEntryPages = 0L;
            this.readEntryFilePages = 0L;
            this.loads = 0L;
            this.loadTime = 0L;
            this.loadPages = 0L;
            this.loadFilePages = 0L;
        }

        public long getUpdateEntryTime() {
            if (this.updatedEntries == 0L) {
                return -1L;
            }
            return this.timeUpdateEntry / this.updatedEntries;
        }

        public long getUpdateEntryPages() {
            if (this.updatedEntries == 0L) {
                return -1L;
            }
            return this.updateEntryPages / this.updatedEntries;
        }

        public long getDeleteEntryTime() {
            if (this.deletedEntries == 0L) {
                return -1L;
            }
            return this.timeDeleteEntry / this.deletedEntries;
        }

        public long getDeleteEntryPages() {
            if (this.deletedEntries == 0L) {
                return -1L;
            }
            return this.deleteEntryPages / this.deletedEntries;
        }

        public long getReadEntryTime() {
            if (this.timeReadEntry == 0L) {
                return -1L;
            }
            return this.timeReadEntry / this.readEntries;
        }

        public long getReadEntryPages() {
            if (this.readEntries == 0L) {
                return -1L;
            }
            return this.readEntryPages / this.readEntries;
        }

        public long getLoadTime() {
            return this.loadTime / this.loads;
        }

        public long getLoadPages() {
            if (this.loads == 0L) {
                return -1L;
            }
            return this.loadPages / this.loads;
        }

        @Override
        public ODocument toDocument() {
            ODocument document = super.toDocument();
            OSessionStoragePerformanceStatistic.writeMetric(document, "updateEntryTime", this.getUpdateEntryTime(), OType.LONG);
            OSessionStoragePerformanceStatistic.writeMetric(document, "updateEntryPages", this.getUpdateEntryPages(), OType.LONG);
            OSessionStoragePerformanceStatistic.writeMetric(document, "deleteEntryTime", this.getDeleteEntryTime(), OType.LONG);
            OSessionStoragePerformanceStatistic.writeMetric(document, "deleteEntryPages", this.getDeleteEntryPages(), OType.LONG);
            OSessionStoragePerformanceStatistic.writeMetric(document, "readEntryTime", this.getReadEntryTime(), OType.LONG);
            OSessionStoragePerformanceStatistic.writeMetric(document, "readEntryPages", this.getReadEntryPages(), OType.LONG);
            OSessionStoragePerformanceStatistic.writeMetric(document, "loadTime", this.getLoadTime(), OType.LONG);
            OSessionStoragePerformanceStatistic.writeMetric(document, "loadPages", this.getLoadPages(), OType.LONG);
            return document;
        }

        private class LoadPages
        extends OOperation {
            private LoadPages() {
            }

            @Override
            void incrementOperationsCounter(int pages, int filePages) {
                RidbagCountersHolder ridbagCountersHolder = RidbagCountersHolder.this;
                ridbagCountersHolder.loadPages = ridbagCountersHolder.loadPages + (long)pages;
                ridbagCountersHolder = RidbagCountersHolder.this;
                ridbagCountersHolder.loadFilePages = ridbagCountersHolder.loadFilePages + (long)filePages;
            }
        }

        private class ReadEntryPages
        extends OOperation {
            private ReadEntryPages() {
            }

            @Override
            void incrementOperationsCounter(int pages, int filePages) {
                RidbagCountersHolder ridbagCountersHolder = RidbagCountersHolder.this;
                ridbagCountersHolder.readEntryPages = ridbagCountersHolder.readEntryPages + (long)pages;
                ridbagCountersHolder = RidbagCountersHolder.this;
                ridbagCountersHolder.readEntryFilePages = ridbagCountersHolder.readEntryFilePages + (long)filePages;
            }
        }

        private class DeleteEntryPages
        extends OOperation {
            private DeleteEntryPages() {
            }

            @Override
            void incrementOperationsCounter(int pages, int filePages) {
                RidbagCountersHolder ridbagCountersHolder = RidbagCountersHolder.this;
                ridbagCountersHolder.deleteEntryPages = ridbagCountersHolder.deleteEntryPages + (long)pages;
                ridbagCountersHolder = RidbagCountersHolder.this;
                ridbagCountersHolder.deleteEntryFilePages = ridbagCountersHolder.deleteEntryFilePages + (long)filePages;
            }
        }

        private class UpdateEntryOperation
        extends OOperation {
            private UpdateEntryOperation() {
            }

            @Override
            void incrementOperationsCounter(int pages, int filePages) {
                RidbagCountersHolder ridbagCountersHolder = RidbagCountersHolder.this;
                ridbagCountersHolder.updateEntryPages = ridbagCountersHolder.updateEntryPages + (long)pages;
                ridbagCountersHolder = RidbagCountersHolder.this;
                ridbagCountersHolder.updateEntryFilePages = ridbagCountersHolder.updateEntryFilePages + (long)filePages;
            }
        }
    }

    public static class IndexCountersHolder
    extends PerformanceCountersHolder {
        private long updatedEntries;
        private long timeUpdateEntry;
        private long updateEntryPages;
        private long updateEntryFilePages;
        private long updateEntryPageTime;
        private long updateEntryFilePageTime;
        private long deletedEntries;
        private long timeDeleteEntry;
        private long deleteEntryPages;
        private long deleteEntryFilePages;
        private long deleteEntryPageTime;
        private long deleteEntryFilePageTime;
        private long readEntries;
        private long timeReadEntry;
        private long readEntryPages;
        private long readEntryFilePages;
        private long readEntryPageTime;
        private long readEntryFilePageTime;

        @Override
        public IndexCountersHolder newInstance() {
            return new IndexCountersHolder();
        }

        @Override
        public void clean() {
            super.clean();
            this.updatedEntries = 0L;
            this.timeUpdateEntry = 0L;
            this.updateEntryPages = 0L;
            this.updateEntryFilePages = 0L;
            this.updateEntryPageTime = 0L;
            this.updateEntryFilePageTime = 0L;
            this.deletedEntries = 0L;
            this.timeDeleteEntry = 0L;
            this.deleteEntryPages = 0L;
            this.deleteEntryFilePages = 0L;
            this.deleteEntryPageTime = 0L;
            this.deleteEntryFilePageTime = 0L;
            this.readEntries = 0L;
            this.timeReadEntry = 0L;
            this.readEntryPages = 0L;
            this.readEntryFilePages = 0L;
            this.readEntryPageTime = 0L;
            this.readEntryFilePageTime = 0L;
        }

        public long getUpdateEntryTime() {
            if (this.updatedEntries == 0L) {
                return -1L;
            }
            return this.timeUpdateEntry / this.updatedEntries;
        }

        public long getUpdateEntryPages() {
            if (this.updatedEntries == 0L) {
                return -1L;
            }
            return this.updateEntryPages / this.updatedEntries;
        }

        public long getUpdateEntryHitRate() {
            if (this.updateEntryPages == 0L) {
                return -1L;
            }
            return (int)(100L * (this.updateEntryPages - this.updateEntryFilePages) / this.updateEntryPages);
        }

        public long getUpdateEntryPageTime() {
            if (this.updateEntryPages == 0L) {
                return -1L;
            }
            return this.updateEntryPageTime / this.updateEntryPages;
        }

        public long getUpdateEntryFilePageTime() {
            if (this.updateEntryFilePages == 0L) {
                return -1L;
            }
            return this.updateEntryFilePageTime / this.updateEntryFilePages;
        }

        public long getDeleteEntryTime() {
            if (this.deletedEntries == 0L) {
                return -1L;
            }
            return this.timeDeleteEntry / this.deletedEntries;
        }

        public long getDeleteEntryPages() {
            if (this.deletedEntries == 0L) {
                return -1L;
            }
            return this.deleteEntryPages / this.deletedEntries;
        }

        public long getDeleteEntryHitRate() {
            if (this.deleteEntryPages == 0L) {
                return -1L;
            }
            return (int)(100L * (this.deleteEntryPages - this.deleteEntryFilePages) / this.deleteEntryPages);
        }

        public long getReadEntryTime() {
            if (this.readEntries == 0L) {
                return -1L;
            }
            return this.timeReadEntry / this.readEntries;
        }

        public long getReadEntryPages() {
            if (this.readEntries == 0L) {
                return -1L;
            }
            return this.readEntryPages / this.readEntries;
        }

        @Override
        public ODocument toDocument() {
            ODocument document = super.toDocument();
            OSessionStoragePerformanceStatistic.writeMetric(document, "updateEntryTime", this.getUpdateEntryTime(), OType.LONG);
            OSessionStoragePerformanceStatistic.writeMetric(document, "updateEntryPages", this.getUpdateEntryPages(), OType.LONG);
            OSessionStoragePerformanceStatistic.writeMetric(document, "deleteEntryTime", this.getDeleteEntryTime(), OType.LONG);
            OSessionStoragePerformanceStatistic.writeMetric(document, "deleteEntryPages", this.getDeleteEntryPages(), OType.LONG);
            OSessionStoragePerformanceStatistic.writeMetric(document, "readEntryTime", this.getReadEntryTime(), OType.LONG);
            OSessionStoragePerformanceStatistic.writeMetric(document, "readEntryPages", this.getReadEntryPages(), OType.LONG);
            return document;
        }

        private class ReadEntryOperation
        extends OOperation {
            private ReadEntryOperation() {
            }

            @Override
            void incrementOperationsCounter(int pages, int filePages) {
                IndexCountersHolder indexCountersHolder = IndexCountersHolder.this;
                indexCountersHolder.readEntryPages = indexCountersHolder.readEntryPages + (long)pages;
                indexCountersHolder = IndexCountersHolder.this;
                indexCountersHolder.readEntryFilePages = indexCountersHolder.readEntryFilePages + (long)filePages;
            }
        }

        private class DeleteEntryOperation
        extends OOperation {
            private DeleteEntryOperation() {
            }

            @Override
            void incrementOperationsCounter(int pages, int filePages) {
                IndexCountersHolder indexCountersHolder = IndexCountersHolder.this;
                indexCountersHolder.deleteEntryPages = indexCountersHolder.deleteEntryPages + (long)pages;
                indexCountersHolder = IndexCountersHolder.this;
                indexCountersHolder.deleteEntryFilePages = indexCountersHolder.deleteEntryFilePages + (long)filePages;
            }
        }

        private class UpdateEntryOperation
        extends OOperation {
            private UpdateEntryOperation() {
            }

            @Override
            void incrementOperationsCounter(int pages, int filePages) {
                IndexCountersHolder indexCountersHolder = IndexCountersHolder.this;
                indexCountersHolder.updateEntryPages = indexCountersHolder.updateEntryPages + (long)pages;
                indexCountersHolder = IndexCountersHolder.this;
                indexCountersHolder.updateEntryFilePages = indexCountersHolder.updateEntryFilePages + (long)filePages;
            }
        }
    }

    public static class WritCacheCountersHolder
    implements CountersHolder<WritCacheCountersHolder> {
        private long flushOperationsCount;
        private long amountOfPagesFlushed;
        private long flushOperationsTime;
        private long fuzzyCheckpointCount;
        private long fuzzyCheckpointTime;

        @Override
        public void clean() {
            this.flushOperationsCount = 0L;
            this.amountOfPagesFlushed = 0L;
            this.flushOperationsTime = 0L;
            this.fuzzyCheckpointCount = 0L;
            this.fuzzyCheckpointTime = 0L;
        }

        @Override
        public void pushData(WritCacheCountersHolder holder) {
            holder.flushOperationsCount += this.flushOperationsCount;
            holder.amountOfPagesFlushed += this.amountOfPagesFlushed;
            holder.flushOperationsTime += this.flushOperationsTime;
            holder.fuzzyCheckpointCount += this.fuzzyCheckpointCount;
            holder.fuzzyCheckpointTime += this.fuzzyCheckpointTime;
        }

        public long getPagesPerFlush() {
            if (this.flushOperationsCount == 0L) {
                return -1L;
            }
            return this.amountOfPagesFlushed / this.flushOperationsCount;
        }

        public long getFlushOperationsTime() {
            if (this.flushOperationsCount == 0L) {
                return -1L;
            }
            return this.flushOperationsTime / this.flushOperationsCount;
        }

        public long getFuzzyCheckpointTime() {
            if (this.fuzzyCheckpointCount == 0L) {
                return -1L;
            }
            return this.fuzzyCheckpointTime / this.fuzzyCheckpointCount;
        }

        @Override
        public ODocument toDocument() {
            ODocument document = new ODocument();
            OSessionStoragePerformanceStatistic.writeMetric(document, "pagesPerFlush", this.getPagesPerFlush(), OType.LONG);
            OSessionStoragePerformanceStatistic.writeMetric(document, "flushOperationsTime", this.getFlushOperationsTime(), OType.LONG);
            OSessionStoragePerformanceStatistic.writeMetric(document, "fuzzyCheckpointTime", this.getFuzzyCheckpointTime(), OType.LONG);
            return document;
        }
    }

    public static class StorageCountersHolder
    implements CountersHolder<StorageCountersHolder> {
        private long fullCheckpointOperationsCount;
        private long fullCheckpointOperationsTime;

        @Override
        public void clean() {
            this.fullCheckpointOperationsCount = 0L;
            this.fullCheckpointOperationsTime = 0L;
        }

        @Override
        public void pushData(StorageCountersHolder holder) {
            holder.fullCheckpointOperationsCount += this.fullCheckpointOperationsCount;
            holder.fullCheckpointOperationsTime += this.fullCheckpointOperationsTime;
        }

        @Override
        public ODocument toDocument() {
            ODocument document = new ODocument();
            OSessionStoragePerformanceStatistic.writeMetric(document, "fullCheckpointTime", this.getFullCheckpointTime(), OType.LONG);
            return document;
        }

        public long getFullCheckpointTime() {
            if (this.fullCheckpointOperationsCount == 0L) {
                return -1L;
            }
            return this.fullCheckpointOperationsTime / this.fullCheckpointOperationsCount;
        }
    }

    public static class WALCountersHolder
    implements CountersHolder<WALCountersHolder> {
        private long logRecordCount;
        private long logRecordTime;
        private long startRecordCount;
        private long startRecordTime;
        private long stopRecordCount;
        private long stopRecordTime;
        private long flushCount;
        private long flushTime;

        @Override
        public void clean() {
            this.logRecordCount = 0L;
            this.logRecordTime = 0L;
            this.flushCount = 0L;
            this.flushTime = 0L;
        }

        @Override
        public void pushData(WALCountersHolder holder) {
            holder.logRecordCount += this.logRecordCount;
            holder.logRecordTime += this.logRecordTime;
            holder.flushCount += this.flushCount;
            holder.flushTime += this.flushTime;
        }

        public long getLogTime() {
            if (this.logRecordCount == 0L) {
                return -1L;
            }
            return this.logRecordTime / this.logRecordCount;
        }

        public long getStopAOTime() {
            if (this.stopRecordCount == 0L) {
                return -1L;
            }
            return this.stopRecordTime / this.stopRecordCount;
        }

        public long getStartAOTime() {
            if (this.startRecordCount == 0L) {
                return -1L;
            }
            return this.startRecordTime / this.startRecordCount;
        }

        public long getFlushTime() {
            if (this.flushCount == 0L) {
                return -1L;
            }
            return this.flushTime / this.flushCount;
        }

        @Override
        public ODocument toDocument() {
            ODocument document = new ODocument();
            OSessionStoragePerformanceStatistic.writeMetric(document, "logTime", this.getLogTime(), OType.LONG);
            OSessionStoragePerformanceStatistic.writeMetric(document, "startAOTime", this.getStartAOTime(), OType.LONG);
            OSessionStoragePerformanceStatistic.writeMetric(document, "stopAOTime", this.getStopAOTime(), OType.LONG);
            return document;
        }
    }

    public static enum ComponentType {
        GENERAL{

            @Override
            PerformanceCountersHolder newCountersHolder() {
                return new PerformanceCountersHolder();
            }
        }
        ,
        INDEX{

            @Override
            IndexCountersHolder newCountersHolder() {
                return new IndexCountersHolder();
            }
        }
        ,
        CLUSTER{

            @Override
            OClusterCountersHolder newCountersHolder() {
                return new OClusterCountersHolder();
            }
        }
        ,
        RIDBAG{

            @Override
            RidbagCountersHolder newCountersHolder() {
                return new RidbagCountersHolder();
            }
        };


        abstract PerformanceCountersHolder newCountersHolder();
    }

    private static final class Component {
        private final String name;
        private final ComponentType type;
        private int operationCount;

        Component(String name, ComponentType type) {
            this.name = name;
            this.type = type;
            this.operationCount = 1;
        }
    }

    public static interface NanoTimer {
        public long getNano();
    }
}

