/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.npm;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.npm.internal.NpmFacetUtils;
import org.sonatype.nexus.repository.npm.internal.NpmHostedFacet;
import org.sonatype.nexus.repository.npm.internal.NpmMetadataUtils;
import org.sonatype.nexus.repository.npm.internal.NpmPackageId;
import org.sonatype.nexus.repository.npm.internal.NpmPackageParser;
import org.sonatype.nexus.repository.rest.UploadDefinitionExtension;
import org.sonatype.nexus.repository.security.ContentPermissionChecker;
import org.sonatype.nexus.repository.security.VariableResolverAdapter;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.TempBlob;
import org.sonatype.nexus.repository.upload.AssetUpload;
import org.sonatype.nexus.repository.upload.ComponentUpload;
import org.sonatype.nexus.repository.upload.UploadDefinition;
import org.sonatype.nexus.repository.upload.UploadHandlerSupport;
import org.sonatype.nexus.repository.upload.UploadResponse;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.transaction.UnitOfWork;

@Singleton
@Named(value="npm")
public class NpmUploadHandler
extends UploadHandlerSupport {
    private UploadDefinition definition;
    private final ContentPermissionChecker contentPermissionChecker;
    private final VariableResolverAdapter variableResolverAdapter;
    private final NpmPackageParser npmPackageParser;

    @Inject
    public NpmUploadHandler(ContentPermissionChecker contentPermissionChecker, @Named(value="simple") VariableResolverAdapter variableResolverAdapter, NpmPackageParser npmPackageParser, Set<UploadDefinitionExtension> uploadDefinitionExtensions) {
        super(uploadDefinitionExtensions);
        this.contentPermissionChecker = contentPermissionChecker;
        this.variableResolverAdapter = (VariableResolverAdapter)Preconditions.checkNotNull((Object)variableResolverAdapter);
        this.npmPackageParser = (NpmPackageParser)((Object)Preconditions.checkNotNull((Object)((Object)npmPackageParser)));
    }

    public UploadResponse handle(Repository repository, ComponentUpload upload) throws IOException {
        NpmHostedFacet facet = (NpmHostedFacet)repository.facet(NpmHostedFacet.class);
        StorageFacet storageFacet = (StorageFacet)repository.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var6_7 = null;
        try {
            TempBlob tempBlob = storageFacet.createTempBlob((Payload)((AssetUpload)upload.getAssetUploads().get(0)).getPayload(), NpmFacetUtils.HASH_ALGORITHMS);
            Map<String, Object> packageJson = this.npmPackageParser.parsePackageJson((java.util.function.Supplier<InputStream>)tempBlob);
            String name = (String)packageJson.get("name");
            String version = (String)packageJson.get("version");
            String path = NpmMetadataUtils.createRepositoryPath(name, version);
            Map<String, String> coordinates = this.toCoordinates(packageJson);
            this.ensurePermitted(repository.getName(), "npm", path, coordinates);
            UnitOfWork.begin((Supplier)storageFacet.txSupplier());
            UploadResponse uploadResponse = new UploadResponse(facet.putPackage(packageJson, tempBlob));
            return uploadResponse;
            {
                finally {
                    UnitOfWork.end();
                }
            }
            finally {
                if (tempBlob != null) {
                    tempBlob.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Map<String, String> toCoordinates(Map<String, Object> packageJson) {
        NpmPackageId packageId = NpmPackageId.parse((String)Preconditions.checkNotNull((Object)packageJson.get("name")));
        String version = (String)Preconditions.checkNotNull((Object)packageJson.get("version"));
        if (packageId.scope() != null) {
            return ImmutableMap.of((Object)"packageScope", (Object)packageId.scope(), (Object)"packageName", (Object)packageId.name(), (Object)"version", (Object)version);
        }
        return ImmutableMap.of((Object)"packageName", (Object)packageId.name(), (Object)"version", (Object)version);
    }

    public UploadDefinition getDefinition() {
        if (this.definition == null) {
            this.definition = this.getDefinition("npm", false);
        }
        return this.definition;
    }

    public VariableResolverAdapter getVariableResolverAdapter() {
        return this.variableResolverAdapter;
    }

    public ContentPermissionChecker contentPermissionChecker() {
        return this.contentPermissionChecker;
    }
}

