/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.npm.internal;

import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.orientechnologies.orient.core.metadata.schema.OType;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.orient.entity.AttachedEntityHelper;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.npm.internal.NpmAttributes;
import org.sonatype.nexus.repository.npm.internal.NpmJsonUtils;
import org.sonatype.nexus.repository.npm.internal.NpmMetadataUtils;
import org.sonatype.nexus.repository.npm.internal.NpmPackageId;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.Query;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.storage.TempBlob;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.BlobPayload;
import org.sonatype.nexus.repository.view.payloads.BytesPayload;

public final class NpmFacetUtils {
    private static final String SQL_FIND_ALL_PACKAGE_NAMES = String.format("SELECT DISTINCT(%s) AS %s FROM asset WHERE %s = :bucketRid AND %s.%s.%s = :kind ORDER BY name", "name", "name", "bucket", "attributes", "npm", "asset_kind");
    public static final List<HashAlgorithm> HASH_ALGORITHMS = Lists.newArrayList((Object[])new HashAlgorithm[]{HashAlgorithm.SHA1});
    public static final String REPOSITORY_ROOT_ASSET = "-/all";
    public static final String REPOSITORY_SEARCH_ASSET = "-/v1/search";

    private NpmFacetUtils() {
    }

    @Nonnull
    static NestedAttributesMap parse(Supplier<InputStream> streamSupplier) throws IOException {
        return NpmJsonUtils.parse(streamSupplier);
    }

    @Nonnull
    static AssetBlob storeContent(StorageTx tx, Asset asset, Supplier<InputStream> content, NpmAttributes.AssetKind assetKind) throws IOException {
        asset.formatAttributes().set("asset_kind", (Object)assetKind.name());
        AssetBlob result = tx.createBlob(asset.name(), content, HASH_ALGORITHMS, null, assetKind.getContentType(), assetKind.isSkipContentVerification());
        tx.attachBlob(asset, result);
        return result;
    }

    @Nonnull
    static AssetBlob storeContent(StorageTx tx, Asset asset, TempBlob tempBlob, NpmAttributes.AssetKind assetKind) throws IOException {
        asset.formatAttributes().set("asset_kind", (Object)assetKind.name());
        AssetBlob result = tx.createBlob(asset.name(), tempBlob, null, assetKind.getContentType(), assetKind.isSkipContentVerification());
        tx.attachBlob(asset, result);
        return result;
    }

    @Nonnull
    static Content toContent(Asset packageRootAsset, NestedAttributesMap packageRoot) {
        Content content = new Content((Payload)new BytesPayload(NpmJsonUtils.bytes(packageRoot), "application/json"));
        Content.extractFromAsset((Asset)packageRootAsset, HASH_ALGORITHMS, (AttributesMap)content.getAttributes());
        content.getAttributes().set(NestedAttributesMap.class, (Object)packageRoot);
        return content;
    }

    @Nonnull
    public static Content toContent(Asset asset, Blob blob) {
        Content content = new Content((Payload)new BlobPayload(blob, asset.requireContentType()));
        Content.extractFromAsset((Asset)asset, HASH_ALGORITHMS, (AttributesMap)content.getAttributes());
        return content;
    }

    @Nonnull
    public static Content saveRepositoryRoot(StorageTx tx, Asset asset, Supplier<InputStream> contentSupplier, Content content) throws IOException {
        Content.applyToAsset((Asset)asset, (AttributesMap)Content.maintainLastModified((Asset)asset, (AttributesMap)content.getAttributes()));
        AssetBlob assetBlob = NpmFacetUtils.storeContent(tx, asset, contentSupplier, NpmAttributes.AssetKind.REPOSITORY_ROOT);
        tx.saveAsset(asset);
        return NpmFacetUtils.toContent(asset, assetBlob.getBlob());
    }

    @Nonnull
    static Content saveRepositoryRoot(StorageTx tx, Asset asset, TempBlob tempBlob, Content content) throws IOException {
        Content.applyToAsset((Asset)asset, (AttributesMap)Content.maintainLastModified((Asset)asset, (AttributesMap)content.getAttributes()));
        AssetBlob assetBlob = NpmFacetUtils.storeContent(tx, asset, tempBlob, NpmAttributes.AssetKind.REPOSITORY_ROOT);
        tx.saveAsset(asset);
        return NpmFacetUtils.toContent(asset, assetBlob.getBlob());
    }

    @Nonnull
    static String tarballAssetName(NpmPackageId packageId, String tarballName) {
        return String.valueOf(packageId.id()) + "/-/" + tarballName;
    }

    @Nonnull
    private static Query.Builder query(NpmPackageId packageId) {
        if (packageId.scope() != null) {
            return Query.builder().where("name").eq((Object)packageId.name()).and("group").eq((Object)packageId.scope());
        }
        return Query.builder().where("name").eq((Object)packageId.name()).and("group").isNull();
    }

    @Nonnull
    static Iterable<Component> findPackageTarballComponents(StorageTx tx, Repository repository, NpmPackageId packageId) {
        return tx.findComponents(NpmFacetUtils.query(packageId).build(), Collections.singletonList(repository));
    }

    @Nullable
    static Component findPackageTarballComponent(StorageTx tx, Repository repository, NpmPackageId packageId, String version) {
        Iterable components = tx.findComponents(NpmFacetUtils.query(packageId).and("version").eq((Object)version).build(), Collections.singletonList(repository));
        if (components.iterator().hasNext()) {
            return (Component)components.iterator().next();
        }
        return null;
    }

    @Nullable
    public static Asset findRepositoryRootAsset(StorageTx tx, Bucket bucket) {
        return tx.findAssetWithProperty("name", (Object)REPOSITORY_ROOT_ASSET, bucket);
    }

    @Nullable
    public static Asset findPackageRootAsset(StorageTx tx, Bucket bucket, NpmPackageId packageId) {
        return tx.findAssetWithProperty("name", (Object)packageId.id(), bucket);
    }

    @Nullable
    static Asset findTarballAsset(StorageTx tx, Bucket bucket, NpmPackageId packageId, String tarballName) {
        return tx.findAssetWithProperty("name", (Object)NpmFacetUtils.tarballAssetName(packageId, tarballName), bucket);
    }

    @Nonnull
    public static Iterable<NpmPackageId> findAllPackageNames(StorageTx tx, Bucket bucket) {
        HashMap<String, Object> sqlParams = new HashMap<String, Object>();
        sqlParams.put("bucketRid", AttachedEntityHelper.id((Entity)bucket));
        sqlParams.put("kind", (Object)NpmAttributes.AssetKind.PACKAGE_ROOT);
        return Iterables.transform((Iterable)tx.browse(SQL_FIND_ALL_PACKAGE_NAMES, sqlParams), input -> NpmPackageId.parse((String)input.field("name", OType.STRING)));
    }

    @Nonnull
    public static NestedAttributesMap loadPackageRoot(StorageTx tx, Asset packageRootAsset) throws IOException {
        Blob blob = tx.requireBlob(packageRootAsset.requireBlobRef());
        NestedAttributesMap metadata = NpmJsonUtils.parse((Supplier<InputStream>)((Supplier)() -> blob.getInputStream()));
        metadata.set("_id", (Object)packageRootAsset.name());
        return metadata;
    }

    static void savePackageRoot(StorageTx tx, Asset packageRootAsset, NestedAttributesMap packageRoot) throws IOException {
        packageRoot.remove("_id");
        packageRoot.remove("_attachments");
        packageRootAsset.formatAttributes().set("last_modified", (Object)NpmMetadataUtils.maintainTime(packageRoot).toDate());
        NpmFacetUtils.storeContent(tx, packageRootAsset, NpmJsonUtils.supplier(NpmJsonUtils.bytes(packageRoot)), NpmAttributes.AssetKind.PACKAGE_ROOT);
        tx.saveAsset(packageRootAsset);
    }

    static Set<String> deletePackageRoot(StorageTx tx, Repository repository, NpmPackageId packageId, boolean deleteBlobs) {
        Asset packageRootAsset = NpmFacetUtils.findPackageRootAsset(tx, tx.findBucket(repository), packageId);
        if (packageRootAsset == null) {
            return Collections.emptySet();
        }
        tx.deleteAsset(packageRootAsset, deleteBlobs);
        Iterable<Component> npmTarballs = NpmFacetUtils.findPackageTarballComponents(tx, repository, packageId);
        HashSet<String> deletedAssetNames = new HashSet<String>();
        for (Component npmTarball : npmTarballs) {
            deletedAssetNames.addAll(tx.deleteComponent(npmTarball, deleteBlobs));
        }
        return deletedAssetNames;
    }

    @Nullable
    static Content getTarballContent(StorageTx tx, Bucket bucket, NpmPackageId packageId, String tarballName) {
        Asset asset = NpmFacetUtils.findTarballAsset(tx, bucket, packageId, tarballName);
        if (asset == null) {
            return null;
        }
        Blob blob = tx.requireBlob(asset.requireBlobRef());
        Content content = new Content((Payload)new BlobPayload(blob, asset.requireContentType()));
        Content.extractFromAsset((Asset)asset, HASH_ALGORITHMS, (AttributesMap)content.getAttributes());
        return content;
    }

    @Nonnull
    static Component getOrCreateTarballComponent(StorageTx tx, Repository repository, NpmPackageId packageId, String version) {
        Component tarballComponent = NpmFacetUtils.findPackageTarballComponent(tx, repository, packageId, version);
        if (tarballComponent == null) {
            tarballComponent = ((Component)tx.createComponent(tx.findBucket(repository), repository.getFormat()).group(packageId.scope()).name(packageId.name())).version(version);
            tx.saveComponent(tarballComponent);
        }
        return tarballComponent;
    }

    static AssetBlob createTarballAssetBlob(StorageTx tx, NpmPackageId packageId, String tarballName, TempBlob tempBlob) throws IOException {
        return tx.createBlob(NpmFacetUtils.tarballAssetName(packageId, tarballName), tempBlob, null, NpmAttributes.AssetKind.TARBALL.getContentType(), NpmAttributes.AssetKind.TARBALL.isSkipContentVerification());
    }
}

