/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.npm.internal;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.elasticsearch.common.Strings;
import org.sonatype.nexus.common.app.VersionComparator;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.repository.npm.internal.NpmVersionComparator;
import org.sonatype.nexus.repository.storage.Asset;

public class NpmFormatAttributesExtractor {
    private static final String FIRST_STABLE_VERSION = "1.0.0";
    private static final VersionComparator comparator = NpmVersionComparator.versionComparator;
    private static final String NAME = "name";
    private static final String VERSION = "version";
    private static final String AUTHOR = "author";
    private static final String DESCRIPTION = "description";
    private static final String LICENSE = "license";
    private static final String KEYWORDS = "keywords";
    private static final String EMAIL = "email";
    private static final String URL = "url";
    private static final String TYPE = "type";
    private static final String REPOSITORY = "repository";
    private static final String BUGS = "bugs";
    private static final String HOMEPAGE = "homepage";
    private static final String UNSTABLE = "unstable";
    private static final String CONTRIBUTORS = "contributors";
    private static final String OS = "os";
    private static final String CPU = "cpu";
    private static final String ENGINES = "engines";
    private final Map<String, Object> packageJson;

    public NpmFormatAttributesExtractor(Map<String, Object> packageJson) {
        this.packageJson = (Map)Preconditions.checkNotNull(packageJson);
    }

    public void copyFormatAttributes(Asset asset) {
        NestedAttributesMap assetFormatAttributes = asset.formatAttributes();
        this.copyIfExists(assetFormatAttributes, "scope", this.getScope());
        this.copyIfExists(assetFormatAttributes, NAME, this.packageJson.get(NAME));
        this.copyIfExists(assetFormatAttributes, VERSION, this.packageJson.get(VERSION));
        this.copyIfExists(assetFormatAttributes, AUTHOR, this.extractPersonInfo(this.packageJson.get(AUTHOR)));
        this.copyIfExists(assetFormatAttributes, CONTRIBUTORS, this.getContributors());
        this.copyIfExists(assetFormatAttributes, DESCRIPTION, this.packageJson.get(DESCRIPTION));
        this.copyIfExists(assetFormatAttributes, LICENSE, this.getLicense());
        this.copyIfExists(assetFormatAttributes, KEYWORDS, this.extractStringCollection(this.packageJson.get(KEYWORDS)));
        this.copyIfExists(assetFormatAttributes, OS, this.extractStringCollection(this.packageJson.get(OS)));
        this.copyIfExists(assetFormatAttributes, CPU, this.extractStringCollection(this.packageJson.get(CPU)));
        this.copyIfExists(assetFormatAttributes, ENGINES, this.getEngines());
        this.copyIfExists(assetFormatAttributes, "repository_url", this.getRepositoryUrl());
        this.copyIfExists(assetFormatAttributes, "repository_type", this.getRepositoryType());
        this.copyIfExists(assetFormatAttributes, "bugs_url", this.getBugsUrl());
        this.copyIfExists(assetFormatAttributes, "bugs_email", this.getBugsEmail());
        this.copyIfExists(assetFormatAttributes, HOMEPAGE, this.getHomepage());
        boolean unstable = this.isUnstable();
        this.copyIfExists(assetFormatAttributes, "tagged_is", unstable ? UNSTABLE : "");
        this.copyIfExists(assetFormatAttributes, "tagged_not", unstable ? "" : UNSTABLE);
        this.copyIfExists(assetFormatAttributes, "search_normalized_version", this.getSearchNormalizedVersion());
    }

    @Nullable
    private String getScope() {
        String name;
        Object nameObject = this.packageJson.get(NAME);
        if (nameObject instanceof String && (name = (String)nameObject).startsWith("@") && name.contains("/")) {
            return name.substring(1, name.indexOf(47));
        }
        return null;
    }

    @Nullable
    private List<String> getContributors() {
        Object contributors = this.packageJson.get(CONTRIBUTORS);
        if (contributors instanceof List) {
            return ((List)contributors).stream().map(this::extractPersonInfo).filter(Objects::nonNull).collect(Collectors.toList());
        }
        if (contributors instanceof Map || contributors instanceof String) {
            return Collections.singletonList(this.extractPersonInfo(contributors));
        }
        return null;
    }

    @Nullable
    private Map<String, String> getEngines() {
        Object engines = this.packageJson.get(ENGINES);
        if (engines instanceof Map) {
            Map enginesMap = (Map)engines;
            return enginesMap.entrySet().stream().collect(Collectors.toMap(entry -> Objects.toString(entry.getKey()), entry -> Objects.toString(entry.getValue())));
        }
        return null;
    }

    @Nullable
    private String extractPersonInfo(Object person) {
        if (person instanceof Map) {
            Map authorMap = (Map)person;
            ArrayList<String> pieces = new ArrayList<String>();
            if (authorMap.containsKey(NAME)) {
                pieces.add(String.valueOf(authorMap.get(NAME)));
            }
            if (authorMap.containsKey(EMAIL)) {
                pieces.add(String.format("<%s>", authorMap.get(EMAIL)));
            }
            if (authorMap.containsKey(URL)) {
                pieces.add(String.format("(%s)", authorMap.get(URL)));
            }
            return String.join((CharSequence)" ", pieces);
        }
        if (person instanceof String) {
            return person.toString();
        }
        return null;
    }

    @Nullable
    private String extractStringCollection(Object strings) {
        if (strings instanceof Collection) {
            return String.join((CharSequence)" ", ((Collection)strings).stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.toList()));
        }
        if (strings instanceof String) {
            return strings.toString();
        }
        return null;
    }

    @Nullable
    private String getLicense() {
        Object license = this.packageJson.get(LICENSE);
        if (license instanceof Map) {
            Map licenseMap = (Map)license;
            if (licenseMap.containsKey(TYPE)) {
                return licenseMap.get(TYPE).toString();
            }
            return null;
        }
        if (license instanceof String) {
            return license.toString();
        }
        return null;
    }

    @Nullable
    private String getHomepage() {
        if (this.packageJson.containsKey(HOMEPAGE)) {
            return this.packageJson.get(HOMEPAGE).toString();
        }
        return null;
    }

    @Nullable
    private String getBugsUrl() {
        Object bugs = this.packageJson.get(BUGS);
        if (bugs instanceof String) {
            return (String)bugs;
        }
        return this.extractStringFromMap(BUGS, URL);
    }

    @Nullable
    private String getBugsEmail() {
        return this.extractStringFromMap(BUGS, EMAIL);
    }

    @Nullable
    private String getRepositoryUrl() {
        return this.extractStringFromMap(REPOSITORY, URL);
    }

    @Nullable
    private String getRepositoryType() {
        return this.extractStringFromMap(REPOSITORY, TYPE);
    }

    @Nullable
    private String getSearchNormalizedVersion() {
        String versionString = (String)this.packageJson.get(VERSION);
        if (versionString == null) {
            return null;
        }
        LinkedList codePoints = versionString.codePoints().boxed().collect(Collectors.toCollection(LinkedList::new));
        StringBuilder normalizedVersion = new StringBuilder();
        while (!codePoints.isEmpty()) {
            if (Character.isDigit((Integer)codePoints.peek())) {
                StringBuilder temp = new StringBuilder();
                while (!codePoints.isEmpty() && Character.isDigit((Integer)codePoints.peek())) {
                    temp.appendCodePoint((Integer)codePoints.pop());
                }
                normalizedVersion.append(Strings.padStart((String)temp.toString(), (int)5, (char)'0'));
                continue;
            }
            normalizedVersion.appendCodePoint((Integer)codePoints.pop());
        }
        return normalizedVersion.toString();
    }

    private boolean isUnstable() {
        String version;
        return !this.packageJson.containsKey(VERSION) || comparator.compare(version = (String)this.packageJson.get(VERSION), FIRST_STABLE_VERSION) < 0;
    }

    @Nullable
    private String extractStringFromMap(String mapKey, String fieldKey) {
        Map map;
        Object possibleMap = this.packageJson.get(mapKey);
        if (possibleMap instanceof Map && (map = (Map)possibleMap).containsKey(fieldKey)) {
            return map.get(fieldKey).toString();
        }
        return null;
    }

    private void copyIfExists(NestedAttributesMap attributesMap, String key, @Nullable Object value) {
        if (value != null) {
            attributesMap.set(key, value);
        }
    }

    private void copyIfExists(NestedAttributesMap attributesMap, String key, @Nullable Map<String, String> values) {
        if (values != null) {
            NestedAttributesMap child = attributesMap.child(key);
            values.forEach((arg_0, arg_1) -> ((NestedAttributesMap)child).set(arg_0, arg_1));
        }
    }
}

