/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.npm.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.orientechnologies.common.concur.ONeedRetryException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.sonatype.goodies.common.Time;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.entity.EntityHelper;
import org.sonatype.nexus.common.io.Cooperation;
import org.sonatype.nexus.common.io.CooperationFactory;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.Type;
import org.sonatype.nexus.repository.cache.CacheInfo;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.group.GroupFacetImpl;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.npm.internal.NpmFacetUtils;
import org.sonatype.nexus.repository.npm.internal.NpmHandlers;
import org.sonatype.nexus.repository.npm.internal.NpmMetadataUtils;
import org.sonatype.nexus.repository.npm.internal.NpmPackageId;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetDeletedEvent;
import org.sonatype.nexus.repository.storage.AssetEvent;
import org.sonatype.nexus.repository.storage.AssetUpdatedEvent;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalStoreBlob;
import org.sonatype.nexus.repository.transaction.TransactionalTouchBlob;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;
import org.sonatype.nexus.transaction.Transactional;
import org.sonatype.nexus.transaction.UnitOfWork;
import org.sonatype.nexus.validation.ConstraintViolationFactory;

@Named
@Facet.Exposed
public class NpmGroupFacet
extends GroupFacetImpl {
    private final boolean mergeMetadata;
    @Nullable
    private CooperationFactory.Builder cooperationBuilder;
    @Nullable
    private Cooperation packageRootCooperation;

    @Inject
    public NpmGroupFacet(@Named(value="${nexus.npm.mergeGroupMetadata:-true}") boolean mergeMetadata, RepositoryManager repositoryManager, ConstraintViolationFactory constraintViolationFactory, @Named(value="group") Type groupType) {
        super(repositoryManager, constraintViolationFactory, groupType);
        this.mergeMetadata = mergeMetadata;
    }

    @Inject
    protected void configureCooperation(CooperationFactory cooperationFactory, @Named(value="${nexus.npm.packageRoot.cooperation.enabled:-true}") boolean cooperationEnabled, @Named(value="${nexus.npm.packageRoot.cooperation.majorTimeout:-0s}") Time majorTimeout, @Named(value="${nexus.npm.packageRoot.cooperation.minorTimeout:-30s}") Time minorTimeout, @Named(value="${nexus.npm.packageRoot.cooperation.threadsPerKey:-100}") int threadsPerKey) {
        if (cooperationEnabled) {
            this.cooperationBuilder = cooperationFactory.configure().majorTimeout(majorTimeout).minorTimeout(minorTimeout).threadsPerKey(threadsPerKey);
        }
    }

    @VisibleForTesting
    void buildCooperation() {
        if (Objects.nonNull(this.cooperationBuilder)) {
            this.packageRootCooperation = this.cooperationBuilder.build(String.valueOf(this.getRepository().getName()) + ":packageRoot");
        }
    }

    protected void doInit(Configuration configuration) throws Exception {
        super.doInit(configuration);
        this.buildCooperation();
    }

    @Nullable
    public Content buildPackageRoot(Map<Repository, Response> responses, Context context) throws IOException {
        if (Objects.isNull(this.packageRootCooperation)) {
            return this.buildMergedPackageRoot(responses, context);
        }
        String requestPath = this.getRequestPath(context);
        try {
            return (Content)this.packageRootCooperation.cooperate(requestPath, failover -> {
                Content latestContent;
                if (failover && Objects.nonNull(latestContent = (Content)this.packageRootCooperation.join(() -> this.getFromCache(context)))) {
                    return latestContent;
                }
                return this.buildMergedPackageRoot(responses, context);
            });
        }
        catch (IOException e) {
            this.log.error("Unable to use Cooperation to merge {} for repository {}", new Object[]{requestPath, context.getRepository().getName(), e});
            return null;
        }
    }

    @Nullable
    public Content getFromCache(Context context) throws IOException {
        Asset packageRootAsset = this.getPackageRootAssetFromCache(context);
        if (Objects.isNull(packageRootAsset)) {
            return null;
        }
        NestedAttributesMap packageRoot = this.loadPackageRootFromCache(packageRootAsset);
        NpmMetadataUtils.rewriteTarballUrl(context.getRepository().getName(), packageRoot);
        packageRoot.remove("_id");
        packageRoot.remove("_rev");
        Content content = NpmFacetUtils.toContent(packageRootAsset, packageRoot);
        return !this.isStale(content) ? content : null;
    }

    @Nullable
    @TransactionalTouchBlob
    protected Asset getPackageRootAssetFromCache(Context context) throws IOException {
        Preconditions.checkNotNull((Object)context);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        return NpmFacetUtils.findPackageRootAsset(tx, tx.findBucket(this.getRepository()), NpmHandlers.packageId(NpmGroupFacet.matcherState(context)));
    }

    @Transactional
    protected NestedAttributesMap loadPackageRootFromCache(Asset asset) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset latest = tx.findAsset(EntityHelper.id((Entity)asset), tx.findBucket(this.getRepository()));
        return NpmFacetUtils.loadPackageRoot(tx, latest);
    }

    @Nullable
    @VisibleForTesting
    protected Content buildMergedPackageRoot(Map<Repository, Response> responses, Context context) throws IOException {
        NestedAttributesMap result;
        NpmPackageId packageId;
        Preconditions.checkNotNull(responses);
        Preconditions.checkNotNull((Object)context);
        if (responses.isEmpty()) {
            this.log.debug("Unable to create package root for repository {}. Members had no metadata to merge.", (Object)context.getRepository().getName());
            return null;
        }
        List<NestedAttributesMap> packages = responses.entrySet().stream().map(entry -> this.getNestedAttributesMap(((Response)entry.getValue()).getPayload())).filter(Objects::nonNull).collect(Collectors.toList());
        if (this.shouldServeFirstResult(packages, packageId = NpmHandlers.packageId(NpmGroupFacet.matcherState(context)))) {
            result = packages.get(0);
        } else {
            this.log.debug("Merging results from {} repositories", (Object)responses.size());
            Collections.reverse(packages);
            result = NpmMetadataUtils.merge(packages.get(0).getKey(), packages);
        }
        NpmMetadataUtils.rewriteTarballUrl(context.getRepository().getName(), result);
        return this.saveToCache(packageId, result);
    }

    protected Content saveToCache(NpmPackageId packageId, NestedAttributesMap result) throws IOException {
        Asset packageRootAsset = this.savePackageRootToCache(packageId, result);
        Content content = NpmFacetUtils.toContent(packageRootAsset, result);
        result.remove("_id");
        result.remove("_rev");
        return content;
    }

    @TransactionalStoreBlob
    protected Asset savePackageRootToCache(NpmPackageId packageId, NestedAttributesMap result) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = this.getAsset(tx, packageId);
        AttributesMap contentAttributes = Content.maintainLastModified((Asset)asset, null);
        this.maintainCacheInfo(contentAttributes);
        Content.applyToAsset((Asset)asset, (AttributesMap)contentAttributes);
        NpmFacetUtils.savePackageRoot(tx, asset, result);
        return asset;
    }

    @Subscribe
    @Guarded(by={"STARTED"})
    @AllowConcurrentEvents
    public void on(AssetDeletedEvent deleted) {
        if (this.matchingEvent((AssetEvent)deleted)) {
            this.invalidatePackageRoot((AssetEvent)deleted);
        }
    }

    @Subscribe
    @Guarded(by={"STARTED"})
    @AllowConcurrentEvents
    public void on(AssetUpdatedEvent updated) {
        if (this.matchingEvent((AssetEvent)updated) && this.hasBlobBeenUpdated(updated)) {
            this.invalidatePackageRoot((AssetEvent)updated);
        }
    }

    @Nullable
    @Transactional(retryOn={ONeedRetryException.class}, swallow={ORecordNotFoundException.class})
    protected void doInvalidate(NpmPackageId packageId) {
        Bucket bucket;
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = NpmFacetUtils.findPackageRootAsset(tx, bucket = tx.findBucket(this.getRepository()), packageId);
        if (Objects.nonNull(asset) && CacheInfo.invalidateAsset((Asset)asset)) {
            tx.saveAsset(asset);
        }
    }

    private Asset getAsset(StorageTx tx, NpmPackageId packageId) {
        Bucket bucket = tx.findBucket(this.getRepository());
        Asset asset = NpmFacetUtils.findPackageRootAsset(tx, bucket, packageId);
        if (Objects.isNull(asset)) {
            asset = (Asset)tx.createAsset(bucket, this.getRepository().getFormat()).name(packageId.id());
        }
        return asset;
    }

    @VisibleForTesting
    protected boolean shouldServeFirstResult(List<NestedAttributesMap> packages, NpmPackageId packageId) {
        return packages.size() == 1 || !this.mergeMetadata && StringUtils.isEmpty((CharSequence)packageId.scope());
    }

    @Nullable
    private NestedAttributesMap getNestedAttributesMap(Payload payload) {
        return Objects.nonNull(payload) ? (NestedAttributesMap)((Content)payload).getAttributes().get(NestedAttributesMap.class) : null;
    }

    private static TokenMatcher.State matcherState(Context context) {
        return (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
    }

    private String getRequestPath(Context context) {
        return context.getRequest().getPath().substring(1);
    }

    private boolean matchingEvent(AssetEvent event) {
        return this.matchesRepository(event) && Objects.isNull(event.getComponentId());
    }

    private boolean matchesRepository(AssetEvent event) {
        return event.isLocal() && this.member(event.getRepositoryName());
    }

    private void invalidatePackageRoot(AssetEvent event) {
        UnitOfWork.begin((Supplier)((StorageFacet)this.getRepository().facet(StorageFacet.class)).txSupplier());
        try {
            this.doInvalidate(NpmPackageId.parse(event.getAsset().name()));
        }
        finally {
            UnitOfWork.end();
        }
    }

    private boolean hasBlobBeenUpdated(AssetUpdatedEvent updated) {
        DateTime blobUpdated = updated.getAsset().blobUpdated();
        DateTime oneMinuteAgo = DateTime.now().minusMinutes(1);
        return Objects.isNull(blobUpdated) || blobUpdated.isAfter((ReadableInstant)oneMinuteAgo);
    }
}

